/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.sceneform.collision;

import com.google.ar.sceneform.math.Vector3;
import com.google.ar.sceneform.utilities.Preconditions;

public class Ray {
    private Vector3 origin = new Vector3();
    private Vector3 direction = Vector3.forward();

    public Ray() {
    }

    public Ray(Vector3 vector3, Vector3 vector32) {
        Preconditions.checkNotNull(vector3, "Parameter \"origin\" was null.");
        Preconditions.checkNotNull(vector32, "Parameter \"direction\" was null.");
        this.setOrigin(vector3);
        this.setDirection(vector32);
    }

    public void setOrigin(Vector3 vector3) {
        Preconditions.checkNotNull(vector3, "Parameter \"origin\" was null.");
        this.origin.set(vector3);
    }

    public Vector3 getOrigin() {
        return new Vector3(this.origin);
    }

    public void setDirection(Vector3 vector3) {
        Preconditions.checkNotNull(vector3, "Parameter \"direction\" was null.");
        this.direction.set(vector3.normalized());
    }

    public Vector3 getDirection() {
        return new Vector3(this.direction);
    }

    public Vector3 getPoint(float f) {
        return Vector3.add(this.origin, this.direction.scaled(f));
    }

    public String toString() {
        String string = String.valueOf(this.origin);
        String string2 = String.valueOf(this.direction);
        return new StringBuilder(21 + String.valueOf(string).length() + String.valueOf(string2).length()).append("[Origin:").append(string).append(", Direction:").append(string2).append("]").toString();
    }
}

