/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.filament;

import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import com.google.android.filament.Entity;
import com.google.android.filament.proguard.UsedByReflection;

public class EntityManager {
    private long mNativeObject = EntityManager.nGetEntityManager();

    private EntityManager() {
    }

    @NonNull
    public static EntityManager get() {
        return Holder.INSTANCE;
    }

    @Entity
    public int create() {
        return EntityManager.nCreate(this.mNativeObject);
    }

    public void destroy(@Entity int entity) {
        EntityManager.nDestroy(this.mNativeObject, entity);
    }

    @Entity
    @NonNull
    public int[] create(@IntRange(from=1L) int n) {
        if (n < 1) {
            throw new ArrayIndexOutOfBoundsException("n must be at least 1");
        }
        int[] entities = new int[n];
        EntityManager.nCreateArray(this.mNativeObject, n, entities);
        return entities;
    }

    @NonNull
    public int[] create(@Entity @NonNull int[] entities) {
        EntityManager.nCreateArray(this.mNativeObject, entities.length, entities);
        return entities;
    }

    public void destroy(@Entity @NonNull int[] entities) {
        EntityManager.nDestroyArray(this.mNativeObject, entities.length, entities);
    }

    public boolean isAlive(@Entity int entity) {
        return EntityManager.nIsAlive(this.mNativeObject, entity);
    }

    @UsedByReflection(value="AssetLoader.java")
    public long getNativeObject() {
        return this.mNativeObject;
    }

    private static native long nGetEntityManager();

    private static native void nCreateArray(long var0, int var2, int[] var3);

    private static native int nCreate(long var0);

    private static native void nDestroyArray(long var0, int var2, int[] var3);

    private static native void nDestroy(long var0, int var2);

    private static native boolean nIsAlive(long var0, int var2);

    private static class Holder {
        static final EntityManager INSTANCE = new EntityManager();

        private Holder() {
        }
    }
}

