/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.sceneform.assets;

import android.content.Context;
import android.net.Uri;
import android.util.JsonReader;
import android.util.JsonToken;
import com.google.ar.sceneform.assets.Converter;
import com.google.ar.sceneform.utilities.LoadHelper;
import com.google.ar.sceneform.utilities.Preconditions;
import com.google.sceneform_assets.w;
import com.google.sceneform_assets.z;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayDeque;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionException;

public class RenderableSource
implements Callable<InputStream> {
    private static final String MODEL_FILE_NAME = "model_source";
    private final Converter converter;
    private final Uri modelUri;
    private final SourceType sourceType;
    private final Float scale;
    private final RecenterMode recenterMode;
    private final Context context;

    private RenderableSource(Builder builder) {
        this.converter = builder.converter;
        this.context = (Context)Preconditions.checkNotNull((Object)builder.context, (Object)"Parameter \"context\" was null.");
        this.modelUri = (Uri)Preconditions.checkNotNull((Object)builder.modelUri, (Object)"Parameter \"modelUri\" was null.");
        this.sourceType = builder.sourceType;
        this.scale = builder.scale;
        this.recenterMode = builder.recenterMode;
    }

    private void downloadUri(Uri uri, File file) {
        try {
            z.a(file, new w[0]).a((InputStream)LoadHelper.fromUri((Context)this.context, (Uri)uri).call());
            return;
        }
        catch (Exception exception) {
            throw new CompletionException(exception);
        }
    }

    @Override
    public InputStream call() throws IOException, URISyntaxException {
        Object object;
        Object object2;
        Object object3;
        File file = null;
        File file2 = z.a();
        ArrayDeque<Object> arrayDeque = new ArrayDeque<Object>();
        arrayDeque.addFirst(file2);
        switch (this.sourceType.ordinal()) {
            case 1: {
                file = new File(file2, "model_source.glb");
                this.downloadUri(this.modelUri, file);
                arrayDeque.addFirst(file);
                break;
            }
            case 0: {
                file = new File(file2, "model_source.gltf");
                this.downloadUri(this.modelUri, file);
                arrayDeque.addFirst(file);
                object3 = new JsonReader((Reader)new FileReader(file));
                try {
                    object2 = new URI(this.modelUri.toString());
                    object = object3.peek();
                    while (object != JsonToken.END_DOCUMENT) {
                        switch (object) {
                            case BEGIN_ARRAY: {
                                object3.beginArray();
                                break;
                            }
                            case END_ARRAY: {
                                object3.endArray();
                                break;
                            }
                            case BEGIN_OBJECT: {
                                object3.beginObject();
                                break;
                            }
                            case END_OBJECT: {
                                object3.endObject();
                                break;
                            }
                            case NAME: {
                                String string = object3.nextName();
                                if (!string.equals("uri")) break;
                                String string2 = object3.nextString();
                                File file3 = new File(file2, string2);
                                String string3 = String.valueOf(string2);
                                Uri uri = Uri.parse((String)((URI)object2).resolve(string3.length() != 0 ? "./".concat(string3) : new String("./")).toString());
                                this.downloadUri(uri, file3);
                                arrayDeque.addFirst(file3);
                                break;
                            }
                            default: {
                                object3.skipValue();
                            }
                        }
                        object = object3.peek();
                    }
                    break;
                }
                catch (URISyntaxException uRISyntaxException) {
                    throw new IOException(uRISyntaxException);
                }
                finally {
                    object3.close();
                }
            }
        }
        if (file == null) {
            object3 = String.valueOf(this.modelUri);
            throw new IOException(new StringBuilder(35 + String.valueOf(object3).length()).append("Failed to open model file for Uri: ").append((String)object3).toString());
        }
        object3 = z.a();
        arrayDeque.addFirst(object3);
        try {
            if (this.converter.a(file.getAbsolutePath(), this.recenterMode, this.sourceType, this.scale, ((File)object3).getAbsolutePath(), file.getName())) {
                object2 = new File((File)object3, String.valueOf(file.getName()).concat(".sfb"));
                arrayDeque.addFirst(object2);
                object = new FileInputStream((File)object2);
                return object;
            }
            object2 = String.valueOf(file);
            throw new IOException(new StringBuilder(31 + String.valueOf(object2).length()).append("Failed to convert file ").append((String)object2).append(" to sfb.").toString());
        }
        finally {
            while (!arrayDeque.isEmpty()) {
                ((File)arrayDeque.removeFirst()).delete();
            }
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final Converter defaultConverter = new Converter();
        Converter converter = defaultConverter;
        private Uri modelUri = null;
        private SourceType sourceType = SourceType.GLTF2;
        private Float scale = null;
        private RecenterMode recenterMode = RecenterMode.ROOT;
        private Context context;

        public Builder() {
        }

        public final RenderableSource build() {
            if (this.modelUri == null) {
                throw new IllegalStateException("Cannot build a RenderableSource without a modelUri.");
            }
            return new RenderableSource(this);
        }

        public final Builder setSource(Context context, Uri uri, SourceType sourceType) {
            this.context = (Context)Preconditions.checkNotNull((Object)context, (Object)"Parameter \"context\" was null.");
            this.modelUri = (Uri)Preconditions.checkNotNull((Object)uri, (Object)"Parameter \"modelUri\" was null.");
            this.sourceType = sourceType;
            return this;
        }

        public final Builder setScale(float f2) {
            this.scale = Float.valueOf(f2);
            return this;
        }

        public final Builder setRecenterMode(RecenterMode recenterMode) {
            this.recenterMode = recenterMode;
            return this;
        }
    }

    public static enum SourceType {
        GLTF2,
        GLB;


        private SourceType() {
        }
    }

    public static enum RecenterMode {
        NONE,
        CENTER,
        ROOT;


        private RecenterMode() {
        }
    }
}

