/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.core;

import com.google.ar.core.Anchor;
import com.google.ar.core.Pose;
import com.google.ar.core.Session;
import com.google.ar.core.Trackable;
import com.google.ar.core.TrackingState;
import com.google.ar.core.annotations.UsedByNative;
import java.util.Collection;

@UsedByNative(value="trackable_base_jni.cc")
class TrackableBase
implements Trackable {
    long nativeHandle;
    protected final Session session;
    protected final long nativeSymbolTableHandle;

    TrackableBase(long l2, Session session) {
        this.session = session;
        this.nativeHandle = l2;
        this.nativeSymbolTableHandle = session == null ? 0L : session.nativeSymbolTableHandle;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TrackableBase)) {
            return false;
        }
        TrackableBase trackableBase = (TrackableBase)object;
        return trackableBase.nativeHandle == this.nativeHandle;
    }

    public int hashCode() {
        return Long.valueOf(this.nativeHandle).hashCode();
    }

    protected void finalize() throws Throwable {
        if (this.nativeHandle != 0L) {
            TrackableBase.nativeReleaseTrackable(this.nativeSymbolTableHandle, this.nativeHandle);
            this.nativeHandle = 0L;
        }
        super.finalize();
    }

    @Override
    public TrackingState getTrackingState() {
        return TrackingState.forNumber(this.nativeGetTrackingState(this.session.nativeWrapperHandle, this.nativeHandle));
    }

    @Override
    public Anchor createAnchor(Pose pose) {
        return new Anchor(this.nativeCreateAnchor(this.session.nativeWrapperHandle, this.nativeHandle, pose), this.session);
    }

    @Override
    public Collection<Anchor> getAnchors() {
        return this.session.convertNativeAnchorsToCollection(this.nativeGetAnchors(this.session.nativeWrapperHandle, this.nativeHandle));
    }

    static void internalReleaseNativeHandle(long l2, long l3) {
        TrackableBase.nativeReleaseTrackable(l2, l3);
    }

    static int internalGetType(long l2, long l3) {
        return TrackableBase.nativeGetType(l2, l3);
    }

    private static native void nativeReleaseTrackable(long var0, long var2);

    private static native int nativeGetType(long var0, long var2);

    private native int nativeGetTrackingState(long var1, long var3);

    private native long nativeCreateAnchor(long var1, long var3, Pose var5);

    private native long[] nativeGetAnchors(long var1, long var3);
}

