/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.core;

import android.content.Context;
import android.os.Build;
import com.google.ar.core.Anchor;
import com.google.ar.core.ArImage;
import com.google.ar.core.AugmentedFace;
import com.google.ar.core.AugmentedImage;
import com.google.ar.core.CameraConfig;
import com.google.ar.core.CameraConfigFilter;
import com.google.ar.core.Config;
import com.google.ar.core.Frame;
import com.google.ar.core.ImageMetadata;
import com.google.ar.core.Plane;
import com.google.ar.core.Point;
import com.google.ar.core.Pose;
import com.google.ar.core.SharedCamera;
import com.google.ar.core.Trackable;
import com.google.ar.core.TrackableBase;
import com.google.ar.core.ad;
import com.google.ar.core.ae;
import com.google.ar.core.af;
import com.google.ar.core.ag;
import com.google.ar.core.ah;
import com.google.ar.core.ai;
import com.google.ar.core.annotations.UsedByNative;
import com.google.ar.core.exceptions.AnchorNotSupportedForHostingException;
import com.google.ar.core.exceptions.CameraNotAvailableException;
import com.google.ar.core.exceptions.CloudAnchorsNotConfiguredException;
import com.google.ar.core.exceptions.DataInvalidFormatException;
import com.google.ar.core.exceptions.DataUnsupportedVersionException;
import com.google.ar.core.exceptions.DeadlineExceededException;
import com.google.ar.core.exceptions.FatalException;
import com.google.ar.core.exceptions.ImageInsufficientQualityException;
import com.google.ar.core.exceptions.MissingGlContextException;
import com.google.ar.core.exceptions.NotTrackingException;
import com.google.ar.core.exceptions.NotYetAvailableException;
import com.google.ar.core.exceptions.ResourceExhaustedException;
import com.google.ar.core.exceptions.SessionNotPausedException;
import com.google.ar.core.exceptions.SessionPausedException;
import com.google.ar.core.exceptions.TextureNotSetException;
import com.google.ar.core.exceptions.UnavailableApkTooOldException;
import com.google.ar.core.exceptions.UnavailableArcoreNotInstalledException;
import com.google.ar.core.exceptions.UnavailableDeviceNotCompatibleException;
import com.google.ar.core.exceptions.UnavailableSdkTooOldException;
import com.google.ar.core.exceptions.UnavailableUserDeclinedInstallationException;
import com.google.ar.core.exceptions.UnsupportedConfigurationException;
import com.google.ar.core.j;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;

public class Session {
    private static final String TAG = "ARCore-Session";
    long nativeWrapperHandle;
    final long nativeSymbolTableHandle;
    final j faceCache = new j();
    private SharedCamera sharedCamera = null;

    public Session(Context context) throws UnavailableArcoreNotInstalledException, UnavailableApkTooOldException, UnavailableSdkTooOldException, UnavailableDeviceNotCompatibleException {
        this(context, EnumSet.noneOf(Feature.class));
    }

    public Session(Context context, Set<Feature> set) throws UnavailableArcoreNotInstalledException, UnavailableApkTooOldException, UnavailableSdkTooOldException, UnavailableDeviceNotCompatibleException, IllegalArgumentException {
        System.loadLibrary("arcore_sdk_jni");
        int[] nArray = new int[set.size() + 1];
        int n2 = 0;
        for (Feature feature : set) {
            nArray[n2] = feature.nativeCode;
            ++n2;
        }
        nArray[n2] = b.a.b;
        this.nativeWrapperHandle = Session.nativeCreateSessionAndWrapperWithFeatures(context, nArray);
        this.nativeSymbolTableHandle = this.nativeGetSymbolTable(this.nativeWrapperHandle);
        if (set.contains((Object)Feature.SHARED_CAMERA)) {
            this.sharedCamera = new SharedCamera(this);
        }
        Session.loadDynamicSymbolsAfterSessionCreate();
    }

    Session(long l2) {
        this.nativeWrapperHandle = l2;
        this.nativeSymbolTableHandle = this.nativeGetSymbolTable(this.nativeWrapperHandle);
    }

    protected Session() {
        this.nativeWrapperHandle = 0L;
        this.nativeSymbolTableHandle = 0L;
    }

    @Deprecated
    public static Session createForSharedCamera(Context context) throws UnavailableArcoreNotInstalledException, UnavailableApkTooOldException, UnavailableSdkTooOldException, UnavailableDeviceNotCompatibleException {
        return new Session(context, EnumSet.of(Feature.SHARED_CAMERA));
    }

    public SharedCamera getSharedCamera() {
        if (this.sharedCamera == null) {
            throw new IllegalStateException("Shared camera is not in use, please create session using new Session(context, EnumSet.of(Session.Feature.SHARED_CAMERA)).");
        }
        return this.sharedCamera;
    }

    protected void finalize() throws Throwable {
        if (this.nativeWrapperHandle != 0L) {
            this.nativeDestroySessionWrapper(this.nativeWrapperHandle);
            this.nativeWrapperHandle = 0L;
        }
        super.finalize();
    }

    public void close() {
        this.nativeCloseSession(this.nativeWrapperHandle);
    }

    Trackable createTrackable(long l2) {
        c c2;
        c c3;
        block2: {
            int n2 = TrackableBase.internalGetType(this.nativeWrapperHandle, l2);
            for (c c4 : c.values()) {
                if (c4.b != n2) continue;
                c3 = c4;
                break block2;
            }
            c3 = c2 = null;
        }
        if (c3 == null) {
            TrackableBase.internalReleaseNativeHandle(this.nativeSymbolTableHandle, l2);
            return null;
        }
        return c2.a(l2, this);
    }

    public void configure(Config config) {
        this.nativeConfigure(this.nativeWrapperHandle, config.nativeHandle);
    }

    public Config getConfig() {
        Config config = new Config(this);
        this.getConfig(config);
        return config;
    }

    public void getConfig(Config config) {
        this.nativeGetConfig(this.nativeWrapperHandle, config.nativeHandle);
    }

    public void resume() throws CameraNotAvailableException {
        this.nativeResume(this.nativeWrapperHandle);
    }

    boolean isSharedCameraUsed() {
        return this.sharedCamera != null;
    }

    public Frame update() throws CameraNotAvailableException {
        Frame frame = new Frame(this);
        this.nativeUpdate(this.nativeWrapperHandle, frame.nativeHandle);
        return frame;
    }

    public void pause() {
        this.pauseSharedCameraIfInUse();
        this.nativePause(this.nativeWrapperHandle);
    }

    private void pauseSharedCameraIfInUse() {
        if (this.sharedCamera != null) {
            this.sharedCamera.pause();
        }
    }

    public void setCameraTextureName(int n2) {
        this.nativeSetCameraTextureName(this.nativeWrapperHandle, n2);
    }

    public void setDisplayGeometry(int n2, int n3, int n4) {
        this.nativeSetDisplayGeometry(this.nativeWrapperHandle, n2, n3, n4);
    }

    @Deprecated
    public boolean isSupported(Config config) {
        return this.nativeIsSupported(this.nativeWrapperHandle, config.nativeHandle);
    }

    public Collection<Anchor> getAllAnchors() {
        return this.convertNativeAnchorsToCollection(this.nativeAcquireAllAnchors(this.nativeWrapperHandle));
    }

    public <T extends Trackable> Collection<T> getAllTrackables(Class<T> clazz) {
        c c2 = c.a(clazz);
        if (c2 == c.a) {
            return Collections.emptyList();
        }
        long[] lArray = this.nativeAcquireAllTrackables(this.nativeWrapperHandle, c2.b);
        return this.convertNativeTrackablesToCollection(clazz, lArray);
    }

    public Anchor createAnchor(Pose pose) {
        long l2 = this.nativeCreateAnchor(this.nativeWrapperHandle, pose);
        return new Anchor(l2, this);
    }

    public Anchor hostCloudAnchor(Anchor anchor) {
        long l2 = this.nativeHostCloudAnchor(this.nativeWrapperHandle, anchor.nativeHandle);
        return new Anchor(l2, this);
    }

    public Anchor resolveCloudAnchor(String string2) {
        long l2 = this.nativeResolveCloudAnchor(this.nativeWrapperHandle, string2);
        return new Anchor(l2, this);
    }

    Collection<Anchor> convertNativeAnchorsToCollection(long[] lArray) {
        ArrayList<Anchor> arrayList = new ArrayList<Anchor>(lArray.length);
        long[] lArray2 = lArray;
        int n2 = lArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            long l2 = lArray2[i2];
            arrayList.add(new Anchor(l2, this));
        }
        return Collections.unmodifiableList(arrayList);
    }

    <T extends Trackable> Collection<T> convertNativeTrackablesToCollection(Class<T> clazz, long[] lArray) {
        ArrayList<Trackable> arrayList = new ArrayList<Trackable>(lArray.length);
        long[] lArray2 = lArray;
        int n2 = lArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            long l2 = lArray2[i2];
            Trackable trackable = this.createTrackable(l2);
            if (trackable == null) continue;
            arrayList.add((Trackable)clazz.cast(trackable));
        }
        return Collections.unmodifiableList(arrayList);
    }

    @Deprecated
    public List<CameraConfig> getSupportedCameraConfigs() {
        long[] lArray = this.nativeGetSupportedCameraConfigs(this.nativeWrapperHandle);
        return this.convertNativeCameraConfigsToCollection(lArray);
    }

    public List<CameraConfig> getSupportedCameraConfigs(CameraConfigFilter cameraConfigFilter) {
        if (cameraConfigFilter == null) {
            throw new IllegalArgumentException();
        }
        long[] lArray = this.nativeGetSupportedCameraConfigsWithFilter(this.nativeWrapperHandle, cameraConfigFilter != null ? cameraConfigFilter.nativeHandle : 0L);
        ArrayList<CameraConfig> arrayList = new ArrayList<CameraConfig>(lArray.length);
        long[] lArray2 = lArray;
        int n2 = lArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            long l2 = lArray2[i2];
            CameraConfig cameraConfig = new CameraConfig(this, l2);
            arrayList.add(cameraConfig);
        }
        return Collections.unmodifiableList(arrayList);
    }

    public void setCameraConfig(CameraConfig cameraConfig) {
        this.nativeSetCameraConfig(this.nativeWrapperHandle, cameraConfig.nativeHandle);
    }

    public CameraConfig getCameraConfig() {
        long l2 = this.nativeGetCameraConfig(this.nativeWrapperHandle);
        CameraConfig cameraConfig = new CameraConfig(this, l2);
        return cameraConfig;
    }

    List<CameraConfig> convertNativeCameraConfigsToCollection(long[] lArray) {
        ArrayList<CameraConfig> arrayList = new ArrayList<CameraConfig>(lArray.length);
        long[] lArray2 = lArray;
        int n2 = lArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            long l2 = lArray2[i2];
            CameraConfig cameraConfig = new CameraConfig(this, l2);
            arrayList.add(cameraConfig);
        }
        return Collections.unmodifiableList(arrayList);
    }

    static void throwExceptionFromArStatus(int n2) throws Exception {
        Session.throwExceptionFromArStatus(null, n2, null, null);
    }

    @UsedByNative(value="session_jni.cc")
    static void throwExceptionFromArStatus(String string2, int n2, String[] stringArray, int[] nArray) throws Exception {
        int n3;
        String string3;
        a a22;
        block10: {
            int n4 = n2;
            for (a a22 : a.values()) {
                if (a22.j != n4) {
                    continue;
                }
                break block10;
            }
            throw new FatalException(new StringBuilder(34).append("Unexpected error code: ").append(n4).toString());
        }
        a a3 = a22;
        if (a3.k == null) {
            return;
        }
        int n5 = stringArray == null || nArray == null || stringArray.length != nArray.length ? 0 : stringArray.length;
        if (a3.l == null && string2 == null) {
            throw a3.k.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        if (a3.l == null && string2 != null) {
            string3 = string2;
        } else if (a3.l != null && string2 == null) {
            string3 = a3.l;
        } else {
            String string4 = String.valueOf(a3.l);
            String string5 = String.valueOf(string2);
            string3 = string5.length() != 0 ? string4.concat(string5) : new String(string4);
        }
        String string6 = string3;
        Exception exception = a3.k.getConstructor(String.class).newInstance(string6);
        StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
        StackTraceElement[] stackTraceElementArray2 = new StackTraceElement[n5 + stackTraceElementArray.length];
        for (n3 = 0; n3 < n5; ++n3) {
            stackTraceElementArray2[n3] = new StackTraceElement("ARCore", "native", stringArray[n3], nArray[n3]);
        }
        StackTraceElement[] stackTraceElementArray3 = stackTraceElementArray;
        int n6 = stackTraceElementArray.length;
        for (int i2 = 0; i2 < n6; ++i2) {
            StackTraceElement stackTraceElement;
            stackTraceElementArray2[n3] = stackTraceElement = stackTraceElementArray3[i2];
            ++n3;
        }
        exception.setStackTrace(stackTraceElementArray2);
        throw exception;
    }

    static void loadDynamicSymbolsAfterSessionCreate() {
        if (Build.VERSION.SDK_INT >= 24) {
            ArImage.nativeLoadSymbols();
            ImageMetadata.nativeLoadSymbols();
        }
    }

    static ByteBuffer directByteBufferOrDefault(ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            return ByteBuffer.allocateDirect(0).order(ByteOrder.nativeOrder());
        }
        return byteBuffer.order(ByteOrder.nativeOrder());
    }

    private static native long nativeCreateSessionAndWrapperWithFeatures(Context var0, int[] var1) throws UnavailableArcoreNotInstalledException, UnavailableApkTooOldException, UnavailableSdkTooOldException, UnavailableDeviceNotCompatibleException;

    native void nativeDestroySessionWrapper(long var1);

    private native void nativeCloseSession(long var1);

    private native long nativeGetSymbolTable(long var1);

    private native boolean nativeIsSupported(long var1, long var3);

    private native void nativeConfigure(long var1, long var3);

    private native void nativeGetConfig(long var1, long var3);

    private native void nativeGetRandomAccessStats(long var1, long var3);

    private native void nativeResume(long var1);

    private native void nativePause(long var1);

    private native void nativeSetCameraTextureName(long var1, int var3);

    private native void nativeSetDisplayGeometry(long var1, int var3, int var4, int var5);

    private native void nativeUpdate(long var1, long var3);

    private native long nativeCreateAnchor(long var1, Pose var3);

    private native long[] nativeAcquireAllAnchors(long var1);

    native long[] nativeAcquireAllTrackables(long var1, int var3);

    private native long nativeHostCloudAnchor(long var1, long var3);

    private native long nativeResolveCloudAnchor(long var1, String var3);

    private native long[] nativeGetSupportedCameraConfigsWithFilter(long var1, long var3);

    private native long[] nativeGetSupportedCameraConfigs(long var1);

    private native int nativeSetCameraConfig(long var1, long var3);

    private native long nativeGetCameraConfig(long var1);

    static native long nativeCreateSessionWrapperFromHandle(long var0, long var2);

    native long nativeReleaseSessionOwnership(long var1);

    native long nativeGetSessionNativeHandle(long var1);

    static final class a
    extends Enum<a> {
        public static final /* enum */ a a = new a(0, null);
        public static final /* enum */ a b = new a(-1, IllegalArgumentException.class);
        public static final /* enum */ a c = new a(-2, FatalException.class);
        private static final /* enum */ a m = new a(-3, SessionPausedException.class);
        private static final /* enum */ a n = new a(-4, SessionNotPausedException.class);
        private static final /* enum */ a o = new a(-5, NotTrackingException.class);
        private static final /* enum */ a p = new a(-6, TextureNotSetException.class);
        private static final /* enum */ a q = new a(-7, MissingGlContextException.class);
        private static final /* enum */ a r = new a(-8, UnsupportedConfigurationException.class);
        private static final /* enum */ a s = new a(-9, SecurityException.class, "Camera permission is not granted");
        private static final /* enum */ a t = new a(-10, DeadlineExceededException.class);
        public static final /* enum */ a d = new a(-11, ResourceExhaustedException.class);
        private static final /* enum */ a u = new a(-12, NotYetAvailableException.class);
        private static final /* enum */ a v = new a(-13, CameraNotAvailableException.class);
        private static final /* enum */ a w = new a(-16, AnchorNotSupportedForHostingException.class);
        private static final /* enum */ a x = new a(-17, ImageInsufficientQualityException.class);
        private static final /* enum */ a y = new a(-18, DataInvalidFormatException.class);
        private static final /* enum */ a z = new a(-19, DataUnsupportedVersionException.class);
        private static final /* enum */ a A = new a(-20, IllegalStateException.class);
        private static final /* enum */ a B = new a(-14, CloudAnchorsNotConfiguredException.class);
        private static final /* enum */ a C = new a(-15, SecurityException.class, "Internet permission is not granted");
        public static final /* enum */ a e = new a(-100, UnavailableArcoreNotInstalledException.class);
        public static final /* enum */ a f = new a(-101, UnavailableDeviceNotCompatibleException.class);
        public static final /* enum */ a g = new a(-103, UnavailableApkTooOldException.class);
        public static final /* enum */ a h = new a(-104, UnavailableSdkTooOldException.class);
        public static final /* enum */ a i = new a(-105, UnavailableUserDeclinedInstallationException.class);
        final int j;
        final Class<? extends Exception> k;
        final String l;
        private static final /* synthetic */ a[] D;

        public static a[] values() {
            return (a[])D.clone();
        }

        private a(int n3, Class<? extends Exception> clazz) {
            this(n3, clazz, null);
        }

        private a(int n3, Class<? extends Exception> clazz, String string3) {
            this.j = n3;
            this.k = clazz;
            this.l = string3;
        }

        static {
            D = new a[]{a, b, c, m, n, o, p, q, r, s, t, d, u, v, w, x, y, z, A, B, C, e, f, g, h, i};
        }
    }

    static abstract class c
    extends Enum<c> {
        private static final /* enum */ c c = new ad(1095893248, Trackable.class);
        public static final /* enum */ c a = new af(-1, null);
        private static final /* enum */ c d = new ae(1095893249, Plane.class);
        private static final /* enum */ c e = new ah(1095893250, Point.class);
        private static final /* enum */ c f = new ag(1095893252, AugmentedImage.class);
        private static final /* enum */ c g = new ai(1095893253, AugmentedFace.class);
        final int b;
        private final Class<?> h;
        private static final /* synthetic */ c[] i;

        public static c[] values() {
            return (c[])i.clone();
        }

        private c(int n3, Class<? extends Trackable> clazz) {
            this.b = n3;
            this.h = clazz;
        }

        public abstract Trackable a(long var1, Session var3);

        public static c a(Class<? extends Trackable> clazz) {
            for (c c2 : com.google.ar.core.Session$c.values()) {
                if (c2.h == null || !c2.h.equals(clazz)) continue;
                return c2;
            }
            return a;
        }

        /* synthetic */ c(String string2, int n2, int n3, Class clazz, byte by) {
            this(n3, clazz);
        }

        static {
            i = new c[]{c, a, d, e, f, g};
        }
    }

    static final class b
    extends Enum<b> {
        public static final /* enum */ b a = new b(0);
        final int b;
        private static final /* synthetic */ b[] c;

        public static b[] values() {
            return (b[])c.clone();
        }

        private b(int n3) {
            this.b = 0;
        }

        static {
            c = new b[]{a};
        }
    }

    public static enum Feature {
        FRONT_CAMERA(1),
        SHARED_CAMERA(1000);

        final int nativeCode;

        private Feature(int n3) {
            this.nativeCode = n3;
        }
    }
}

