/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.core;

import com.google.ar.core.annotations.UsedByNative;

@UsedByNative(value="session_jni_wrapper.cc")
class Quaternion {
    public static final Quaternion a = new Quaternion();
    @UsedByNative(value="session_jni_wrapper.cc")
    private float x = 0.0f;
    @UsedByNative(value="session_jni_wrapper.cc")
    private float y = 0.0f;
    @UsedByNative(value="session_jni_wrapper.cc")
    private float z = 0.0f;
    @UsedByNative(value="session_jni_wrapper.cc")
    private float w = 1.0f;

    public Quaternion() {
        this.a(0.0f, 0.0f, 0.0f, 1.0f);
    }

    private Quaternion(Quaternion quaternion) {
        this.a(quaternion.x, quaternion.y, quaternion.z, quaternion.w);
    }

    @UsedByNative(value="session_jni_wrapper.cc")
    public Quaternion(float f2, float f3, float f4, float f5) {
        this.a(f2, f3, f4, f5);
    }

    private final void a(float f2, float f3, float f4, float f5) {
        this.x = f2;
        this.y = f3;
        this.z = f4;
        this.w = f5;
    }

    public final float a() {
        return this.x;
    }

    public final float b() {
        return this.y;
    }

    public final float c() {
        return this.z;
    }

    public final float d() {
        return this.w;
    }

    public final void a(float[] fArray, int n2) {
        fArray[n2] = this.x;
        fArray[n2 + 1] = this.y;
        fArray[n2 + 2] = this.z;
        fArray[n2 + 3] = this.w;
    }

    public final Quaternion e() {
        return new Quaternion(-this.x, -this.y, -this.z, this.w);
    }

    public final Quaternion a(Quaternion quaternion) {
        Quaternion quaternion2;
        Quaternion quaternion3 = quaternion2 = new Quaternion();
        Quaternion quaternion4 = quaternion;
        Quaternion quaternion5 = this;
        quaternion3.x = quaternion5.x * quaternion4.w + quaternion5.y * quaternion4.z - quaternion5.z * quaternion4.y + quaternion5.w * quaternion4.x;
        quaternion3.y = -quaternion5.x * quaternion4.z + quaternion5.y * quaternion4.w + quaternion5.z * quaternion4.x + quaternion5.w * quaternion4.y;
        quaternion3.z = quaternion5.x * quaternion4.y - quaternion5.y * quaternion4.x + quaternion5.z * quaternion4.w + quaternion5.w * quaternion4.z;
        quaternion3.w = -quaternion5.x * quaternion4.x - quaternion5.y * quaternion4.y - quaternion5.z * quaternion4.z + quaternion5.w * quaternion4.w;
        return quaternion2;
    }

    public static Quaternion a(Quaternion quaternion, Quaternion quaternion2, float f2) {
        float f3;
        float f4;
        float f5;
        float f6;
        Quaternion quaternion3 = new Quaternion();
        float f7 = quaternion.x * quaternion2.x + quaternion.y * quaternion2.y + quaternion.z * quaternion2.z + quaternion.w * quaternion2.w;
        if (f6 < 0.0f) {
            quaternion2 = new Quaternion(quaternion2);
            f7 = -f7;
            quaternion2.x = -quaternion2.x;
            quaternion2.y = -quaternion2.y;
            quaternion2.z = -quaternion2.z;
            quaternion2.w = -quaternion2.w;
        }
        float f8 = (float)Math.acos(f7);
        float f9 = (float)Math.sqrt(1.0f - f7 * f7);
        if ((double)Math.abs(f5) > 0.001) {
            float f10 = 1.0f / f9;
            f4 = (float)Math.sin((1.0f - f2) * f8) * f10;
            f3 = (float)Math.sin(f2 * f8) * f10;
        } else {
            f4 = 1.0f - f2;
            f3 = f2;
        }
        quaternion3.x = f4 * quaternion.x + f3 * quaternion2.x;
        quaternion3.y = f4 * quaternion.y + f3 * quaternion2.y;
        quaternion3.z = f4 * quaternion.z + f3 * quaternion2.z;
        quaternion3.w = f4 * quaternion.w + f3 * quaternion2.w;
        Quaternion quaternion4 = quaternion3;
        float f11 = (float)(1.0 / Math.sqrt(quaternion4.x * quaternion4.x + quaternion4.y * quaternion4.y + quaternion4.z * quaternion4.z + quaternion4.w * quaternion4.w));
        quaternion4.x *= f11;
        quaternion4.y *= f11;
        quaternion4.z *= f11;
        quaternion4.w *= f11;
        return quaternion3;
    }

    public final void a(float[] fArray, int n2, int n3) {
        float f2;
        float f3 = this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w;
        float f4 = f2 > 0.0f ? 2.0f / f3 : 0.0f;
        float f5 = this.x * f4;
        float f6 = this.y * f4;
        float f7 = this.z * f4;
        float f8 = this.w * f5;
        float f9 = this.w * f6;
        float f10 = this.w * f7;
        float f11 = this.x * f5;
        float f12 = this.x * f6;
        float f13 = this.x * f7;
        float f14 = this.y * f6;
        float f15 = this.y * f7;
        float f16 = this.z * f7;
        fArray[n2] = 1.0f - (f14 + f16);
        fArray[n2 + 4] = f12 - f10;
        fArray[n2 + 8] = f13 + f9;
        fArray[n2 + 1] = f12 + f10;
        fArray[n2 + 1 + 4] = 1.0f - (f11 + f16);
        fArray[n2 + 1 + 8] = f15 - f8;
        fArray[n2 + 2] = f13 - f9;
        fArray[n2 + 2 + 4] = f15 + f8;
        fArray[n2 + 2 + 8] = 1.0f - (f11 + f14);
    }

    public static void a(Quaternion quaternion, float[] fArray, int n2, float[] fArray2, int n3) {
        float f2 = fArray[n2];
        float f3 = fArray[n2 + 1];
        float f4 = fArray[n2 + 2];
        Quaternion quaternion2 = quaternion;
        float f5 = quaternion2.x;
        quaternion2 = quaternion;
        float f6 = quaternion2.y;
        quaternion2 = quaternion;
        float f7 = quaternion2.z;
        quaternion2 = quaternion;
        float f8 = quaternion2.w;
        float f9 = f8 * f2 + f6 * f4 - f7 * f3;
        float f10 = f8 * f3 + f7 * f2 - f5 * f4;
        float f11 = f8 * f4 + f5 * f3 - f6 * f2;
        float f12 = -f5 * f2 - f6 * f3 - f7 * f4;
        fArray2[n3] = f9 * f8 + f12 * -f5 + f10 * -f7 - f11 * -f6;
        fArray2[n3 + 1] = f10 * f8 + f12 * -f6 + f11 * -f5 - f9 * -f7;
        fArray2[n3 + 2] = f11 * f8 + f12 * -f7 + f9 * -f6 - f10 * -f5;
    }

    public String toString() {
        return String.format("[%.3f, %.3f, %.3f, %.3f]", Float.valueOf(this.x), Float.valueOf(this.y), Float.valueOf(this.z), Float.valueOf(this.w));
    }
}

