/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.core;

import com.google.ar.core.Session;
import com.google.ar.core.exceptions.DeadlineExceededException;
import java.io.Closeable;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;

public class PointCloud
implements Closeable {
    private final Session session;
    private final long nativeSymbolTableHandle;
    private long nativeHandle = 0L;

    PointCloud(Session session, long l2) {
        this.session = session;
        this.nativeHandle = l2;
        this.nativeSymbolTableHandle = session.nativeSymbolTableHandle;
    }

    protected PointCloud() {
        this.session = null;
        this.nativeHandle = 0L;
        this.nativeSymbolTableHandle = 0L;
    }

    public void release() {
        this.nativeReleasePointCloud(this.nativeSymbolTableHandle, this.nativeHandle);
        this.nativeHandle = 0L;
    }

    protected void finalize() throws Throwable {
        if (this.nativeHandle != 0L) {
            this.nativeReleasePointCloud(this.nativeSymbolTableHandle, this.nativeHandle);
        }
        super.finalize();
    }

    public FloatBuffer getPoints() {
        if (this.nativeHandle == 0L) {
            throw new DeadlineExceededException();
        }
        return Session.directByteBufferOrDefault(this.nativeGetData(this.session.nativeWrapperHandle, this.nativeHandle)).asFloatBuffer();
    }

    public IntBuffer getIds() {
        if (this.nativeHandle == 0L) {
            throw new DeadlineExceededException();
        }
        return Session.directByteBufferOrDefault(this.nativeGetIds(this.session.nativeWrapperHandle, this.nativeHandle)).asIntBuffer();
    }

    public long getTimestamp() {
        if (this.nativeHandle == 0L) {
            throw new DeadlineExceededException();
        }
        return this.nativeGetTimestamp(this.session.nativeWrapperHandle, this.nativeHandle);
    }

    @Override
    public void close() {
        this.release();
    }

    private native ByteBuffer nativeGetData(long var1, long var3);

    private native ByteBuffer nativeGetIds(long var1, long var3);

    private native long nativeGetTimestamp(long var1, long var3);

    private native void nativeReleasePointCloud(long var1, long var3);
}

