/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.core;

import com.google.ar.core.Pose;
import com.google.ar.core.Session;
import com.google.ar.core.TrackableBase;
import com.google.ar.core.exceptions.FatalException;
import java.nio.FloatBuffer;

public class Plane
extends TrackableBase {
    Plane(long l2, Session session) {
        super(l2, session);
    }

    protected Plane() {
        super(0L, null);
    }

    public Type getType() {
        return Type.forNumber(this.nativeGetType(this.session.nativeWrapperHandle, this.nativeHandle));
    }

    public Plane getSubsumedBy() {
        long l2 = this.nativeAcquireSubsumedBy(this.session.nativeWrapperHandle, this.nativeHandle);
        if (l2 == 0L) {
            return null;
        }
        return new Plane(l2, this.session);
    }

    public Pose getCenterPose() {
        return this.nativeGetCenterPose(this.session.nativeWrapperHandle, this.nativeHandle);
    }

    public float getExtentX() {
        return this.nativeGetExtentX(this.session.nativeWrapperHandle, this.nativeHandle);
    }

    public float getExtentZ() {
        return this.nativeGetExtentZ(this.session.nativeWrapperHandle, this.nativeHandle);
    }

    public FloatBuffer getPolygon() {
        return FloatBuffer.wrap(this.nativeGetPolygon(this.session.nativeWrapperHandle, this.nativeHandle));
    }

    public boolean isPoseInExtents(Pose pose) {
        return this.nativeIsPoseInExtents(this.session.nativeWrapperHandle, this.nativeHandle, pose);
    }

    public boolean isPoseInPolygon(Pose pose) {
        return this.nativeIsPoseInPolygon(this.session.nativeWrapperHandle, this.nativeHandle, pose);
    }

    private native int nativeGetType(long var1, long var3);

    private native long nativeAcquireSubsumedBy(long var1, long var3);

    private native Pose nativeGetCenterPose(long var1, long var3);

    private native float nativeGetExtentX(long var1, long var3);

    private native float nativeGetExtentZ(long var1, long var3);

    private native float[] nativeGetPolygon(long var1, long var3);

    private native boolean nativeIsPoseInExtents(long var1, long var3, Pose var5);

    private native boolean nativeIsPoseInPolygon(long var1, long var3, Pose var5);

    public static enum Type {
        HORIZONTAL_UPWARD_FACING(0),
        HORIZONTAL_DOWNWARD_FACING(1),
        VERTICAL(2);

        final int nativeCode;

        private Type(int n3) {
            this.nativeCode = n3;
        }

        static Type forNumber(int n2) {
            for (Type type : Type.values()) {
                if (type.nativeCode != n2) continue;
                return type;
            }
            throw new FatalException(new StringBuilder(57).append("Unexpected value for native Plane.Type, value=").append(n2).toString());
        }
    }
}

