/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.core;

import com.google.ar.core.ArImage;
import com.google.ar.core.Session;
import com.google.ar.core.exceptions.FatalException;

public class LightEstimate {
    private final Session session;
    private final long nativeSymbolTableHandle;
    long nativeHandle = 0L;

    LightEstimate(Session session) {
        this.session = session;
        this.nativeHandle = LightEstimate.nativeCreateLightEstimate(session.nativeWrapperHandle);
        this.nativeSymbolTableHandle = session.nativeSymbolTableHandle;
    }

    protected LightEstimate() {
        this.session = null;
        this.nativeHandle = 0L;
        this.nativeSymbolTableHandle = 0L;
    }

    protected void finalize() throws Throwable {
        if (this.nativeHandle != 0L) {
            LightEstimate.nativeDestroyLightEstimate(this.nativeSymbolTableHandle, this.nativeHandle);
        }
        super.finalize();
    }

    public State getState() {
        return State.forNumber(this.nativeGetState(this.session.nativeWrapperHandle, this.nativeHandle));
    }

    public float getPixelIntensity() {
        return this.nativeGetPixelIntensity(this.session.nativeWrapperHandle, this.nativeHandle);
    }

    public void getColorCorrection(float[] fArray, int n2) {
        this.nativeGetColorCorrection(this.session.nativeWrapperHandle, this.nativeHandle, fArray, n2);
    }

    public long getTimestamp() {
        return this.nativeGetTimestamp(this.session.nativeWrapperHandle, this.nativeHandle);
    }

    public float[] getEnvironmentalHdrMainLightDirection() {
        float[] fArray = new float[3];
        this.nativeGetEnvironmentalHdrMainLightDirection(this.session.nativeWrapperHandle, this.nativeHandle, fArray);
        return fArray;
    }

    public float[] getEnvironmentalHdrMainLightIntensity() {
        float[] fArray = new float[3];
        this.nativeGetEnvironmentalHdrMainLightIntensity(this.session.nativeWrapperHandle, this.nativeHandle, fArray);
        return fArray;
    }

    public float[] getEnvironmentalHdrAmbientSphericalHarmonics() {
        float[] fArray = new float[27];
        this.nativeGetEnvironmentalHdrAmbientSphericalHarmonics(this.session.nativeWrapperHandle, this.nativeHandle, fArray);
        return fArray;
    }

    public ArImage[] acquireEnvironmentalHdrCubeMap() {
        long[] lArray = this.nativeAcquireEnvironmentalHdrCubeMap(this.session.nativeWrapperHandle, this.nativeHandle);
        return this.convertNativeArImageCubemapToArray(lArray);
    }

    private ArImage[] convertNativeArImageCubemapToArray(long[] lArray) {
        ArImage[] arImageArray = new ArImage[lArray.length];
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            ArImage arImage;
            arImageArray[i2] = arImage = new ArImage(this.session, lArray[i2]);
        }
        return arImageArray;
    }

    private static native long nativeCreateLightEstimate(long var0);

    private static native void nativeDestroyLightEstimate(long var0, long var2);

    private native int nativeGetState(long var1, long var3);

    private native float nativeGetPixelIntensity(long var1, long var3);

    private native void nativeGetColorCorrection(long var1, long var3, float[] var5, int var6);

    private native long nativeGetTimestamp(long var1, long var3);

    private native void nativeGetEnvironmentalHdrMainLightDirection(long var1, long var3, float[] var5);

    private native void nativeGetEnvironmentalHdrMainLightIntensity(long var1, long var3, float[] var5);

    private native void nativeGetEnvironmentalHdrAmbientSphericalHarmonics(long var1, long var3, float[] var5);

    private native long[] nativeAcquireEnvironmentalHdrCubeMap(long var1, long var3);

    public static enum State {
        NOT_VALID(0),
        VALID(1);

        final int nativeCode;

        private State(int n3) {
            this.nativeCode = n3;
        }

        static State forNumber(int n2) {
            for (State state : State.values()) {
                if (state.nativeCode != n2) continue;
                return state;
            }
            throw new FatalException(new StringBuilder(66).append("Unexpected value for native LightEstimate.State, value=").append(n2).toString());
        }
    }
}

