/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.core;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.ContextThemeWrapper;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.google.ar.core.ArCoreApk;
import com.google.ar.core.R;
import com.google.ar.core.ac;
import com.google.ar.core.annotations.UsedByReflection;
import com.google.ar.core.exceptions.FatalException;
import com.google.ar.core.exceptions.UnavailableDeviceNotCompatibleException;
import com.google.ar.core.exceptions.UnavailableUserDeclinedInstallationException;
import com.google.ar.core.h;
import com.google.ar.core.k;
import com.google.ar.core.l;
import com.google.ar.core.m;
import com.google.ar.core.n;
import com.google.ar.core.o;
import com.google.ar.core.s;
import java.util.concurrent.atomic.AtomicReference;

@TargetApi(value=24)
@UsedByReflection(value="AndroidManifest.xml")
public class InstallActivity
extends Activity {
    private static final String TAG = "ARCore-InstallActivity";
    static final String MESSAGE_TYPE_KEY = "message";
    static final String INSTALL_BEHAVIOR_KEY = "behavior";
    private static final int BOX_SIZE_DP = 280;
    private static final int INSTALLING_TEXT_BOTTOM_MARGIN_DP = 30;
    private final ContextThemeWrapper themeWrapper = new ContextThemeWrapper((Context)this, 16974394);
    private ArCoreApk.UserMessageType messageType;
    private ArCoreApk.InstallBehavior installBehavior;
    private o lastEvent = o.b;
    private boolean finished;
    private boolean installStarted;
    private boolean waitingForCompletion;

    public InstallActivity() {
    }

    protected void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        try {
            if (bundle != null) {
                this.finishWithFailure(new FatalException("Install activity was suspended and recreated."));
                return;
            }
            this.messageType = (ArCoreApk.UserMessageType)((Object)this.getIntent().getSerializableExtra(MESSAGE_TYPE_KEY));
            this.installBehavior = (ArCoreApk.InstallBehavior)((Object)this.getIntent().getSerializableExtra(INSTALL_BEHAVIOR_KEY));
            if (this.messageType == null || this.installBehavior == null) {
                Log.e((String)TAG, (String)"missing intent data.");
                this.finishWithFailure(new FatalException("Install activity launched without config data."));
                return;
            }
            this.setTheme(16974394);
            this.getWindow().requestFeature(1);
            this.setFinishOnTouchOutside(this.isOptional());
            if (this.messageType != ArCoreApk.UserMessageType.USER_ALREADY_INFORMED) {
                AtomicReference<ArCoreApk.Availability> atomicReference = new AtomicReference<ArCoreApk.Availability>(ArCoreApk.Availability.UNKNOWN_CHECKING);
                h.a().a((Context)this).a((Context)this, new ac(atomicReference));
                switch (atomicReference.get().ordinal()) {
                    case 3: {
                        this.finishWithFailure(new UnavailableDeviceNotCompatibleException());
                        return;
                    }
                    case 0: {
                        Log.w((String)TAG, (String)"Preliminary compatibility check failed.");
                    }
                }
                this.showEducationDialog();
                return;
            }
            this.showSpinner();
        }
        catch (RuntimeException runtimeException) {
            this.finishWithFailure(new FatalException("Exception starting install flow", runtimeException));
        }
    }

    protected void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        bundle.putBoolean("didResume", true);
    }

    private void showEducationDialog() {
        this.setContentView(R.layout.__arcore_education);
        this.findViewById(R.id.__arcore_cancelButton).setOnClickListener((View.OnClickListener)new l(this));
        if (!this.isOptional()) {
            this.findViewById(R.id.__arcore_cancelButton).setVisibility(8);
        }
        this.findViewById(R.id.__arcore_continueButton).setOnClickListener((View.OnClickListener)new k(this));
        TextView textView = (TextView)this.findViewById(R.id.__arcore_messageText);
        switch (this.messageType.ordinal()) {
            case 1: {
                textView.setText(R.string.__arcore_install_feature);
                return;
            }
        }
        textView.setText(R.string.__arcore_install_app);
    }

    private void showSpinner() {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        this.getWindowManager().getDefaultDisplay().getMetrics(displayMetrics);
        int n2 = (int)(280.0f * displayMetrics.density);
        this.getWindow().setLayout(n2, n2);
        RelativeLayout relativeLayout = new RelativeLayout((Context)this.themeWrapper);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
        layoutParams.addRule(13);
        ProgressBar progressBar = new ProgressBar((Context)this.themeWrapper);
        progressBar.setIndeterminate(true);
        progressBar.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        relativeLayout.addView((View)progressBar);
        layoutParams = new RelativeLayout.LayoutParams(-2, -2);
        layoutParams.addRule(14);
        layoutParams.addRule(12);
        layoutParams.bottomMargin = (int)(30.0f * displayMetrics.density);
        progressBar = new TextView((Context)this.themeWrapper);
        progressBar.setText(R.string.__arcore_installing);
        progressBar.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        relativeLayout.addView((View)progressBar);
        this.setContentView((View)relativeLayout);
        this.getWindow().setLayout(n2, n2);
    }

    private void animateToSpinner() {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        this.getWindowManager().getDefaultDisplay().getMetrics(displayMetrics);
        int n2 = (int)(280.0f * displayMetrics.density);
        int n3 = this.getWindow().getDecorView().getWidth();
        int n4 = this.getWindow().getDecorView().getHeight();
        this.setContentView((View)new RelativeLayout((Context)this));
        this.getWindow().getDecorView().setMinimumWidth(n2);
        ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        valueAnimator.setDuration(300L);
        valueAnimator.addUpdateListener((ValueAnimator.AnimatorUpdateListener)new n(this, n3, n2, n4));
        valueAnimator.addListener((Animator.AnimatorListener)new m(this));
        valueAnimator.start();
    }

    protected void onNewIntent(Intent intent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onResume() {
        super.onResume();
        if (!this.installStarted) {
            if (this.messageType == ArCoreApk.UserMessageType.USER_ALREADY_INFORMED) {
                this.startInstaller();
            }
            return;
        }
        if (!this.finished) {
            InstallActivity installActivity = this;
            synchronized (installActivity) {
                if (this.lastEvent == o.b) {
                    this.finish();
                } else if (this.lastEvent == o.a) {
                    this.waitingForCompletion = true;
                } else {
                    this.finishWithFailure(h.a().a);
                }
                return;
            }
        }
    }

    public void finish() {
        this.finishWithFailure(new UnavailableUserDeclinedInstallationException());
    }

    private void finishWithFailure(Exception exception) {
        h.a().a = exception;
        h.a().b();
        this.finished = true;
        super.finish();
    }

    public void onDestroy() {
        if (!this.finished) {
            h.a().b();
        }
        super.onDestroy();
    }

    private boolean isOptional() {
        return this.installBehavior == ArCoreApk.InstallBehavior.OPTIONAL;
    }

    private void startInstaller() {
        this.installStarted = true;
        this.lastEvent = o.b;
        h.a().a((Context)this).a(this, new s(this));
    }

    private void closeInstaller() {
        this.startActivity(new Intent((Context)this, InstallActivity.class).setFlags(0x4000000));
    }

    protected void onActivityResult(int n2, int n3, Intent intent) {
        super.onActivityResult(n2, n3, intent);
        Log.i((String)TAG, (String)new StringBuilder(27).append("activityResult: ").append(n3).toString());
    }

    static /* synthetic */ void access$000(InstallActivity installActivity, Exception exception) {
        installActivity.finishWithFailure(exception);
    }

    static /* synthetic */ void access$100(InstallActivity installActivity) {
        installActivity.animateToSpinner();
    }

    static /* synthetic */ void access$200(InstallActivity installActivity) {
        installActivity.startInstaller();
    }

    static /* synthetic */ void access$300(InstallActivity installActivity) {
        installActivity.showSpinner();
    }

    static /* synthetic */ o access$402(InstallActivity installActivity, o o2) {
        installActivity.lastEvent = o2;
        return installActivity.lastEvent;
    }

    static /* synthetic */ boolean access$500(InstallActivity installActivity) {
        return installActivity.waitingForCompletion;
    }

    static /* synthetic */ void access$600(InstallActivity installActivity) {
        installActivity.closeInstaller();
    }
}

