/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.core;

import android.util.Rational;
import com.google.ar.core.Session;
import com.google.ar.core.exceptions.FatalException;

public class ImageMetadata {
    private static final int SECTION_COLOR_CORRECTION = 0;
    private static final int SECTION_CONTROL = 1;
    private static final int SECTION_EDGE = 3;
    private static final int SECTION_FLASH = 4;
    private static final int SECTION_FLASH_INFO = 5;
    private static final int SECTION_HOT_PIXEL = 6;
    private static final int SECTION_JPEG = 7;
    private static final int SECTION_LENS = 8;
    private static final int SECTION_LENS_INFO = 9;
    private static final int SECTION_NOISE_REDUCTION = 10;
    private static final int SECTION_REQUEST = 12;
    private static final int SECTION_SCALER = 13;
    private static final int SECTION_SENSOR = 14;
    private static final int SECTION_SENSOR_INFO = 15;
    private static final int SECTION_SHADING = 16;
    private static final int SECTION_STATISTICS = 17;
    private static final int SECTION_STATISTICS_INFO = 18;
    private static final int SECTION_TONEMAP = 19;
    private static final int SECTION_INFO = 21;
    private static final int SECTION_BLACK_LEVEL = 22;
    private static final int SECTION_SYNC = 23;
    private static final int SECTION_DEPTH = 25;
    private static final int COLOR_CORRECTION_START = 0;
    private static final int CONTROL_START = 65536;
    private static final int EDGE_START = 196608;
    private static final int FLASH_START = 262144;
    private static final int FLASH_INFO_START = 327680;
    private static final int HOT_PIXEL_START = 393216;
    private static final int JPEG_START = 458752;
    private static final int LENS_START = 524288;
    private static final int LENS_INFO_START = 589824;
    private static final int NOISE_REDUCTION_START = 655360;
    private static final int REQUEST_START = 786432;
    private static final int SCALER_START = 851968;
    private static final int SENSOR_START = 917504;
    private static final int SENSOR_INFO_START = 983040;
    private static final int SHADING_START = 0x100000;
    private static final int STATISTICS_START = 0x110000;
    private static final int STATISTICS_INFO_START = 0x120000;
    private static final int TONEMAP_START = 0x130000;
    private static final int INFO_START = 0x150000;
    private static final int BLACK_LEVEL_START = 0x160000;
    private static final int SYNC_START = 0x170000;
    private static final int DEPTH_START = 0x190000;
    public static final int COLOR_CORRECTION_MODE = 0;
    public static final int COLOR_CORRECTION_TRANSFORM = 1;
    public static final int COLOR_CORRECTION_GAINS = 2;
    public static final int COLOR_CORRECTION_ABERRATION_MODE = 3;
    public static final int CONTROL_AE_ANTIBANDING_MODE = 65536;
    public static final int CONTROL_AE_EXPOSURE_COMPENSATION = 65537;
    public static final int CONTROL_AE_LOCK = 65538;
    public static final int CONTROL_AE_MODE = 65539;
    public static final int CONTROL_AE_REGIONS = 65540;
    public static final int CONTROL_AE_TARGET_FPS_RANGE = 65541;
    public static final int CONTROL_AE_PRECAPTURE_TRIGGER = 65542;
    public static final int CONTROL_AF_MODE = 65543;
    public static final int CONTROL_AF_REGIONS = 65544;
    public static final int CONTROL_AF_TRIGGER = 65545;
    public static final int CONTROL_AWB_LOCK = 65546;
    public static final int CONTROL_AWB_MODE = 65547;
    public static final int CONTROL_AWB_REGIONS = 65548;
    public static final int CONTROL_CAPTURE_INTENT = 65549;
    public static final int CONTROL_EFFECT_MODE = 65550;
    public static final int CONTROL_MODE = 65551;
    public static final int CONTROL_SCENE_MODE = 65552;
    public static final int CONTROL_VIDEO_STABILIZATION_MODE = 65553;
    public static final int CONTROL_AE_STATE = 65567;
    public static final int CONTROL_AF_STATE = 65568;
    public static final int CONTROL_AWB_STATE = 65570;
    public static final int CONTROL_POST_RAW_SENSITIVITY_BOOST = 65576;
    public static final int EDGE_MODE = 196608;
    public static final int FLASH_MODE = 262146;
    public static final int FLASH_STATE = 262149;
    public static final int HOT_PIXEL_MODE = 393216;
    public static final int JPEG_GPS_COORDINATES = 458752;
    public static final int JPEG_GPS_PROCESSING_METHOD = 458753;
    public static final int JPEG_GPS_TIMESTAMP = 458754;
    public static final int JPEG_ORIENTATION = 458755;
    public static final int JPEG_QUALITY = 458756;
    public static final int JPEG_THUMBNAIL_QUALITY = 458757;
    public static final int JPEG_THUMBNAIL_SIZE = 458758;
    public static final int LENS_APERTURE = 524288;
    public static final int LENS_FILTER_DENSITY = 524289;
    public static final int LENS_FOCAL_LENGTH = 524290;
    public static final int LENS_FOCUS_DISTANCE = 524291;
    public static final int LENS_OPTICAL_STABILIZATION_MODE = 524292;
    public static final int LENS_POSE_ROTATION = 524294;
    public static final int LENS_POSE_TRANSLATION = 524295;
    public static final int LENS_FOCUS_RANGE = 524296;
    public static final int LENS_STATE = 524297;
    public static final int LENS_INTRINSIC_CALIBRATION = 524298;
    public static final int LENS_RADIAL_DISTORTION = 524299;
    public static final int NOISE_REDUCTION_MODE = 655360;
    public static final int REQUEST_PIPELINE_DEPTH = 786441;
    public static final int SCALER_CROP_REGION = 851968;
    public static final int SENSOR_EXPOSURE_TIME = 917504;
    public static final int SENSOR_FRAME_DURATION = 917505;
    public static final int SENSOR_SENSITIVITY = 917506;
    public static final int SENSOR_TIMESTAMP = 917520;
    public static final int SENSOR_NEUTRAL_COLOR_POINT = 917522;
    public static final int SENSOR_NOISE_PROFILE = 917523;
    public static final int SENSOR_GREEN_SPLIT = 917526;
    public static final int SENSOR_TEST_PATTERN_DATA = 917527;
    public static final int SENSOR_TEST_PATTERN_MODE = 917528;
    public static final int SENSOR_ROLLING_SHUTTER_SKEW = 917530;
    public static final int SENSOR_DYNAMIC_BLACK_LEVEL = 917532;
    public static final int SENSOR_DYNAMIC_WHITE_LEVEL = 917533;
    public static final int SHADING_MODE = 0x100000;
    public static final int STATISTICS_FACE_DETECT_MODE = 0x110000;
    public static final int STATISTICS_HOT_PIXEL_MAP_MODE = 0x110003;
    public static final int STATISTICS_FACE_IDS = 0x110004;
    public static final int STATISTICS_FACE_LANDMARKS = 0x110005;
    public static final int STATISTICS_FACE_RECTANGLES = 0x110006;
    public static final int STATISTICS_FACE_SCORES = 0x110007;
    public static final int STATISTICS_LENS_SHADING_MAP = 0x11000B;
    public static final int STATISTICS_SCENE_FLICKER = 0x11000E;
    public static final int STATISTICS_HOT_PIXEL_MAP = 0x11000F;
    public static final int STATISTICS_LENS_SHADING_MAP_MODE = 0x110010;
    public static final int TONEMAP_CURVE_BLUE = 0x130000;
    public static final int TONEMAP_CURVE_GREEN = 0x130001;
    public static final int TONEMAP_CURVE_RED = 1245186;
    public static final int TONEMAP_MODE = 0x130003;
    public static final int TONEMAP_GAMMA = 1245190;
    public static final int TONEMAP_PRESET_CURVE = 1245191;
    public static final int BLACK_LEVEL_LOCK = 0x160000;
    public static final int SYNC_FRAME_NUMBER = 0x170000;
    private static final String TAG = "ARCore-ImageMetadata";
    private static final int TYPE_BYTE = 0;
    private static final int TYPE_INT = 1;
    private static final int TYPE_FLOAT = 2;
    private static final int TYPE_LONG = 3;
    private static final int TYPE_DOUBLE = 4;
    private static final int TYPE_RATIONAL = 5;
    private final Session session;
    private final long nativeSymbolTableHandle;
    private final long nativeHandle;
    private final a sketchEntry;

    ImageMetadata(long l2, Session session) {
        this.session = session;
        this.nativeHandle = l2;
        this.nativeSymbolTableHandle = session.nativeSymbolTableHandle;
        this.sketchEntry = new a();
    }

    protected ImageMetadata() {
        this.session = null;
        this.nativeHandle = 0L;
        this.nativeSymbolTableHandle = 0L;
        this.sketchEntry = null;
    }

    protected void finalize() throws Throwable {
        if (this.nativeHandle != 0L) {
            ImageMetadata.nativeReleaseImageMetadata(this.nativeSymbolTableHandle, this.nativeHandle);
        }
        super.finalize();
    }

    public long[] getKeys() {
        long[] lArray = this.nativeGetAllKeys(this.session.nativeWrapperHandle, this.nativeHandle);
        if (lArray == null) {
            throw new FatalException("Unknown error in ImageMetadata.getKeys().");
        }
        return lArray;
    }

    public byte getByte(int n2) {
        this.getMetdataEntry(n2, this.sketchEntry);
        if (this.sketchEntry.b != 0 || this.sketchEntry.c != 1) {
            throw new IllegalArgumentException(String.format("Wrong return type for ImageMetadata key: %1$d.", n2));
        }
        byte by = this.nativeGetByteFromMetadataEntry(this.session.nativeWrapperHandle, this.sketchEntry.a);
        this.nativeDestroyMetadataEntry(this.session.nativeWrapperHandle, this.sketchEntry.a);
        return by;
    }

    public int getInt(int n2) {
        this.getMetdataEntry(n2, this.sketchEntry);
        if (this.sketchEntry.b != 1 || this.sketchEntry.c != 1) {
            throw new IllegalArgumentException(String.format("Wrong return type for ImageMetadata key: %1$d.", n2));
        }
        int n3 = this.nativeGetIntFromMetadataEntry(this.session.nativeWrapperHandle, this.sketchEntry.a);
        this.nativeDestroyMetadataEntry(this.session.nativeWrapperHandle, this.sketchEntry.a);
        return n3;
    }

    public float getFloat(int n2) {
        this.getMetdataEntry(n2, this.sketchEntry);
        if (this.sketchEntry.b != 2 || this.sketchEntry.c != 1) {
            throw new IllegalArgumentException(String.format("Wrong return type for ImageMetadata key: %1$d.", n2));
        }
        float f2 = this.nativeGetFloatFromMetadataEntry(this.session.nativeWrapperHandle, this.sketchEntry.a);
        this.nativeDestroyMetadataEntry(this.session.nativeWrapperHandle, this.sketchEntry.a);
        return f2;
    }

    public long getLong(int n2) {
        this.getMetdataEntry(n2, this.sketchEntry);
        if (this.sketchEntry.b != 3 || this.sketchEntry.c != 1) {
            throw new IllegalArgumentException(String.format("Wrong return type for ImageMetadata key: %1$d, type: %2$d, count: %3$d.", n2, this.sketchEntry.b, this.sketchEntry.c));
        }
        long l2 = this.nativeGetLongFromMetadataEntry(this.session.nativeWrapperHandle, this.sketchEntry.a);
        this.nativeDestroyMetadataEntry(this.session.nativeWrapperHandle, this.sketchEntry.a);
        return l2;
    }

    public double getDouble(int n2) {
        this.getMetdataEntry(n2, this.sketchEntry);
        if (this.sketchEntry.b != 4 || this.sketchEntry.c != 1) {
            throw new IllegalArgumentException(String.format("Wrong return type for ImageMetadata key: %1$d.", n2));
        }
        double d2 = this.nativeGetDoubleFromMetadataEntry(this.session.nativeWrapperHandle, this.sketchEntry.a);
        this.nativeDestroyMetadataEntry(this.session.nativeWrapperHandle, this.sketchEntry.a);
        return d2;
    }

    public Rational getRational(int n2) {
        this.getMetdataEntry(n2, this.sketchEntry);
        if (this.sketchEntry.b != 5 || this.sketchEntry.c != 1) {
            throw new IllegalArgumentException(String.format("Wrong return type for ImageMetadata key: %1$d.", n2));
        }
        Rational rational = this.nativeGetRationalFromMetadataEntry(this.session.nativeWrapperHandle, this.sketchEntry.a);
        this.nativeDestroyMetadataEntry(this.session.nativeWrapperHandle, this.sketchEntry.a);
        return rational;
    }

    public byte[] getByteArray(int n2) {
        this.getMetdataEntry(n2, this.sketchEntry);
        if (this.sketchEntry.b != 0) {
            throw new IllegalArgumentException(String.format("Wrong return type for ImageMetadata key: %1$d.", n2));
        }
        byte[] byArray = this.nativeGetByteArrayFromMetadataEntry(this.session.nativeWrapperHandle, this.sketchEntry.a);
        this.nativeDestroyMetadataEntry(this.session.nativeWrapperHandle, this.sketchEntry.a);
        return byArray;
    }

    public int[] getIntArray(int n2) {
        this.getMetdataEntry(n2, this.sketchEntry);
        if (this.sketchEntry.b != 1) {
            throw new IllegalArgumentException(String.format("Wrong return type for ImageMetadata key: %1$d.", n2));
        }
        int[] nArray = this.nativeGetIntArrayFromMetadataEntry(this.session.nativeWrapperHandle, this.sketchEntry.a);
        this.nativeDestroyMetadataEntry(this.session.nativeWrapperHandle, this.sketchEntry.a);
        return nArray;
    }

    public float[] getFloatArray(int n2) {
        this.getMetdataEntry(n2, this.sketchEntry);
        if (this.sketchEntry.b != 2) {
            throw new IllegalArgumentException(String.format("Wrong return type for ImageMetadata key: %1$d.", n2));
        }
        float[] fArray = this.nativeGetFloatArrayFromMetadataEntry(this.session.nativeWrapperHandle, this.sketchEntry.a);
        this.nativeDestroyMetadataEntry(this.session.nativeWrapperHandle, this.sketchEntry.a);
        return fArray;
    }

    public long[] getLongArray(int n2) {
        this.getMetdataEntry(n2, this.sketchEntry);
        if (this.sketchEntry.b != 3) {
            throw new IllegalArgumentException(String.format("Wrong return type for ImageMetadata key: %1$d.", n2));
        }
        long[] lArray = this.nativeGetLongArrayFromMetadataEntry(this.session.nativeWrapperHandle, this.sketchEntry.a);
        this.nativeDestroyMetadataEntry(this.session.nativeWrapperHandle, this.sketchEntry.a);
        return lArray;
    }

    public double[] getDoubleArray(int n2) {
        this.getMetdataEntry(n2, this.sketchEntry);
        if (this.sketchEntry.b != 4) {
            throw new IllegalArgumentException(String.format("Wrong return type for ImageMetadata key: %1$d.", n2));
        }
        double[] dArray = this.nativeGetDoubleArrayFromMetadataEntry(this.session.nativeWrapperHandle, this.sketchEntry.a);
        this.nativeDestroyMetadataEntry(this.session.nativeWrapperHandle, this.sketchEntry.a);
        return dArray;
    }

    public Rational[] getRationalArray(int n2) {
        this.getMetdataEntry(n2, this.sketchEntry);
        if (this.sketchEntry.b != 5) {
            throw new IllegalArgumentException(String.format("Wrong return type for ImageMetadata key: %1$d.", n2));
        }
        Rational[] rationalArray = this.nativeGetRationalArrayFromMetadataEntry(this.session.nativeWrapperHandle, this.sketchEntry.a);
        this.nativeDestroyMetadataEntry(this.session.nativeWrapperHandle, this.sketchEntry.a);
        return rationalArray;
    }

    private void getMetdataEntry(int n2, a a2) {
        a2.a = this.nativeGetMetadataEntry(this.session.nativeWrapperHandle, this.nativeHandle, n2);
        if (a2.a == 0L) {
            throw new IllegalArgumentException(String.format("Invalid ImageMetadata key: %1$d", n2));
        }
        a2.b = this.nativeGetMetadataEntryValueType(this.session.nativeWrapperHandle, a2.a);
        a2.c = this.nativeGetMetadataEntryValueCount(this.session.nativeWrapperHandle, a2.a);
    }

    static native void nativeLoadSymbols();

    private native long[] nativeGetAllKeys(long var1, long var3);

    private native long nativeGetMetadataEntry(long var1, long var3, int var5);

    private static native void nativeReleaseImageMetadata(long var0, long var2);

    private native void nativeDestroyMetadataEntry(long var1, long var3);

    private native int nativeGetMetadataEntryValueType(long var1, long var3);

    private native int nativeGetMetadataEntryValueCount(long var1, long var3);

    private native byte nativeGetByteFromMetadataEntry(long var1, long var3);

    private native int nativeGetIntFromMetadataEntry(long var1, long var3);

    private native float nativeGetFloatFromMetadataEntry(long var1, long var3);

    private native long nativeGetLongFromMetadataEntry(long var1, long var3);

    private native double nativeGetDoubleFromMetadataEntry(long var1, long var3);

    private native Rational nativeGetRationalFromMetadataEntry(long var1, long var3);

    private native byte[] nativeGetByteArrayFromMetadataEntry(long var1, long var3);

    private native int[] nativeGetIntArrayFromMetadataEntry(long var1, long var3);

    private native float[] nativeGetFloatArrayFromMetadataEntry(long var1, long var3);

    private native long[] nativeGetLongArrayFromMetadataEntry(long var1, long var3);

    private native double[] nativeGetDoubleArrayFromMetadataEntry(long var1, long var3);

    private native Rational[] nativeGetRationalArrayFromMetadataEntry(long var1, long var3);

    static final class a {
        long a = 0L;
        int b = -1;
        int c = -1;

        a() {
        }
    }
}

