/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.core;

import android.media.Image;
import android.view.MotionEvent;
import com.google.ar.core.Anchor;
import com.google.ar.core.ArImage;
import com.google.ar.core.Camera;
import com.google.ar.core.Coordinates2d;
import com.google.ar.core.HitResult;
import com.google.ar.core.ImageMetadata;
import com.google.ar.core.LightEstimate;
import com.google.ar.core.Plane;
import com.google.ar.core.PointCloud;
import com.google.ar.core.Pose;
import com.google.ar.core.Session;
import com.google.ar.core.Trackable;
import com.google.ar.core.exceptions.NotYetAvailableException;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class Frame {
    private static final String TAG = "ARCore-Frame";
    static final ArrayList<Anchor> ANCHORS_EMPTY_LIST = new ArrayList();
    static final ArrayList<Plane> PLANES_EMPTY_LIST = new ArrayList();
    final Session session;
    final long nativeSymbolTableHandle;
    long nativeHandle = 0L;
    private LightEstimate lightEstimate;

    Frame(Session session) {
        this(session, Frame.nativeCreateFrame(session.nativeWrapperHandle));
    }

    Frame(Session session, long l2) {
        this.session = session;
        this.nativeHandle = l2;
        this.nativeSymbolTableHandle = session.nativeSymbolTableHandle;
    }

    protected Frame() {
        this.session = null;
        this.nativeHandle = 0L;
        this.nativeSymbolTableHandle = 0L;
    }

    protected void finalize() throws Throwable {
        if (this.nativeHandle != 0L) {
            Frame.nativeDestroyFrame(this.nativeSymbolTableHandle, this.nativeHandle);
            this.nativeHandle = 0L;
        }
        super.finalize();
    }

    public Camera getCamera() {
        return new Camera(this.session, this);
    }

    public boolean hasDisplayGeometryChanged() {
        return this.nativeHasDisplayGeometryChanged(this.session.nativeWrapperHandle, this.nativeHandle);
    }

    @Deprecated
    public void transformDisplayUvCoords(FloatBuffer floatBuffer, FloatBuffer floatBuffer2) {
        if (!floatBuffer.isDirect() || !floatBuffer2.isDirect()) {
            throw new IllegalArgumentException("transformDisplayUvCoords currently requires direct buffers.");
        }
        this.nativeTransformDisplayUvCoords(this.session.nativeWrapperHandle, this.nativeHandle, floatBuffer, floatBuffer2);
    }

    public long getTimestamp() {
        return this.nativeGetTimestamp(this.session.nativeWrapperHandle, this.nativeHandle);
    }

    public long getAndroidCameraTimestamp() {
        return this.nativeGetAndroidCameraTimestamp(this.session.nativeWrapperHandle, this.nativeHandle);
    }

    public Pose getAndroidSensorPose() {
        return this.nativeGetAndroidSensorPose(this.session.nativeWrapperHandle, this.nativeHandle);
    }

    public LightEstimate getLightEstimate() {
        if (this.lightEstimate == null) {
            this.lightEstimate = new LightEstimate(this.session);
        }
        this.nativeGetLightEstimate(this.session.nativeWrapperHandle, this.nativeHandle, this.lightEstimate.nativeHandle);
        return this.lightEstimate;
    }

    public ImageMetadata getImageMetadata() throws NotYetAvailableException {
        if (this.isSharedCameraUsed()) {
            throw new IllegalStateException("Metadata access is not available from Frame when shared camera is in use.");
        }
        long l2 = this.nativeAcquireImageMetadata(this.session.nativeWrapperHandle, this.nativeHandle);
        return new ImageMetadata(l2, this.session);
    }

    private boolean isSharedCameraUsed() {
        return this.session.isSharedCameraUsed();
    }

    public PointCloud acquirePointCloud() {
        long l2 = this.nativeAcquirePointCloud(this.session.nativeWrapperHandle, this.nativeHandle);
        return new PointCloud(this.session, l2);
    }

    public List<HitResult> hitTest(float f2, float f3) {
        long[] lArray = this.nativeHitTest(this.session.nativeWrapperHandle, this.nativeHandle, f2, f3);
        return this.convertNativeHitResultsToList(lArray);
    }

    public List<HitResult> hitTest(MotionEvent motionEvent) {
        return this.hitTest(motionEvent.getX(), motionEvent.getY());
    }

    public List<HitResult> hitTest(float[] fArray, int n2, float[] fArray2, int n3) {
        long[] lArray = this.nativeHitTestRay(this.session.nativeWrapperHandle, this.nativeHandle, fArray, n2, fArray2, n3);
        return this.convertNativeHitResultsToList(lArray);
    }

    private List<HitResult> convertNativeHitResultsToList(long[] lArray) {
        ArrayList<HitResult> arrayList = new ArrayList<HitResult>(lArray.length);
        long[] lArray2 = lArray;
        int n2 = lArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            long l2 = lArray2[i2];
            HitResult hitResult = new HitResult(l2, this.session);
            if (hitResult.getTrackable() == null) continue;
            arrayList.add(hitResult);
        }
        return Collections.unmodifiableList(arrayList);
    }

    public Collection<Anchor> getUpdatedAnchors() {
        return this.session.convertNativeAnchorsToCollection(this.nativeAcquireUpdatedAnchors(this.session.nativeWrapperHandle, this.nativeHandle));
    }

    public <T extends Trackable> Collection<T> getUpdatedTrackables(Class<T> clazz) {
        Session.c c2 = Session.c.a(clazz);
        if (c2 == Session.c.a) {
            return Collections.emptyList();
        }
        long[] lArray = this.nativeAcquireUpdatedTrackables(this.session.nativeWrapperHandle, this.nativeHandle, c2.b);
        return this.session.convertNativeTrackablesToCollection(clazz, lArray);
    }

    public Image acquireCameraImage() throws NotYetAvailableException {
        long l2 = this.nativeAcquireCameraImage(this.session.nativeWrapperHandle, this.nativeHandle);
        return new ArImage(this.session, l2);
    }

    public void transformCoordinates2d(Coordinates2d coordinates2d, FloatBuffer floatBuffer, Coordinates2d coordinates2d2, FloatBuffer floatBuffer2) {
        this.nativeTransformCoordinates2dFloatArrayOrBuffer(this.session.nativeWrapperHandle, this.nativeHandle, coordinates2d.nativeCode, floatBuffer, coordinates2d2.nativeCode, floatBuffer2);
    }

    public void transformCoordinates2d(Coordinates2d coordinates2d, float[] fArray, Coordinates2d coordinates2d2, float[] fArray2) {
        this.nativeTransformCoordinates2dFloatArrayOrBuffer(this.session.nativeWrapperHandle, this.nativeHandle, coordinates2d.nativeCode, fArray, coordinates2d2.nativeCode, fArray2);
    }

    private static native long nativeCreateFrame(long var0);

    private static native void nativeDestroyFrame(long var0, long var2);

    private native boolean nativeHasDisplayGeometryChanged(long var1, long var3);

    private native void nativeTransformDisplayUvCoords(long var1, long var3, FloatBuffer var5, FloatBuffer var6);

    private native long nativeGetTimestamp(long var1, long var3);

    private native long nativeGetAndroidCameraTimestamp(long var1, long var3);

    private native Pose nativeGetAndroidSensorPose(long var1, long var3);

    native long[] nativeHitTest(long var1, long var3, float var5, float var6);

    native long[] nativeHitTestRay(long var1, long var3, float[] var5, int var6, float[] var7, int var8);

    private native void nativeGetLightEstimate(long var1, long var3, long var5);

    private native long nativeAcquireImageMetadata(long var1, long var3);

    native long nativeAcquirePointCloud(long var1, long var3);

    private native long[] nativeAcquireUpdatedAnchors(long var1, long var3);

    native long[] nativeAcquireUpdatedTrackables(long var1, long var3, int var5);

    private native long nativeAcquireCameraImage(long var1, long var3);

    private native void nativeTransformCoordinates2dFloatArrayOrBuffer(long var1, long var3, int var5, Object var6, int var7, Object var8);
}

