/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.core;

import com.google.ar.core.AugmentedImageDatabase;
import com.google.ar.core.Session;
import com.google.ar.core.exceptions.FatalException;

public class Config {
    private static final String TAG = "ARCore-Config";
    final Session session;
    final long nativeSymbolTableHandle;
    long nativeHandle;

    public Config(Session session) {
        this.session = session;
        this.nativeHandle = Config.nativeCreate(session.nativeWrapperHandle);
        this.nativeSymbolTableHandle = session.nativeSymbolTableHandle;
    }

    Config(Session session, long l2) {
        this.session = session;
        this.nativeHandle = l2;
        this.nativeSymbolTableHandle = session.nativeSymbolTableHandle;
    }

    protected Config() {
        this.session = null;
        this.nativeHandle = 0L;
        this.nativeSymbolTableHandle = 0L;
    }

    public LightEstimationMode getLightEstimationMode() {
        return LightEstimationMode.forNumber(this.nativeGetLightEstimationMode(this.session.nativeWrapperHandle, this.nativeHandle));
    }

    public Config setLightEstimationMode(LightEstimationMode lightEstimationMode) {
        this.nativeSetLightEstimationMode(this.session.nativeWrapperHandle, this.nativeHandle, lightEstimationMode.nativeCode);
        return this;
    }

    public PlaneFindingMode getPlaneFindingMode() {
        return PlaneFindingMode.forNumber(this.nativeGetPlaneFindingMode(this.session.nativeWrapperHandle, this.nativeHandle));
    }

    public Config setPlaneFindingMode(PlaneFindingMode planeFindingMode) {
        this.nativeSetPlaneFindingMode(this.session.nativeWrapperHandle, this.nativeHandle, planeFindingMode.nativeCode);
        return this;
    }

    public UpdateMode getUpdateMode() {
        return UpdateMode.forNumber(this.nativeGetUpdateMode(this.session.nativeWrapperHandle, this.nativeHandle));
    }

    public Config setUpdateMode(UpdateMode updateMode) {
        this.nativeSetUpdateMode(this.session.nativeWrapperHandle, this.nativeHandle, updateMode.nativeCode);
        return this;
    }

    public Config setCloudAnchorMode(CloudAnchorMode cloudAnchorMode) {
        this.nativeSetCloudAnchorMode(this.session.nativeWrapperHandle, this.nativeHandle, cloudAnchorMode.nativeCode);
        return this;
    }

    public CloudAnchorMode getCloudAnchorMode() {
        return CloudAnchorMode.forNumber(this.nativeGetCloudAnchorMode(this.session.nativeWrapperHandle, this.nativeHandle));
    }

    public Config setAugmentedImageDatabase(AugmentedImageDatabase augmentedImageDatabase) {
        this.nativeSetAugmentedImageDatabase(this.session.nativeWrapperHandle, this.nativeHandle, augmentedImageDatabase == null ? 0L : augmentedImageDatabase.nativeHandle);
        return this;
    }

    public AugmentedImageDatabase getAugmentedImageDatabase() {
        long l2 = this.nativeGetAugmentedImageDatabase(this.session.nativeWrapperHandle, this.nativeHandle);
        return new AugmentedImageDatabase(this.session, l2);
    }

    public AugmentedFaceMode getAugmentedFaceMode() {
        return AugmentedFaceMode.forNumber(this.nativeGetAugmentedFaceMode(this.session.nativeWrapperHandle, this.nativeHandle));
    }

    public Config setAugmentedFaceMode(AugmentedFaceMode augmentedFaceMode) {
        this.nativeSetAugmentedFaceMode(this.session.nativeWrapperHandle, this.nativeHandle, augmentedFaceMode.nativeCode);
        return this;
    }

    public FocusMode getFocusMode() {
        return FocusMode.forNumber(this.nativeGetFocusMode(this.session.nativeWrapperHandle, this.nativeHandle));
    }

    public Config setFocusMode(FocusMode focusMode) {
        this.nativeSetFocusMode(this.session.nativeWrapperHandle, this.nativeHandle, focusMode.nativeCode);
        return this;
    }

    protected void finalize() throws Throwable {
        if (this.nativeHandle != 0L) {
            Config.nativeDestroy(this.nativeSymbolTableHandle, this.nativeHandle);
        }
        super.finalize();
    }

    private static native long nativeCreate(long var0);

    private static native void nativeDestroy(long var0, long var2);

    private native int nativeGetLightEstimationMode(long var1, long var3);

    private native void nativeSetLightEstimationMode(long var1, long var3, int var5);

    private native int nativeGetPlaneFindingMode(long var1, long var3);

    private native void nativeSetPlaneFindingMode(long var1, long var3, int var5);

    private native int nativeGetUpdateMode(long var1, long var3);

    private native void nativeSetUpdateMode(long var1, long var3, int var5);

    private native void nativeSetCloudAnchorMode(long var1, long var3, int var5);

    private native int nativeGetCloudAnchorMode(long var1, long var3);

    private native void nativeSetAugmentedImageDatabase(long var1, long var3, long var5);

    private native void nativeUnsetAugmentedImageDatabase(long var1, long var3);

    private native long nativeGetAugmentedImageDatabase(long var1, long var3);

    private native int nativeGetAugmentedFaceMode(long var1, long var3);

    private native void nativeSetAugmentedFaceMode(long var1, long var3, int var5);

    private native int nativeGetFocusMode(long var1, long var3);

    private native void nativeSetFocusMode(long var1, long var3, int var5);

    public static enum FocusMode {
        FIXED(0),
        AUTO(1);

        final int nativeCode;

        private FocusMode(int n3) {
            this.nativeCode = n3;
        }

        static FocusMode forNumber(int n2) {
            for (FocusMode focusMode : FocusMode.values()) {
                if (focusMode.nativeCode != n2) continue;
                return focusMode;
            }
            throw new FatalException(new StringBuilder(56).append("Unexpected value for native FocusMode, value=").append(n2).toString());
        }
    }

    public static enum AugmentedFaceMode {
        DISABLED(0),
        MESH3D(2);

        final int nativeCode;

        private AugmentedFaceMode(int n3) {
            this.nativeCode = n3;
        }

        static AugmentedFaceMode forNumber(int n2) {
            for (AugmentedFaceMode augmentedFaceMode : AugmentedFaceMode.values()) {
                if (augmentedFaceMode.nativeCode != n2) continue;
                return augmentedFaceMode;
            }
            throw new FatalException(new StringBuilder(64).append("Unexpected value for native AugmentedFaceMode, value=").append(n2).toString());
        }
    }

    public static enum CloudAnchorMode {
        DISABLED(0),
        ENABLED(1);

        final int nativeCode;

        private CloudAnchorMode(int n3) {
            this.nativeCode = n3;
        }

        static CloudAnchorMode forNumber(int n2) {
            for (CloudAnchorMode cloudAnchorMode : CloudAnchorMode.values()) {
                if (cloudAnchorMode.nativeCode != n2) continue;
                return cloudAnchorMode;
            }
            throw new FatalException(new StringBuilder(64).append("Unexpected value for native AnchorHostingMode, value=").append(n2).toString());
        }
    }

    public static enum UpdateMode {
        BLOCKING(0),
        LATEST_CAMERA_IMAGE(1);

        final int nativeCode;

        private UpdateMode(int n3) {
            this.nativeCode = n3;
        }

        static UpdateMode forNumber(int n2) {
            for (UpdateMode updateMode : UpdateMode.values()) {
                if (updateMode.nativeCode != n2) continue;
                return updateMode;
            }
            throw new FatalException(new StringBuilder(57).append("Unexpected value for native UpdateMode, value=").append(n2).toString());
        }
    }

    public static enum PlaneFindingMode {
        DISABLED(0),
        HORIZONTAL(1),
        VERTICAL(2),
        HORIZONTAL_AND_VERTICAL(3);

        final int nativeCode;

        private PlaneFindingMode(int n3) {
            this.nativeCode = n3;
        }

        static PlaneFindingMode forNumber(int n2) {
            for (PlaneFindingMode planeFindingMode : PlaneFindingMode.values()) {
                if (planeFindingMode.nativeCode != n2) continue;
                return planeFindingMode;
            }
            throw new FatalException(new StringBuilder(63).append("Unexpected value for native PlaneFindingMode, value=").append(n2).toString());
        }
    }

    public static enum LightEstimationMode {
        DISABLED(0),
        AMBIENT_INTENSITY(1),
        ENVIRONMENTAL_HDR(2);

        final int nativeCode;

        private LightEstimationMode(int n3) {
            this.nativeCode = n3;
        }

        static LightEstimationMode forNumber(int n2) {
            for (LightEstimationMode lightEstimationMode : LightEstimationMode.values()) {
                if (lightEstimationMode.nativeCode != n2) continue;
                return lightEstimationMode;
            }
            throw new FatalException(new StringBuilder(66).append("Unexpected value for native LightEstimationMode, value=").append(n2).toString());
        }
    }
}

