/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.core;

import com.google.ar.core.Session;

public class CameraIntrinsics {
    private final Session session;
    private final long nativeSymbolTableHandle;
    long nativeHandle = 0L;

    CameraIntrinsics(long l2, Session session) {
        this.nativeHandle = l2;
        this.session = session;
        this.nativeSymbolTableHandle = session.nativeSymbolTableHandle;
    }

    protected CameraIntrinsics() {
        this.session = null;
        this.nativeHandle = 0L;
        this.nativeSymbolTableHandle = 0L;
    }

    protected void finalize() throws Throwable {
        if (this.nativeHandle != 0L) {
            this.nativeDestroyCameraIntrinsics(this.nativeSymbolTableHandle, this.nativeHandle);
        }
        super.finalize();
    }

    public void getFocalLength(float[] fArray, int n2) {
        this.nativeGetFocalLength(this.session.nativeWrapperHandle, this.nativeHandle, fArray, n2);
    }

    public float[] getFocalLength() {
        float[] fArray = new float[2];
        this.getFocalLength(fArray, 0);
        return fArray;
    }

    public void getPrincipalPoint(float[] fArray, int n2) {
        this.nativeGetPrincipalPoint(this.session.nativeWrapperHandle, this.nativeHandle, fArray, n2);
    }

    public float[] getPrincipalPoint() {
        float[] fArray = new float[2];
        this.getPrincipalPoint(fArray, 0);
        return fArray;
    }

    public void getImageDimensions(int[] nArray, int n2) {
        this.nativeGetImageDimensions(this.session.nativeWrapperHandle, this.nativeHandle, nArray, n2);
    }

    public int[] getImageDimensions() {
        int[] nArray = new int[2];
        this.getImageDimensions(nArray, 0);
        return nArray;
    }

    private native long nativeCreateIntrinsics(long var1, float var3, float var4, float var5, float var6, int var7, int var8);

    private native void nativeGetFocalLength(long var1, long var3, float[] var5, int var6);

    private native void nativeGetPrincipalPoint(long var1, long var3, float[] var5, int var6);

    private native void nativeGetImageDimensions(long var1, long var3, int[] var5, int var6);

    private native void nativeDestroyCameraIntrinsics(long var1, long var3);
}

