/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.core;

import com.google.ar.core.CameraConfig;
import com.google.ar.core.Session;
import java.util.EnumSet;

public class CameraConfigFilter {
    private static final String TAG = CameraConfigFilter.class.getSimpleName();
    private final Session session;
    private final long nativeSymbolTableHandle;
    long nativeHandle;

    public CameraConfigFilter(Session session) {
        this.session = session;
        this.nativeHandle = CameraConfigFilter.nativeCreateCameraConfigFilter(session.nativeWrapperHandle);
        this.nativeSymbolTableHandle = session.nativeSymbolTableHandle;
    }

    protected CameraConfigFilter() {
        this.session = null;
        this.nativeHandle = 0L;
        this.nativeSymbolTableHandle = 0L;
    }

    protected void finalize() throws Throwable {
        if (this.nativeHandle != 0L) {
            CameraConfigFilter.nativeDestroyCameraConfigFilter(this.nativeSymbolTableHandle, this.nativeHandle);
            this.nativeHandle = 0L;
        }
        super.finalize();
    }

    public CameraConfigFilter setTargetFps(EnumSet<CameraConfig.TargetFps> enumSet) {
        int n2 = 0;
        for (CameraConfig.TargetFps targetFps : enumSet) {
            n2 |= targetFps.nativeCode;
        }
        this.nativeSetTargetFps(this.session.nativeWrapperHandle, this.nativeHandle, n2);
        return this;
    }

    public CameraConfigFilter setDepthSensorUsage(EnumSet<CameraConfig.DepthSensorUsage> enumSet) {
        int n2 = 0;
        for (CameraConfig.DepthSensorUsage depthSensorUsage : enumSet) {
            n2 |= depthSensorUsage.nativeCode;
        }
        this.nativeSetDepthSensorUsage(this.session.nativeWrapperHandle, this.nativeHandle, n2);
        return this;
    }

    private static native long nativeCreateCameraConfigFilter(long var0);

    private static native void nativeDestroyCameraConfigFilter(long var0, long var2);

    private native void nativeSetTargetFps(long var1, long var3, int var5);

    private native void nativeSetDepthSensorUsage(long var1, long var3, int var5);
}

