/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.core;

import android.util.Range;
import android.util.Size;
import com.google.ar.core.Session;
import com.google.ar.core.exceptions.FatalException;

public class CameraConfig {
    private final Session session;
    private final long nativeSymbolTableHandle;
    long nativeHandle;

    CameraConfig(Session session, long l2) {
        this.session = session;
        this.nativeHandle = l2;
        this.nativeSymbolTableHandle = session.nativeSymbolTableHandle;
    }

    protected CameraConfig() {
        this.session = null;
        this.nativeHandle = 0L;
        this.nativeSymbolTableHandle = 0L;
    }

    protected void finalize() throws Throwable {
        if (this.nativeHandle != 0L) {
            CameraConfig.nativeDestroyCameraConfig(this.nativeSymbolTableHandle, this.nativeHandle);
            this.nativeHandle = 0L;
        }
        super.finalize();
    }

    public Size getImageSize() {
        int[] nArray = new int[2];
        this.nativeGetImageDimensions(this.session.nativeWrapperHandle, this.nativeHandle, nArray);
        return new Size(nArray[0], nArray[1]);
    }

    public Size getTextureSize() {
        int[] nArray = new int[2];
        this.nativeGetTextureDimensions(this.session.nativeWrapperHandle, this.nativeHandle, nArray);
        return new Size(nArray[0], nArray[1]);
    }

    public Range<Integer> getFpsRange() {
        int[] nArray = new int[2];
        this.nativeGetFpsRange(this.session.nativeWrapperHandle, this.nativeHandle, nArray);
        return new Range((Comparable)Integer.valueOf(nArray[0]), (Comparable)Integer.valueOf(nArray[1]));
    }

    public DepthSensorUsage getDepthSensorUsage() {
        return DepthSensorUsage.forNumber(this.nativeGetDepthSensorUsage(this.session.nativeWrapperHandle, this.nativeHandle));
    }

    public String getCameraId() {
        return this.nativeGetCameraId(this.session.nativeWrapperHandle, this.nativeHandle);
    }

    public FacingDirection getFacingDirection() {
        return FacingDirection.forNumber(this.nativeGetFacingDirection(this.session.nativeWrapperHandle, this.nativeHandle));
    }

    private static native void nativeDestroyCameraConfig(long var0, long var2);

    private native void nativeGetImageDimensions(long var1, long var3, int[] var5);

    private native void nativeGetTextureDimensions(long var1, long var3, int[] var5);

    private native void nativeGetFpsRange(long var1, long var3, int[] var5);

    private native int nativeGetDepthSensorUsage(long var1, long var3);

    private native String nativeGetCameraId(long var1, long var3);

    private native int nativeGetFacingDirection(long var1, long var3);

    public static enum DepthSensorUsage {
        REQUIRE_AND_USE(1),
        DO_NOT_USE(2);

        final int nativeCode;

        private DepthSensorUsage(int n3) {
            this.nativeCode = n3;
        }

        static DepthSensorUsage forNumber(int n2) {
            for (DepthSensorUsage depthSensorUsage : DepthSensorUsage.values()) {
                if (depthSensorUsage.nativeCode != n2) continue;
                return depthSensorUsage;
            }
            throw new FatalException(new StringBuilder(63).append("Unexpected value for native DepthSensorUsage, value=").append(n2).toString());
        }
    }

    public static enum TargetFps {
        TARGET_FPS_30(1),
        TARGET_FPS_60(2);

        final int nativeCode;

        private TargetFps(int n3) {
            this.nativeCode = n3;
        }
    }

    public static enum FacingDirection {
        BACK(0),
        FRONT(1);

        final int nativeCode;

        private FacingDirection(int n3) {
            this.nativeCode = n3;
        }

        static FacingDirection forNumber(int n2) {
            for (FacingDirection facingDirection : FacingDirection.values()) {
                if (facingDirection.nativeCode != n2) continue;
                return facingDirection;
            }
            throw new FatalException(new StringBuilder(62).append("Unexpected value for native FacingDirection, value=").append(n2).toString());
        }
    }
}

