/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.core;

import com.google.ar.core.CameraIntrinsics;
import com.google.ar.core.Frame;
import com.google.ar.core.Pose;
import com.google.ar.core.Session;
import com.google.ar.core.TrackingFailureReason;
import com.google.ar.core.TrackingState;

public class Camera {
    private static final String TAG = "ARCore-Camera";
    private final Session session;
    private final long nativeSymbolTableHandle;
    long nativeHandle;

    Camera(Session session, Frame frame) {
        this.session = session;
        this.nativeHandle = Camera.nativeAcquireCamera(session.nativeWrapperHandle, frame.nativeHandle);
        this.nativeSymbolTableHandle = session.nativeSymbolTableHandle;
    }

    protected Camera() {
        this.session = null;
        this.nativeHandle = 0L;
        this.nativeSymbolTableHandle = 0L;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Camera)) {
            return false;
        }
        Camera camera = (Camera)object;
        return camera.nativeHandle == this.nativeHandle;
    }

    public int hashCode() {
        return Long.valueOf(this.nativeHandle).hashCode();
    }

    protected void finalize() throws Throwable {
        if (this.nativeHandle != 0L) {
            Camera.nativeReleaseCamera(this.nativeSymbolTableHandle, this.nativeHandle);
        }
        super.finalize();
    }

    public TrackingState getTrackingState() {
        return TrackingState.forNumber(this.nativeGetTrackingState(this.session.nativeWrapperHandle, this.nativeHandle));
    }

    public TrackingFailureReason getTrackingFailureReason() {
        return TrackingFailureReason.forNumber(this.nativeGetTrackingFailureReason(this.session.nativeWrapperHandle, this.nativeHandle));
    }

    public Pose getPose() {
        return this.nativeGetPose(this.session.nativeWrapperHandle, this.nativeHandle);
    }

    public Pose getDisplayOrientedPose() {
        return this.nativeDisplayOrientedPose(this.session.nativeWrapperHandle, this.nativeHandle);
    }

    public void getViewMatrix(float[] fArray, int n2) {
        this.nativeGetViewMatrix(this.session.nativeWrapperHandle, this.nativeHandle, fArray, n2);
    }

    public void getProjectionMatrix(float[] fArray, int n2, float f2, float f3) {
        this.nativeGetProjectionMatrix(this.session.nativeWrapperHandle, this.nativeHandle, fArray, n2, f2, f3);
    }

    public CameraIntrinsics getImageIntrinsics() {
        long l2 = this.nativeCreateCameraIntrinsics(this.session.nativeWrapperHandle);
        CameraIntrinsics cameraIntrinsics = new CameraIntrinsics(l2, this.session);
        this.nativeGetImageIntrinsics(this.session.nativeWrapperHandle, this.nativeHandle, cameraIntrinsics.nativeHandle);
        return cameraIntrinsics;
    }

    public CameraIntrinsics getTextureIntrinsics() {
        long l2 = this.nativeCreateCameraIntrinsics(this.session.nativeWrapperHandle);
        CameraIntrinsics cameraIntrinsics = new CameraIntrinsics(l2, this.session);
        this.nativeGetTextureIntrinsics(this.session.nativeWrapperHandle, this.nativeHandle, cameraIntrinsics.nativeHandle);
        return cameraIntrinsics;
    }

    private static native long nativeAcquireCamera(long var0, long var2);

    private static native void nativeReleaseCamera(long var0, long var2);

    private native int nativeGetTrackingState(long var1, long var3);

    private native int nativeGetTrackingFailureReason(long var1, long var3);

    private native Pose nativeGetPose(long var1, long var3);

    private native Pose nativeDisplayOrientedPose(long var1, long var3);

    private native void nativeGetViewMatrix(long var1, long var3, float[] var5, int var6);

    private native void nativeGetProjectionMatrix(long var1, long var3, float[] var5, int var6, float var7, float var8);

    private native long nativeCreateCameraIntrinsics(long var1);

    private native void nativeGetImageIntrinsics(long var1, long var3, long var5);

    private native void nativeGetTextureIntrinsics(long var1, long var3, long var5);
}

