/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.core;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.ColorMatrix;
import android.graphics.ColorMatrixColorFilter;
import android.graphics.Paint;
import com.google.ar.core.Session;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;

public class AugmentedImageDatabase {
    private final Session session;
    private final long nativeSymbolTableHandle;
    long nativeHandle;

    public static AugmentedImageDatabase deserialize(Session session, InputStream inputStream) throws IOException {
        ByteBuffer byteBuffer = AugmentedImageDatabase.loadDirectByteBuffer(inputStream);
        long l2 = AugmentedImageDatabase.nativeDeserialize(session.nativeWrapperHandle, byteBuffer);
        return new AugmentedImageDatabase(session, l2);
    }

    public AugmentedImageDatabase(Session session) {
        this(session, AugmentedImageDatabase.nativeCreate(session.nativeWrapperHandle));
    }

    AugmentedImageDatabase(Session session, long l2) {
        this.session = session;
        this.nativeHandle = l2;
        this.nativeSymbolTableHandle = session.nativeSymbolTableHandle;
    }

    public int addImage(String string, Bitmap bitmap) {
        ByteBuffer byteBuffer = AugmentedImageDatabase.convertBitmapToGrayscaleDirectBuffer(bitmap);
        int n2 = bitmap.getWidth();
        return this.nativeAddImage(this.session.nativeWrapperHandle, this.nativeHandle, string, byteBuffer, bitmap.getWidth(), bitmap.getHeight(), n2);
    }

    public int addImage(String string, Bitmap bitmap, float f2) {
        ByteBuffer byteBuffer = AugmentedImageDatabase.convertBitmapToGrayscaleDirectBuffer(bitmap);
        int n2 = bitmap.getWidth();
        return this.nativeAddImageWithPhysicalSize(this.session.nativeWrapperHandle, this.nativeHandle, string, byteBuffer, bitmap.getWidth(), bitmap.getHeight(), n2, f2);
    }

    public int getNumImages() {
        return this.nativeGetNumImages(this.session.nativeWrapperHandle, this.nativeHandle);
    }

    public void serialize(OutputStream outputStream) throws IOException {
        ByteBuffer byteBuffer = this.nativeSerialize(this.session.nativeWrapperHandle, this.nativeHandle);
        WritableByteChannel writableByteChannel = Channels.newChannel(outputStream);
        writableByteChannel.write(byteBuffer);
    }

    protected void finalize() throws Throwable {
        if (this.nativeHandle != 0L) {
            this.nativeReleaseDatabase(this.nativeSymbolTableHandle, this.nativeHandle);
        }
        super.finalize();
    }

    static ByteBuffer convertBitmapToGrayscaleDirectBuffer(Bitmap bitmap) {
        ColorMatrix colorMatrix = new ColorMatrix();
        colorMatrix.setSaturation(0.0f);
        ColorMatrixColorFilter colorMatrixColorFilter = new ColorMatrixColorFilter(colorMatrix);
        Paint paint = new Paint();
        paint.setColorFilter((ColorFilter)colorMatrixColorFilter);
        Bitmap bitmap2 = Bitmap.createBitmap((int)bitmap.getWidth(), (int)bitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap2);
        canvas.drawBitmap(bitmap, 0.0f, 0.0f, paint);
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(bitmap.getWidth() * bitmap.getHeight());
        for (int i2 = 0; i2 < bitmap.getHeight(); ++i2) {
            for (int i3 = 0; i3 < bitmap.getWidth(); ++i3) {
                byteBuffer.put(i2 * bitmap.getWidth() + i3, (byte)Color.red((int)bitmap2.getPixel(i3, i2)));
            }
        }
        return byteBuffer;
    }

    private static ByteBuffer loadDirectByteBuffer(InputStream inputStream) throws IOException {
        int n2;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(Math.max(32, inputStream.available()));
        byte[] byArray = new byte[8192];
        while ((n2 = inputStream.read(byArray)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n2);
        }
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(byArray2.length);
        byteBuffer.put(byArray2);
        return byteBuffer;
    }

    private static native long nativeCreate(long var0);

    private static native long nativeDeserialize(long var0, ByteBuffer var2);

    private native int nativeAddImage(long var1, long var3, String var5, ByteBuffer var6, int var7, int var8, int var9);

    private native int nativeAddImageWithPhysicalSize(long var1, long var3, String var5, ByteBuffer var6, int var7, int var8, int var9, float var10);

    private native ByteBuffer nativeSerialize(long var1, long var3);

    private native int nativeGetNumImages(long var1, long var3);

    private native void nativeReleaseDatabase(long var1, long var3);
}

