/*
 * Decompiled with CFR 0.152.
 */
package com.google.ar.core;

import com.google.ar.core.Pose;
import com.google.ar.core.Session;
import com.google.ar.core.TrackableBase;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;

public class AugmentedFace
extends TrackableBase {
    private static final String TAG = "ARCore-AugmentedFace";
    private FloatBuffer verticesBuffer;
    private FloatBuffer normalsBuffer;
    private FloatBuffer textureCoordinatesBuffer;
    private ShortBuffer triangleIndicesBuffer;

    AugmentedFace(long l2, Session session) {
        super(l2, session);
        this.populateMeshData();
    }

    protected AugmentedFace() {
        super(0L, null);
    }

    void populateMeshData() {
        this.verticesBuffer = Session.directByteBufferOrDefault(this.nativeGetMeshVerticesByteBuffer(this.session.nativeWrapperHandle, this.nativeHandle)).asFloatBuffer();
        this.normalsBuffer = Session.directByteBufferOrDefault(this.nativeGetMeshNormalsByteBuffer(this.session.nativeWrapperHandle, this.nativeHandle)).asFloatBuffer();
        this.textureCoordinatesBuffer = Session.directByteBufferOrDefault(this.nativeGetMeshTextureCoordinatesByteBuffer(this.session.nativeWrapperHandle, this.nativeHandle)).asFloatBuffer();
        this.triangleIndicesBuffer = Session.directByteBufferOrDefault(this.nativeGetMeshTriangleIndicesByteBuffer(this.session.nativeWrapperHandle, this.nativeHandle)).asShortBuffer();
    }

    public FloatBuffer getMeshVertices() {
        return this.verticesBuffer;
    }

    public FloatBuffer getMeshNormals() {
        return this.normalsBuffer;
    }

    public FloatBuffer getMeshTextureCoordinates() {
        return this.textureCoordinatesBuffer;
    }

    public ShortBuffer getMeshTriangleIndices() {
        return this.triangleIndicesBuffer;
    }

    public Pose getRegionPose(RegionType regionType) {
        return this.nativeGetRegionPose(this.session.nativeWrapperHandle, this.nativeHandle, regionType.nativeCode);
    }

    public Pose getCenterPose() {
        return this.nativeGetCenterPose(this.session.nativeWrapperHandle, this.nativeHandle);
    }

    private native ByteBuffer nativeGetMeshVerticesByteBuffer(long var1, long var3);

    private native ByteBuffer nativeGetMeshNormalsByteBuffer(long var1, long var3);

    private native ByteBuffer nativeGetMeshTextureCoordinatesByteBuffer(long var1, long var3);

    private native ByteBuffer nativeGetMeshTriangleIndicesByteBuffer(long var1, long var3);

    private native Pose nativeGetRegionPose(long var1, long var3, int var5);

    private native Pose nativeGetCenterPose(long var1, long var3);

    public static enum RegionType {
        NOSE_TIP(0),
        FOREHEAD_LEFT(1),
        FOREHEAD_RIGHT(2);

        final int nativeCode;

        private RegionType(int n3) {
            this.nativeCode = n3;
        }
    }
}

