/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf.util;

import com.google.common.annotations.PreferKotlinApi;
import com.google.common.time.TimeSource;
import com.google.errorprone.annotations.PreferStaticImport;
import com.google.protobuf.Duration;
import com.google.protobuf.Timestamp;
import com.google.protobuf.util.Durations;
import com.google.protobuf.util.Timestamps;
import java.time.Instant;

public final class JavaTimeConversions {
    private JavaTimeConversions() {
    }

    @PreferKotlinApi(replacement="timestamp.toJavaInstant()", imports={"com.google.protobuf.util.kotlin.toJavaInstant"})
    @PreferStaticImport
    public static Instant toJavaInstant(Timestamp timestamp) {
        timestamp = Timestamps.normalizedTimestamp(timestamp.getSeconds(), timestamp.getNanos());
        return Instant.ofEpochSecond(timestamp.getSeconds(), timestamp.getNanos());
    }

    @PreferKotlinApi(replacement="duration.toJavaDuration()", imports={"com.google.protobuf.util.kotlin.toJavaDuration"})
    @PreferStaticImport
    public static java.time.Duration toJavaDuration(Duration duration) {
        duration = Durations.normalizedDuration(duration.getSeconds(), duration.getNanos());
        return java.time.Duration.ofSeconds(duration.getSeconds(), duration.getNanos());
    }

    @PreferKotlinApi(replacement="instant.toProtoTimestamp()", imports={"com.google.protobuf.util.kotlin.toProtoTimestamp"})
    @PreferStaticImport
    public static Timestamp toProtoTimestamp(Instant instant) {
        return Timestamps.normalizedTimestamp(instant.getEpochSecond(), instant.getNano());
    }

    @PreferKotlinApi(replacement="duration.toProtoDuration()", imports={"com.google.protobuf.util.kotlin.toProtoDuration"})
    @PreferStaticImport
    public static Duration toProtoDuration(java.time.Duration duration) {
        return Durations.normalizedDuration(duration.getSeconds(), duration.getNano());
    }

    public static Timestamp now(TimeSource timeSource) {
        return JavaTimeConversions.toProtoTimestamp(timeSource.now());
    }
}

