/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.config;

import com.esotericsoftware.yamlbeans.YamlConfig;
import com.esotericsoftware.yamlbeans.YamlException;
import com.esotericsoftware.yamlbeans.YamlWriter;
import com.google.common.base.Preconditions;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;

public class ClientDeployYamlMaker {
    public static final String UNKNOWN_RUNTIME = "unknown";
    private String runtime = "unknown";
    private final long startTimeUsec;
    private final ArrayList<Request> requests = new ArrayList();
    private final String sdkVersion;

    public ClientDeployYamlMaker(long startTimeUsec, String sdkVersion) {
        this.startTimeUsec = startTimeUsec;
        this.sdkVersion = (String)Preconditions.checkNotNull((Object)sdkVersion, (Object)"sdkVersion may not be null");
    }

    public void setRuntime(String runtime) {
        this.runtime = (String)Preconditions.checkNotNull((Object)runtime, (Object)"runtime may not be null");
    }

    public void addRequest(String path, int responseCode, long startTimeUsec, long endTimeUsec, long requestSizeBytes) {
        this.requests.add(new Request((String)Preconditions.checkNotNull((Object)path, (Object)"path may not be null"), responseCode, startTimeUsec, endTimeUsec, requestSizeBytes));
    }

    public String getRuntime() {
        return this.runtime;
    }

    public String getSdkVersion() {
        return this.sdkVersion;
    }

    public String make(long endTimeUsec, boolean success) throws YamlException {
        StringWriter stringWriter = new StringWriter();
        YamlConfig yamlConfig = new YamlConfig();
        yamlConfig.writeConfig.setIndentSize(2);
        yamlConfig.writeConfig.setWriteRootTags(false);
        yamlConfig.writeConfig.setWriteRootElementTags(false);
        yamlConfig.writeConfig.setWriteDefaultValues(true);
        yamlConfig.setPropertyElementType(ClientDeploy.class, "requests", Request.class);
        YamlWriter yamlWriter = new YamlWriter((Writer)stringWriter, yamlConfig);
        ClientDeploy clientDeploy = new ClientDeploy(this.runtime, this.startTimeUsec, endTimeUsec, this.requests, success, this.sdkVersion);
        yamlWriter.write((Object)clientDeploy);
        yamlWriter.close();
        return stringWriter.toString();
    }

    public static class Request {
        private String path;
        private int response_code;
        private long start_time_usec;
        private long end_time_usec;
        private long request_size_bytes;

        public Request() {
        }

        public Request(String path, int response_code, long start_time_usec, long end_time_usec, long request_size_bytes) {
            this.path = path;
            this.response_code = response_code;
            this.start_time_usec = start_time_usec;
            this.end_time_usec = end_time_usec;
            this.request_size_bytes = request_size_bytes;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            throw new UnsupportedOperationException();
        }

        public int getResponse_code() {
            return this.response_code;
        }

        public void setResponse_code(int response_code) {
            throw new UnsupportedOperationException();
        }

        public long getStart_time_usec() {
            return this.start_time_usec;
        }

        public void setStart_time_usec(long start_time_usec) {
            throw new UnsupportedOperationException();
        }

        public long getEnd_time_usec() {
            return this.end_time_usec;
        }

        public void setEnd_time_usec(long end_time_usec) {
            throw new UnsupportedOperationException();
        }

        public long getRequest_size_bytes() {
            return this.request_size_bytes;
        }

        public void setRequest_size_bytes(long request_size_bytes) {
            throw new UnsupportedOperationException();
        }
    }

    public static class ClientDeploy {
        private String runtime;
        private long start_time_usec;
        private long end_time_usec;
        private ArrayList<Request> requests;
        private boolean success;
        private String sdk_version;

        public ClientDeploy(String runtime, long start_time_usec, long end_time_usec, ArrayList<Request> requests, boolean success, String sdk_version) {
            this.runtime = runtime;
            this.start_time_usec = start_time_usec;
            this.end_time_usec = end_time_usec;
            this.requests = requests;
            this.success = success;
            this.sdk_version = sdk_version;
        }

        public ClientDeploy() {
        }

        public String getRuntime() {
            return this.runtime;
        }

        public void setRuntime(String runtime) {
            throw new UnsupportedOperationException();
        }

        public long getStart_time_usec() {
            return this.start_time_usec;
        }

        public void setStart_time_usec(long start_time_usec) {
            throw new UnsupportedOperationException();
        }

        public long getEnd_time_usec() {
            return this.end_time_usec;
        }

        public void setEnd_time_usec(long end_time_usec) {
            throw new UnsupportedOperationException();
        }

        public ArrayList<Request> getRequests() {
            return this.requests;
        }

        public void setRequests(ArrayList<Request> requests) {
            throw new UnsupportedOperationException();
        }

        public boolean isSuccess() {
            return this.success;
        }

        public void setSuccess(boolean success) {
            throw new UnsupportedOperationException();
        }

        public String getSdk_version() {
            return this.sdk_version;
        }

        public void setSdk_version(String sdk_version) {
            throw new UnsupportedOperationException();
        }
    }
}

