/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.testing;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.ServerSocket;
import java.util.Map;

public abstract class PortPicker {
    static final String PORT_SERVER_ENV_VAR = "PORTSERVER_PORT";

    public static PortPicker create() {
        return PortPicker.create(System.getenv());
    }

    static PortPicker create(Map<String, String> env) {
        String portServerPortString = env.get(PORT_SERVER_ENV_VAR);
        if (portServerPortString != null) {
            int portServerPort = Integer.parseInt(portServerPortString);
            int pid = PortPicker.getPid();
            return new ViaPortServer(pid, portServerPort);
        }
        return new ViaLocal();
    }

    public abstract int pickUnusedPort();

    private static int getPid() {
        try {
            String pidString = new File("/proc/self").getCanonicalFile().getName();
            return Integer.parseInt(pidString);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static class ViaPortServer
    extends PortPicker {
        private final int pid;
        private final int portServerPort;

        ViaPortServer(int pid, int portServerPort) {
            this.pid = pid;
            this.portServerPort = portServerPort;
        }

        @Override
        public int pickUnusedPort() {
            try {
                return this.pickUnusedPortOrThrow();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        /*
         * Exception decompiling
         */
        private int pickUnusedPortOrThrow() throws IOException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    private static class ViaLocal
    extends PortPicker {
        private ViaLocal() {
        }

        @Override
        public int pickUnusedPort() {
            int n;
            ServerSocket serverSocket = new ServerSocket(0);
            try {
                n = serverSocket.getLocalPort();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        serverSocket.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            serverSocket.close();
            return n;
        }
    }
}

