/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.servlet;

import com.google.appengine.api.taskqueue.TaskQueuePb;
import com.google.appengine.api.taskqueue.dev.LocalTaskQueue;
import com.google.appengine.api.taskqueue.dev.QueueStateInfo;
import com.google.appengine.tools.development.ApiProxyLocal;
import com.google.apphosting.api.ApiProxy;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class TaskQueueViewerServlet
extends HttpServlet {
    private static final Logger logger = Logger.getLogger(TaskQueueViewerServlet.class.getName());
    private static final String APPLICATION_NAME = "applicationName";
    private static final String QUEUE_NAME = "queueName";
    private static final String TASK_NAME = "taskName";
    private static final String LIST_QUEUE_NAME = "listQueueName";
    private static final String LIST_QUEUE_INFO = "listQueueInfo";
    private static final String QUEUE_STATE_INFO = "queueStateInfo";
    private static final String START = "start";
    private static final String NUM_PER_PAGE = "numPerPage";
    private static final String PAGES = "pages";
    private static final String CURRENT_PAGE = "currentPage";
    private static final String PREV_START = "prevStart";
    private static final String NEXT_START = "nextStart";
    private static final int MAX_PAGER_LINKS = 15;
    private static final String QUEUE_NAMES_LIST = "queueNames";
    private static final String TASK_INFO_PAGE = "taskInfoPage";
    private static final String TASK_COUNT = "taskCount";
    private static final String START_BASE_URL = "startBaseURL";
    private static final String ACTION_DELETE_TASK = "action:deletetask";
    private static final String ACTION_EXECUTE_TASK = "action:executetask";
    private static final String ACTION_PURGE_QUEUE = "action:purgequeue";
    private LocalTaskQueue localTaskQueue;

    public void init() throws ServletException {
        super.init();
        ApiProxyLocal apiProxyLocal = (ApiProxyLocal)this.getServletContext().getAttribute("com.google.appengine.devappserver.ApiProxyLocal");
        this.localTaskQueue = (LocalTaskQueue)apiProxyLocal.getService("taskqueue");
    }

    private static String urlencode(String val) throws UnsupportedEncodingException {
        return URLEncoder.encode(val, "UTF-8");
    }

    private Map<String, QueueStateInfo> getQueueInfo() {
        return this.localTaskQueue.getQueueStateInfo();
    }

    private static int getIntParam(ServletRequest request, String paramName, int defaultVal) {
        String val = request.getParameter(paramName);
        try {
            return Integer.parseInt(val);
        }
        catch (NumberFormatException nfe) {
            return defaultVal;
        }
    }

    private static String filterURL(HttpServletRequest req, String ... paramsToInclude) throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder(req.getRequestURI() + "?");
        for (String arg : paramsToInclude) {
            String value = req.getParameter(arg);
            if (value == null) continue;
            sb.append(String.format("&%s=%s", arg, TaskQueueViewerServlet.urlencode(value)));
        }
        return sb.toString();
    }

    private static boolean checkParams(HttpServletRequest req, HttpServletResponse resp, String ... paramsRequired) throws IOException {
        for (String arg : paramsRequired) {
            String value = req.getParameter(arg);
            if (value != null) continue;
            logger.log(Level.SEVERE, "Request does not contain all required parameters :'" + arg + "'.");
            resp.sendError(404);
            return false;
        }
        return true;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        QueueStateInfo queueStateInfo;
        String selectedQueueName = req.getParameter(QUEUE_NAME);
        Map<String, QueueStateInfo> queueInfo = this.getQueueInfo();
        int start = TaskQueueViewerServlet.getIntParam((ServletRequest)req, START, 0);
        int numPerPage = TaskQueueViewerServlet.getIntParam((ServletRequest)req, NUM_PER_PAGE, 10);
        ArrayList<QueueStateInfo.TaskStateInfo> taskPage = new ArrayList<QueueStateInfo.TaskStateInfo>(numPerPage);
        int currentPage = start / numPerPage;
        int startIndex = currentPage * numPerPage;
        int countForQueue = 0;
        if (selectedQueueName != null && (queueStateInfo = queueInfo.get(selectedQueueName)) != null) {
            int lastItemIndex;
            req.setAttribute(LIST_QUEUE_NAME, (Object)selectedQueueName);
            req.setAttribute(LIST_QUEUE_INFO, (Object)queueStateInfo);
            List taskInfo = queueStateInfo.getTaskInfo();
            countForQueue = taskInfo.size();
            if (startIndex >= countForQueue) {
                startIndex = countForQueue - 1;
                currentPage = startIndex / numPerPage;
                startIndex = currentPage * numPerPage;
            }
            if ((lastItemIndex = numPerPage + startIndex) > countForQueue) {
                lastItemIndex = countForQueue;
            }
            for (int index = startIndex; index < lastItemIndex; ++index) {
                taskPage.add((QueueStateInfo.TaskStateInfo)taskInfo.get(index));
            }
        }
        int nextPage = currentPage + 1;
        int numPages = (int)Math.ceil((double)countForQueue * (1.0 / (double)numPerPage));
        int pageStart = (int)Math.max(Math.floor(currentPage - 7), 0.0);
        int pageEnd = Math.min(pageStart + 15, numPages);
        ArrayList<Page> pages = new ArrayList<Page>();
        for (int i = pageStart + 1; i < pageEnd + 1; ++i) {
            pages.add(new Page(i, (i - 1) * numPerPage));
        }
        Set<String> queueNames = queueInfo.keySet();
        QueueBatch pushQueueInfo = new QueueBatch("Push Queues", true, true);
        QueueBatch pullQueueInfo = new QueueBatch("Pull Queues", false, false);
        for (Map.Entry<String, QueueStateInfo> entry : queueInfo.entrySet()) {
            if (entry.getValue().getMode() == TaskQueuePb.TaskQueueMode.Mode.PUSH) {
                pushQueueInfo.put(entry.getKey(), entry.getValue());
                continue;
            }
            pullQueueInfo.put(entry.getKey(), entry.getValue());
        }
        ArrayList<QueueBatch> queueStateInfo2 = new ArrayList<QueueBatch>();
        queueStateInfo2.add(pushQueueInfo);
        queueStateInfo2.add(pullQueueInfo);
        req.setAttribute(QUEUE_STATE_INFO, queueStateInfo2);
        req.setAttribute(QUEUE_NAMES_LIST, queueNames);
        req.setAttribute(TASK_INFO_PAGE, taskPage);
        req.setAttribute(TASK_COUNT, (Object)countForQueue);
        req.setAttribute(APPLICATION_NAME, (Object)ApiProxy.getCurrentEnvironment().getAppId());
        req.setAttribute(PAGES, pages);
        req.setAttribute(CURRENT_PAGE, (Object)nextPage);
        req.setAttribute(START, (Object)startIndex);
        req.setAttribute(NUM_PER_PAGE, (Object)numPerPage);
        req.setAttribute(PREV_START, (Object)(nextPage > 1 ? (nextPage - 2) * numPerPage : -1));
        req.setAttribute(NEXT_START, (Object)(nextPage < numPages ? nextPage * numPerPage : -1));
        req.setAttribute(START_BASE_URL, (Object)TaskQueueViewerServlet.filterURL(req, QUEUE_NAME, NUM_PER_PAGE));
        try {
            this.getServletContext().getRequestDispatcher("/_ah/adminConsole?subsection=taskqueueViewer").forward((ServletRequest)req, (ServletResponse)resp);
        }
        catch (ServletException e) {
            throw new RuntimeException("Could not forward request", e);
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (req.getParameter(ACTION_PURGE_QUEUE) != null) {
            this.purgeQueue(req, resp);
        } else if (req.getParameter(ACTION_DELETE_TASK) != null) {
            this.deleteTask(req, resp);
        } else if (req.getParameter(ACTION_EXECUTE_TASK) != null) {
            this.executeTask(req, resp);
        } else {
            resp.sendError(404);
        }
    }

    private void purgeQueue(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (!TaskQueueViewerServlet.checkParams(req, resp, QUEUE_NAME)) {
            return;
        }
        String queueName = req.getParameter(QUEUE_NAME);
        this.localTaskQueue.flushQueue(queueName);
        String message = "Queue '" + queueName + "' has been purged.";
        resp.sendRedirect(String.format("/_ah/admin/taskqueue?msg=%s", TaskQueueViewerServlet.urlencode(message)));
    }

    private void deleteTask(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        new TaskOperation(){

            @Override
            protected boolean doExecuteInternal(String queueName, String taskName) {
                return TaskQueueViewerServlet.this.localTaskQueue.deleteTask(queueName, taskName);
            }
        }.execute(req, resp, "Deleted task '%s:%s'.", "Failed to delete task '%s:%s'.");
    }

    private void executeTask(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        new TaskOperation(){

            @Override
            protected boolean doExecuteInternal(String queueName, String taskName) {
                return TaskQueueViewerServlet.this.localTaskQueue.runTask(queueName, taskName);
            }
        }.execute(req, resp, "Ran task '%s:%s'.", "Failed to run task '%s:%s'.");
    }

    private abstract class TaskOperation {
        private TaskOperation() {
        }

        public final void execute(HttpServletRequest req, HttpServletResponse resp, String successMsg, String errorMsg) throws IOException {
            if (!TaskQueueViewerServlet.checkParams(req, resp, new String[]{TaskQueueViewerServlet.QUEUE_NAME, TaskQueueViewerServlet.TASK_NAME, TaskQueueViewerServlet.START})) {
                return;
            }
            String queueName = req.getParameter(TaskQueueViewerServlet.QUEUE_NAME);
            String taskName = req.getParameter(TaskQueueViewerServlet.TASK_NAME);
            String start = req.getParameter(TaskQueueViewerServlet.START);
            boolean success = this.doExecuteInternal(queueName, taskName);
            String message = success ? String.format(successMsg, queueName, taskName) : String.format(errorMsg, queueName, taskName);
            resp.sendRedirect(String.format("/_ah/admin/taskqueue?start=%s&queueName=%s&msg=%s", TaskQueueViewerServlet.urlencode(start), TaskQueueViewerServlet.urlencode(queueName), TaskQueueViewerServlet.urlencode(message)));
        }

        protected abstract boolean doExecuteInternal(String var1, String var2);
    }

    public static final class QueueBatch
    extends AbstractCollection<QueueStateInfo> {
        private final String title;
        private final boolean runManually;
        private final boolean rateLimited;
        private final Map<String, QueueStateInfo> contents;

        private QueueBatch(String title, boolean runManually, boolean rateLimited) {
            this.title = title;
            this.runManually = runManually;
            this.rateLimited = rateLimited;
            this.contents = new TreeMap<String, QueueStateInfo>();
        }

        private void put(String key, QueueStateInfo value) {
            this.contents.put(key, value);
        }

        public String getTitle() {
            return this.title;
        }

        public boolean isRunManually() {
            return this.runManually;
        }

        public boolean isRateLimited() {
            return this.rateLimited;
        }

        @Override
        public Iterator<QueueStateInfo> iterator() {
            return this.contents.values().iterator();
        }

        @Override
        public int size() {
            return this.contents.size();
        }
    }

    public static final class Page {
        private final int number;
        private final int start;

        private Page(int number, int start) {
            this.number = number;
            this.start = start;
        }

        public int getNumber() {
            return this.number;
        }

        public int getStart() {
            return this.start;
        }
    }
}

