/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.servlet;

import com.google.appengine.api.capabilities.Capability;
import com.google.appengine.api.capabilities.CapabilityStatus;
import com.google.appengine.api.capabilities.dev.LocalCapabilitiesService;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableMap;
import com.google.appengine.tools.development.ApiProxyLocal;
import com.google.appengine.tools.development.LocalCapabilitiesEnvironment;
import com.google.apphosting.api.ApiProxy;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CapabilitiesStatusServlet
extends HttpServlet {
    private static final String APPLICATION_NAME = "applicationName";
    private LocalCapabilitiesService localCapabilitiesService;
    private LocalCapabilitiesEnvironment localCapabilitiesEnvironment;
    static final ImmutableMap<String, Capability> CAPABILITIES = new ImmutableMap.Builder().put((Object)"BLOBSTORE", (Object)Capability.BLOBSTORE).put((Object)"DATASTORE_WRITE", (Object)Capability.DATASTORE_WRITE).put((Object)"DATASTORE", (Object)Capability.DATASTORE).put((Object)"IMAGES", (Object)Capability.IMAGES).put((Object)"MAIL", (Object)Capability.MAIL).put((Object)"MEMCACHE", (Object)Capability.MEMCACHE).put((Object)"PROSPECTIVE_SEARCH", (Object)Capability.PROSPECTIVE_SEARCH).put((Object)"TASKQUEUE", (Object)Capability.TASKQUEUE).put((Object)"URL_FETCH", (Object)Capability.URL_FETCH).buildOrThrow();
    private static final String CAPABILITIES_STATUS_ATTRIBUTE = "capabilities_status";

    public void init() throws ServletException {
        super.init();
        ApiProxyLocal apiProxyLocal = (ApiProxyLocal)this.getServletContext().getAttribute("com.google.appengine.devappserver.ApiProxyLocal");
        this.localCapabilitiesService = (LocalCapabilitiesService)apiProxyLocal.getService("capability_service");
        this.localCapabilitiesEnvironment = this.localCapabilitiesService.getLocalCapabilitiesEnvironment();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        req.setAttribute(APPLICATION_NAME, (Object)ApiProxy.getCurrentEnvironment().getAppId());
        ArrayList<CapabilityView> capStatus = new ArrayList<CapabilityView>();
        for (Map.Entry entry : CAPABILITIES.entrySet()) {
            Capability cap = (Capability)entry.getValue();
            CapabilityStatus status = this.localCapabilitiesEnvironment.getStatusFromCapabilityName(cap.getPackageName(), cap.getName());
            capStatus.add(new CapabilityView((String)entry.getKey(), status.name()));
        }
        req.setAttribute(CAPABILITIES_STATUS_ATTRIBUTE, capStatus);
        try {
            this.getServletContext().getRequestDispatcher("/_ah/adminConsole?subsection=capabilitiesstatus").forward((ServletRequest)req, (ServletResponse)resp);
        }
        catch (ServletException e) {
            throw new RuntimeException("Could not forward request", e);
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Map params = req.getParameterMap();
        for (Map.Entry entry : params.entrySet()) {
            Capability cap = (Capability)CAPABILITIES.get(entry.getKey());
            if (cap == null) continue;
            this.localCapabilitiesEnvironment.setCapabilitiesStatus(LocalCapabilitiesEnvironment.geCapabilityPropertyKey((String)cap.getPackageName(), (String)cap.getName()), CapabilityStatus.valueOf((String)((String[])entry.getValue())[0]));
        }
        this.doGet(req, resp);
    }

    public static class CapabilityView {
        String name;
        String status;

        public CapabilityView(String name, String status) {
            this.name = name;
            this.status = status;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }
    }
}

