/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.config.jsonwriter;

import com.google.api.server.spi.ObjectMapperUtil;
import com.google.api.server.spi.config.ApiConfig;
import com.google.api.server.spi.config.ResourcePropertySchema;
import com.google.api.server.spi.config.ResourceSchema;
import com.google.api.server.spi.config.annotationreader.ApiAnnotationIntrospector;
import com.google.api.server.spi.config.jsonwriter.AbstractResourceSchemaProvider;
import com.google.appengine.repackaged.org.codehaus.jackson.map.BeanDescription;
import com.google.appengine.repackaged.org.codehaus.jackson.map.BeanPropertyDefinition;
import com.google.appengine.repackaged.org.codehaus.jackson.map.ObjectMapper;
import com.google.appengine.repackaged.org.codehaus.jackson.map.introspect.AnnotatedField;
import com.google.appengine.repackaged.org.codehaus.jackson.map.introspect.AnnotatedMethod;
import com.google.appengine.repackaged.org.codehaus.jackson.type.JavaType;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

class JacksonResourceSchemaProvider
extends AbstractResourceSchemaProvider {
    private static final Logger logger = Logger.getLogger(JacksonResourceSchemaProvider.class.getName());

    JacksonResourceSchemaProvider() {
    }

    @Override
    public ResourceSchema getResourceSchema(Class<?> clazz, ApiConfig config) {
        ResourceSchema schema = super.getResourceSchema(clazz, config);
        if (schema != null) {
            return schema;
        }
        ObjectMapper objectMapper = ObjectMapperUtil.createStandardObjectMapper(config.getSerializationConfig());
        JavaType javaType = objectMapper.getTypeFactory().constructType(clazz);
        Object beanDescription = objectMapper.getSerializationConfig().introspect(javaType);
        List<BeanPropertyDefinition> definitions = ((BeanDescription)beanDescription).findProperties();
        ResourceSchema.Builder schemaBuilder = ResourceSchema.builderForType(clazz);
        for (BeanPropertyDefinition definition : definitions) {
            Type type = this.getPropertyType(JacksonResourceSchemaProvider.toMethod(definition.getGetter()), JacksonResourceSchemaProvider.toMethod(definition.getSetter()), definition.getField(), config);
            if (type != null) {
                schemaBuilder.addProperty(definition.getName(), ResourcePropertySchema.of(type));
                continue;
            }
            String string = String.valueOf(definition.getName());
            String string2 = String.valueOf(clazz.getName());
            logger.logp(Level.WARNING, "com.google.api.server.spi.config.jsonwriter.JacksonResourceSchemaProvider", "getResourceSchema", new StringBuilder(37 + String.valueOf(string).length() + String.valueOf(string2).length()).append("No type found for property ").append(string).append(" on class ").append(string2).toString());
        }
        return schemaBuilder.build();
    }

    private static Method toMethod(AnnotatedMethod am) {
        if (am != null) {
            return am.getAnnotated();
        }
        return null;
    }

    private Type getPropertyType(Method readMethod, Method writeMethod, AnnotatedField field, ApiConfig config) {
        Type[] paramTypes;
        if (readMethod != null) {
            return ApiAnnotationIntrospector.getSchemaType(readMethod.getGenericReturnType(), config);
        }
        if (writeMethod != null && (paramTypes = writeMethod.getGenericParameterTypes()).length == 1) {
            return ApiAnnotationIntrospector.getSchemaType(paramTypes[0], config);
        }
        if (field != null) {
            return ApiAnnotationIntrospector.getSchemaType(field.getGenericType(), config);
        }
        return null;
    }
}

