/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.config;

import com.google.api.server.spi.TypeLoader;
import com.google.api.server.spi.config.ApiMethodConfig;
import com.google.api.server.spi.config.ApiSerializationConfig;
import com.google.api.server.spi.config.ResourceTransformer;
import com.google.api.server.spi.config.Serializers;
import com.google.api.server.spi.config.Transformer;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class ApiParameterConfig {
    private final ApiMethodConfig apiMethodConfig;
    private final String name;
    private final boolean nullable;
    private final String defaultValue;
    private final Type type;
    private Class<? extends Transformer<?, ?>> serializer;
    private Class<? extends Transformer<?, ?>> repeatedItemSerializer;
    private final TypeLoader typeLoader;

    public ApiParameterConfig(ApiMethodConfig apiMethodConfig, String name, boolean nullable, String defaultValue, Type type, TypeLoader typeLoader) {
        this.apiMethodConfig = apiMethodConfig;
        this.name = name;
        this.nullable = nullable;
        this.defaultValue = defaultValue;
        this.type = type;
        this.serializer = null;
        this.repeatedItemSerializer = null;
        this.typeLoader = typeLoader;
    }

    public ApiParameterConfig(ApiParameterConfig original, ApiMethodConfig apiMethodConfig) {
        this.apiMethodConfig = apiMethodConfig;
        this.name = original.name;
        this.nullable = original.nullable;
        this.defaultValue = original.defaultValue;
        this.type = original.type;
        this.serializer = original.serializer;
        this.repeatedItemSerializer = original.repeatedItemSerializer;
        this.typeLoader = original.typeLoader;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ApiParameterConfig) {
            ApiParameterConfig parameter = (ApiParameterConfig)o;
            return Objects.equals(this.name, parameter.name) && this.nullable == parameter.nullable && Objects.equals(this.defaultValue, parameter.defaultValue) && Objects.equals(this.type, parameter.type) && Objects.equals(this.serializer, parameter.serializer) && Objects.equals(this.repeatedItemSerializer, parameter.repeatedItemSerializer) && Objects.equals(this.typeLoader, parameter.typeLoader);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.nullable, this.defaultValue, this.type, this.serializer, this.repeatedItemSerializer, this.typeLoader);
    }

    public ApiMethodConfig getApiMethodConfig() {
        return this.apiMethodConfig;
    }

    public String getName() {
        return this.name;
    }

    public boolean getNullable() {
        return this.nullable;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public Type getType() {
        return this.type;
    }

    public Type getRepeatedItemType() {
        return TypeLoader.getArrayItemType(this.getSchemaBaseType());
    }

    public boolean isRepeated() {
        if (this.typeLoader.isInjectedType(this.getType())) {
            return false;
        }
        return TypeLoader.isArrayType(this.getSchemaBaseType());
    }

    public boolean isEnum() {
        if (this.typeLoader.isInjectedType(this.getType())) {
            return false;
        }
        Type type = this.isRepeated() ? this.getRepeatedItemSerializedType() : this.getSchemaBaseType();
        return TypeLoader.isEnumType(type);
    }

    private List<Class<? extends Transformer<?, ?>>> tryFindDefaultSerializers(Type type) {
        ApiSerializationConfig serializerConfig = this.apiMethodConfig.getApiClassConfig().getApiConfig().getSerializationConfig();
        return Serializers.getSerializerClasses(type, serializerConfig);
    }

    public List<Class<? extends Transformer<?, ?>>> getSerializers() {
        if (this.serializer != null) {
            return Collections.singletonList(this.serializer);
        }
        return this.tryFindDefaultSerializers(this.getType());
    }

    public void setSerializer(Class<? extends Transformer<?, ?>> serializer) {
        this.serializer = serializer;
    }

    public List<Class<? extends Transformer<?, ?>>> getRepeatedItemSerializers() {
        if (this.repeatedItemSerializer != null) {
            return Collections.singletonList(this.repeatedItemSerializer);
        }
        return this.tryFindDefaultSerializers(TypeLoader.getArrayItemType(this.getSchemaBaseType()));
    }

    public void setRepeatedItemSerializer(Class<? extends Transformer<?, ?>> repeatedItemSerializer) {
        this.repeatedItemSerializer = repeatedItemSerializer;
    }

    public Type getSchemaBaseType() {
        List<Class<Transformer<?, ?>>> serializers = this.getSerializers();
        if (serializers.isEmpty()) {
            return this.getType();
        }
        if (ResourceTransformer.class.isAssignableFrom(serializers.get(0))) {
            return this.getType();
        }
        return Serializers.getTargetType(serializers.get(0));
    }

    public Type getRepeatedItemSerializedType() {
        List<Class<Transformer<?, ?>>> serializers = this.getRepeatedItemSerializers();
        if (serializers.isEmpty()) {
            return this.getRepeatedItemType();
        }
        return Serializers.getTargetType(serializers.get(0));
    }

    public Classification getClassification() {
        if (this.typeLoader.isInjectedType(this.type)) {
            return Classification.INJECTED;
        }
        Type type = this.isRepeated() ? this.getRepeatedItemSerializedType() : this.getSchemaBaseType();
        if (this.typeLoader.isParameterType(type) || TypeLoader.isEnumType(type)) {
            return Classification.API_PARAMETER;
        }
        if (TypeLoader.isGenericType(type)) {
            return Classification.UNKNOWN;
        }
        return Classification.RESOURCE;
    }

    public static enum Classification {
        INJECTED,
        API_PARAMETER,
        RESOURCE,
        UNKNOWN;

    }
}

