/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.config;

import com.google.api.server.spi.ServiceContext;
import com.google.api.server.spi.TypeLoader;
import com.google.api.server.spi.config.ApiConfig;
import com.google.api.server.spi.config.ApiConfigException;
import com.google.api.server.spi.config.ApiConfigSource;
import com.google.api.server.spi.config.annotationreader.ApiConfigAnnotationReader;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.base.Predicate;
import com.google.appengine.repackaged.com.google.common.base.Predicates;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.collect.Iterables;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.logging.Logger;

public class ApiConfigLoader {
    private static final Logger logger = Logger.getLogger(ApiConfigLoader.class.getName());
    public static final String INTERNAL_API_NAME = "_GoogleCloudEndpointsInternal";
    private final ApiConfig.Factory configFactory;
    private final TypeLoader typeLoader;
    private final ApiConfigAnnotationReader annotationSource;
    private final ImmutableList<ApiConfigSource> apiConfigSources;

    public ApiConfigLoader(ApiConfig.Factory configFactory, TypeLoader typeLoader, ApiConfigAnnotationReader annotationSource, ApiConfigSource ... apiConfigSources) {
        this.configFactory = (ApiConfig.Factory)Preconditions.checkNotNull((Object)configFactory);
        this.typeLoader = (TypeLoader)Preconditions.checkNotNull((Object)typeLoader);
        this.annotationSource = (ApiConfigAnnotationReader)Preconditions.checkNotNull((Object)annotationSource);
        this.apiConfigSources = ImmutableList.copyOf((Object[])apiConfigSources);
        Preconditions.checkArgument((!Iterables.any(this.apiConfigSources, (Predicate)Predicates.instanceOf(ApiConfigAnnotationReader.class)) ? 1 : 0) != 0, (Object)"Multiple instances of the of ApiConfigAnnotationReader were passed in");
    }

    public ApiConfigLoader() throws ClassNotFoundException {
        this(new ApiConfig.Factory(), new TypeLoader(ApiConfigLoader.class.getClassLoader()), new ApiConfigAnnotationReader(), new ApiConfigSource[0]);
    }

    public ApiConfig loadConfiguration(ServiceContext serviceContext, Class<?> endpointClass) throws ApiConfigException {
        ApiConfig config = this.configFactory.create(serviceContext, this.typeLoader, endpointClass);
        if (!this.annotationSource.loadEndpointClass(serviceContext, endpointClass, config)) {
            throw new ApiConfigException(endpointClass + " has no @Api annotation.");
        }
        ArrayList apiMethodConfigSources = Lists.newArrayList();
        apiMethodConfigSources.add(this.annotationSource);
        for (ApiConfigSource apiConfigSource : this.apiConfigSources) {
            if (apiConfigSource.loadEndpointClass(serviceContext, endpointClass, config)) {
                apiMethodConfigSources.add(apiConfigSource);
                continue;
            }
            logger.warning(String.format("Fail to load endpoint class %s with ApiConfigSource %s", endpointClass, apiConfigSource.getClass()));
        }
        for (ApiConfigSource apiConfigSource : apiMethodConfigSources) {
            apiConfigSource.loadEndpointMethods(serviceContext, endpointClass, config.getApiClassConfig().getMethods());
        }
        return config;
    }

    public ApiConfig loadInternalConfiguration(ServiceContext serviceContext, Class<?> endpointClass) throws ApiConfigException {
        ApiConfig config = this.configFactory.create(serviceContext, this.typeLoader, endpointClass);
        config.setName(INTERNAL_API_NAME);
        this.annotationSource.loadEndpointMethods(serviceContext, endpointClass, config.getApiClassConfig().getMethods());
        return config;
    }

    public boolean isStaticConfig(ApiConfig config) {
        for (ApiConfigSource apiConfigSource : this.apiConfigSources) {
            if (apiConfigSource.isStaticConfig(config)) continue;
            return false;
        }
        return true;
    }

    public ApiConfig reloadConfiguration(ServiceContext serviceContext, Class<?> endpointClass, ApiConfig oldConfig) throws ApiConfigException {
        ApiConfig config = this.configFactory.copy(oldConfig);
        ArrayList apiMethodConfigSources = Lists.newArrayList();
        for (ApiConfigSource apiConfigSource : this.apiConfigSources) {
            if (apiConfigSource.isStaticConfig(config) || !apiConfigSource.loadEndpointClass(serviceContext, endpointClass, config)) continue;
            apiMethodConfigSources.add(apiConfigSource);
        }
        for (ApiConfigSource apiConfigSource : apiMethodConfigSources) {
            apiConfigSource.loadEndpointMethods(serviceContext, endpointClass, config.getApiClassConfig().getMethods());
        }
        return config;
    }
}

