/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.security.urlfetch;

import com.google.appengine.api.urlfetch.HTTPHeader;
import com.google.appengine.api.urlfetch.HTTPMethod;
import com.google.appengine.api.urlfetch.HTTPRequest;
import com.google.appengine.api.urlfetch.HTTPResponse;
import com.google.appengine.api.urlfetch.URLFetchService;
import com.google.appengine.api.urlfetch.URLFetchServiceFactory;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class URLFetchServiceStreamHandler
extends URLStreamHandler {
    static final String DERIVE_RESPONSE_MESSAGE_PROPERTY = "appengine.urlfetch.deriveResponseMessage";
    static final String RESOLVE_INTERNAL_NATIVELY_PROPERTY = "com.google.appengine.urlfetch.resolve.internal.addresses.natively";
    private static final int DEFAULT_DEADLINE_MS = 5000;
    private static final ImmutableMap<Integer, String> HTTP_ERROR_CODES = new ImmutableMap.Builder().put((Object)100, (Object)"CONTINUE").put((Object)101, (Object)"SWITCHING_PROTOCOLS").put((Object)200, (Object)"OK").put((Object)201, (Object)"CREATED").put((Object)202, (Object)"ACCEPTED").put((Object)203, (Object)"NON_AUTHORITATIVE_INFORMATION").put((Object)204, (Object)"NO_CONTENT").put((Object)205, (Object)"RESET_CONTENT").put((Object)206, (Object)"PARTIAL_CONTENT").put((Object)300, (Object)"MULTIPLE_CHOICES").put((Object)301, (Object)"MOVED_PERMANENTLY").put((Object)302, (Object)"FOUND").put((Object)303, (Object)"SEE_OTHER").put((Object)304, (Object)"NOT_MODIFIED").put((Object)305, (Object)"USE_PROXY").put((Object)307, (Object)"TEMPORARY_REDIRECT").put((Object)400, (Object)"BAD_REQUEST").put((Object)401, (Object)"UNAUTHORIZED").put((Object)402, (Object)"PAYMENT_REQUIRED").put((Object)403, (Object)"FORBIDDEN").put((Object)404, (Object)"NOT_FOUND").put((Object)405, (Object)"METHOD_NOT_ALLOWED").put((Object)406, (Object)"NOT_ACCEPTABLE").put((Object)407, (Object)"PROXY_AUTHENTICATION_REQUIRED").put((Object)408, (Object)"REQUEST_TIMEOUT").put((Object)409, (Object)"CONFLICT").put((Object)410, (Object)"GONE").put((Object)411, (Object)"LENGTH_REQUIRED").put((Object)412, (Object)"PRECONDITION_FAILED").put((Object)413, (Object)"REQUEST_ENTITY_TOO_LARGE").put((Object)414, (Object)"REQUEST_URI_TOO_LONG").put((Object)415, (Object)"UNSUPPORTED_MEDIA_TYPE").put((Object)416, (Object)"REQUESTED_RANGE_NOT_SATISFIABLE").put((Object)417, (Object)"EXPECTATION_FAILED").put((Object)500, (Object)"INTERNAL_SERVER_ERROR").put((Object)501, (Object)"NOT_IMPLEMENTED").put((Object)502, (Object)"BAD_GATEWAY").put((Object)503, (Object)"SERVICE_UNAVAILABLE").put((Object)504, (Object)"GATEWAY_TIMEOUT").put((Object)505, (Object)"HTTP_VERSION_NOT_SUPPORTED").put((Object)426, (Object)"UPGRADE_REQUIRED").put((Object)308, (Object)"PERMANENT_REDIRECT").put((Object)102, (Object)"PROCESSING").put((Object)207, (Object)"MULTI_STATUS").put((Object)422, (Object)"UNPROCESSABLE_ENTITY").put((Object)423, (Object)"LOCKED").put((Object)424, (Object)"FAILED_DEPENDENCY").put((Object)507, (Object)"INSUFFICIENT_STORAGE").put((Object)509, (Object)"BANDWIDTH_LIMIT_EXCEEDED").put((Object)428, (Object)"PRECONDITION_REQUIRED").put((Object)429, (Object)"TOO_MANY_REQUESTS").put((Object)431, (Object)"REQUEST_HEADER_FIELDS_TOO_LARGE").put((Object)511, (Object)"NETWORK_AUTHENTICATION_REQUIRED").build();
    private static final Logger logger = Logger.getLogger(URLFetchServiceStreamHandler.class.getName());
    private static Constructor<? extends HttpURLConnection> httpURLConnectionConstructor;
    private static final Pattern INTERNAL;

    private static synchronized Constructor<? extends HttpURLConnection> getHttpURLConnectionConstructor() throws ReflectiveOperationException {
        if (httpURLConnectionConstructor == null) {
            Class<HttpURLConnection> httpURLConnectionClass = Class.forName("sun.net.www.protocol.http.HttpURLConnection").asSubclass(HttpURLConnection.class);
            httpURLConnectionConstructor = httpURLConnectionClass.getConstructor(URL.class, Proxy.class);
        }
        return httpURLConnectionConstructor;
    }

    private static HttpURLConnection openNativeConnection(URL u) throws IOException {
        try {
            return URLFetchServiceStreamHandler.getHttpURLConnectionConstructor().newInstance(u, null);
        }
        catch (ReflectiveOperationException e) {
            throw new IOException("Could not get HttpURLConnection constructor", e);
        }
    }

    @Override
    protected HttpURLConnection openConnection(URL u) throws IOException {
        if (this.shouldOpenNatively(u)) {
            return URLFetchServiceStreamHandler.openNativeConnection(u);
        }
        return new Connection(u);
    }

    @Override
    protected URLConnection openConnection(URL u, Proxy p) throws IOException {
        if (p == null) {
            throw new IllegalArgumentException("p may not be null");
        }
        if (p.equals(Proxy.NO_PROXY)) {
            return this.openConnection(u);
        }
        throw new UnsupportedOperationException("Google App Engine does not support the use of proxies.");
    }

    private boolean shouldOpenNatively(URL url) {
        return Boolean.getBoolean(RESOLVE_INTERNAL_NATIVELY_PROPERTY) && URLFetchServiceStreamHandler.isInternalUrl(url);
    }

    static boolean isInternalUrl(URL url) {
        String host = url.getHost();
        if (host == null) {
            return false;
        }
        return INTERNAL.matcher(host).matches();
    }

    @Override
    protected synchronized InetAddress getHostAddress(URL u) {
        return null;
    }

    static String trim(String s) {
        if (s == null) {
            return null;
        }
        int notWhitespaceChar = 0;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (Character.isWhitespace(c)) continue;
            notWhitespaceChar = i;
            break;
        }
        if (notWhitespaceChar != 0) {
            s = s.substring(notWhitespaceChar);
        }
        return s.trim();
    }

    static {
        INTERNAL = Pattern.compile("(?x: .+\\.internal | (.*:)? 169\\.254\\.\\d+\\.\\d+ )");
    }

    static class Connection
    extends HttpURLConnection {
        private final URLFetchService service = URLFetchServiceFactory.getURLFetchService();
        private HTTPResponse response;
        private LinkedHashMap<String, List<String>> responseFields;
        private BufferingOutputStream outputStream;
        private InputStream inputStream;
        private final LinkedHashMap<String, List<String>> requestProperties = new LinkedHashMap();

        public Connection(URL url) {
            super(url);
            int deadlineMs = DeadlineParser.INSTANCE.deadlineMs;
            if (deadlineMs == -1) {
                deadlineMs = 5000;
            }
            this.setConnectTimeout(deadlineMs);
            this.setReadTimeout(1);
        }

        @Override
        public void disconnect() {
            this.connected = false;
        }

        private boolean isConnected() {
            return this.connected;
        }

        @Override
        public boolean usingProxy() {
            return false;
        }

        @Override
        public void setChunkedStreamingMode(int chunklen) {
            super.setChunkedStreamingMode(chunklen);
        }

        @Override
        public void setRequestMethod(String method) throws ProtocolException {
            method = method.toUpperCase();
            try {
                HTTPMethod.valueOf(method);
            }
            catch (IllegalArgumentException e) {
                throw new ProtocolException(method + " is not one of the supported http methods: " + Arrays.asList(HTTPMethod.values()));
            }
            super.setRequestMethod(method);
        }

        @Override
        public int getResponseCode() throws IOException {
            this.getInputStream();
            return this.responseCode;
        }

        @Override
        public String getResponseMessage() {
            return DeriveResponseMessageProperty.INSTANCE && HTTP_ERROR_CODES.containsKey((Object)this.responseCode) ? (String)HTTP_ERROR_CODES.get((Object)this.responseCode) : "OK";
        }

        @Override
        public InputStream getErrorStream() {
            if (this.connected && this.responseCode >= 400) {
                return this.inputStream;
            }
            return null;
        }

        @Override
        public void connect() throws IOException {
            if (this.connected) {
                return;
            }
            this.connected = true;
        }

        @Override
        public String getHeaderField(String name) {
            List fieldValues = (List)((LinkedHashMap)this.getHeaderFields()).get(name.toLowerCase());
            if (fieldValues == null) {
                return null;
            }
            return (String)fieldValues.get(fieldValues.size() - 1);
        }

        public LinkedHashMap<String, List<String>> getHeaderFields() {
            try {
                this.getInputStream();
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to complete the HTTP request", e);
            }
            return this.responseFields;
        }

        @Override
        public void setRequestProperty(String key, String value) {
            ArrayList<String> values = new ArrayList<String>();
            values.add(value);
            this.requestProperties.put(key, values);
            super.setRequestProperty(key, value);
        }

        @Override
        public void addRequestProperty(String key, String value) {
            List<String> values = this.requestProperties.get(key);
            if (values == null) {
                values = new ArrayList<String>();
                this.requestProperties.put(key, values);
            }
            values.add(value);
            super.addRequestProperty(key, value);
        }

        @Override
        public String getHeaderFieldKey(int n) {
            Map.Entry<String, List<String>> entry = this.getNthEntry(n);
            if (entry != null) {
                return entry.getKey();
            }
            return null;
        }

        @Override
        public String getHeaderField(int n) {
            List<String> values;
            Map.Entry<String, List<String>> entry = this.getNthEntry(n);
            if (entry != null && (values = entry.getValue()) != null) {
                return Joiner.on((String)",").useForNull("null").join(values);
            }
            return null;
        }

        @Override
        public Permission getPermission() throws IOException {
            return null;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            if (this.inputStream != null) {
                return this.inputStream;
            }
            if (!this.getDoInput()) {
                String msg = "Input was not set on this URLConnection. Use \"setDoInput(true)\"";
                throw new IOException(msg);
            }
            this.fetchResponse();
            byte[] content = this.response.getContent();
            if (content == null) {
                content = new byte[]{};
            }
            this.inputStream = new ByteArrayInputStream(content);
            return this.inputStream;
        }

        @Override
        public OutputStream getOutputStream() throws IOException {
            if (this.outputStream != null) {
                return this.outputStream;
            }
            if (!this.getDoOutput()) {
                String msg = "Output was not set on this URLConnection. Use \"setDoOutput(true)\"";
                throw new IOException(msg);
            }
            if (this.method.equalsIgnoreCase(HTTPMethod.GET.name())) {
                this.method = HTTPMethod.POST.name();
            }
            this.connect();
            this.outputStream = new BufferingOutputStream();
            return this.outputStream;
        }

        private Map.Entry<String, List<String>> getNthEntry(int n) {
            Iterator iterator = ((LinkedHashMap)this.getHeaderFields()).entrySet().iterator();
            Map.Entry last = null;
            for (int i = 0; i <= n; ++i) {
                if (!iterator.hasNext()) {
                    return null;
                }
                last = iterator.next();
            }
            return last;
        }

        private HTTPResponse fetchResponse() throws IOException {
            List<Object> values;
            if (this.response != null) {
                return this.response;
            }
            this.connect();
            String method = this.getRequestMethod();
            HTTPMethod httpMethod = HTTPMethod.valueOf(method);
            HTTPRequest request = new HTTPRequest(this.url, httpMethod);
            if (this.getInstanceFollowRedirects()) {
                request.getFetchOptions().followRedirects();
            } else {
                request.getFetchOptions().doNotFollowRedirects();
            }
            int connectTimeoutMillis = this.getConnectTimeout();
            int readTimeoutMillis = this.getReadTimeout();
            double deadlineSeconds = connectTimeoutMillis == 0 || readTimeoutMillis == 0 ? 2.147483647E9 : (double)(this.getConnectTimeout() + this.getReadTimeout()) / 1000.0;
            if (deadlineSeconds > 0.0) {
                request.getFetchOptions().setDeadline(deadlineSeconds);
            }
            for (Map.Entry<String, List<String>> entry : this.requestProperties.entrySet()) {
                String name = entry.getKey();
                values = new ArrayList(entry.getValue());
                for (String string : values) {
                    request.addHeader(new HTTPHeader(name, string));
                }
            }
            if (this.outputStream != null) {
                byte[] output = this.outputStream.toByteArray();
                this.outputStream.close();
                request.setPayload(output);
            }
            this.response = this.service.fetch(request);
            this.responseCode = this.response.getResponseCode();
            if (this.response.getFinalUrl() != null) {
                this.url = this.response.getFinalUrl();
            }
            List<HTTPHeader> headers = this.response.getHeadersUncombined();
            this.responseFields = Maps.newLinkedHashMapWithExpectedSize((int)headers.size());
            for (HTTPHeader header : headers) {
                values = this.responseFields.get(header.getName().toLowerCase());
                if (values == null) {
                    values = new ArrayList();
                    this.responseFields.put(header.getName().toLowerCase(), values);
                }
                values.add(header.getValue().trim());
            }
            return this.response;
        }

        static class DeadlineParser {
            static final DeadlineParser INSTANCE = new DeadlineParser();
            volatile int deadlineMs = -1;

            private DeadlineParser() {
                this.refresh();
            }

            void refresh() {
                String globalDefault = System.getProperty("appengine.api.urlfetch.defaultDeadline");
                if (globalDefault != null) {
                    try {
                        this.deadlineMs = (int)(Double.parseDouble(globalDefault) * 1000.0);
                    }
                    catch (NumberFormatException e) {
                        this.deadlineMs = -1;
                        logger.warning("Cannot parse deadline: " + globalDefault);
                    }
                } else {
                    this.deadlineMs = -1;
                }
            }
        }

        private class BufferingOutputStream
        extends OutputStream {
            private ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            private boolean closed;

            @Override
            public void write(int b) throws IOException {
                this.checkOpen();
                this.buffer.write(b);
            }

            @Override
            public void write(byte[] b) throws IOException {
                this.checkOpen();
                this.buffer.write(b);
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                this.checkOpen();
                this.buffer.write(b, off, len);
            }

            @Override
            public void flush() throws IOException {
                this.checkOpen();
                this.buffer.flush();
            }

            @Override
            public void close() throws IOException {
                this.buffer.close();
                this.closed = true;
                if (!Connection.this.isConnected() && !Connection.this.getDoInput()) {
                    Connection.this.fetchResponse();
                }
            }

            public byte[] toByteArray() {
                return this.buffer.toByteArray();
            }

            private void checkOpen() throws IOException {
                if (this.closed) {
                    String msg = "The OutputStream has been committed and can no longer be written to.";
                    throw new IOException(msg);
                }
            }
        }
    }

    private static class DeriveResponseMessageProperty {
        static final boolean INSTANCE = Boolean.getBoolean("appengine.urlfetch.deriveResponseMessage");

        private DeriveResponseMessageProperty() {
        }
    }
}

