/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search.checkers;

import com.google.appengine.api.search.checkers.DocumentChecker;
import com.google.appengine.api.search.checkers.IndexChecker;
import com.google.appengine.api.search.proto.SearchServicePb;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;

public class GetRequestChecker {
    public static int checkLimit(int limit) {
        Preconditions.checkArgument((limit >= 0 && limit <= 1000 ? 1 : 0) != 0, (String)"The limit %s must be between 0 and %s", (int)limit, (int)1000);
        return limit;
    }

    public static String checkStartDocId(String startDocId) {
        if (Strings.isNullOrEmpty((String)startDocId)) {
            return startDocId;
        }
        return DocumentChecker.checkDocumentId(startDocId);
    }

    public static SearchServicePb.ListDocumentsParams checkListDocumentsParams(SearchServicePb.ListDocumentsParams params) {
        IndexChecker.checkName(params.getIndexSpec().getName());
        if (params.hasLimit()) {
            GetRequestChecker.checkLimit(params.getLimit());
        }
        if (params.hasStartDocId()) {
            DocumentChecker.checkDocumentId(params.getStartDocId());
        }
        return params;
    }
}

