/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search;

import com.google.appengine.api.search.checkers.IndexChecker;
import com.google.appengine.api.search.proto.SearchServicePb;

public class IndexSpec {
    private final String name;

    private IndexSpec(Builder builder) {
        this.name = builder.name;
    }

    public String getName() {
        return this.name;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IndexSpec other = (IndexSpec)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String toString() {
        return String.format("IndexSpec{name: %s}", this.name);
    }

    SearchServicePb.IndexSpec.Builder copyToProtocolBuffer(String namespace) {
        SearchServicePb.IndexSpec.Builder builder = SearchServicePb.IndexSpec.newBuilder().setName(this.getName()).setNamespace(namespace);
        return builder;
    }

    public static final class Builder {
        private String name;

        private Builder() {
        }

        public Builder setName(String name) {
            this.name = IndexChecker.checkName(name);
            return this;
        }

        public IndexSpec build() {
            return new IndexSpec(this);
        }
    }
}

