/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.mail.ee10;

import com.google.appengine.api.mail.BounceNotification;
import com.google.appengine.api.utils.ee10.HttpRequestParser;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.Properties;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public final class BounceNotificationParser
extends HttpRequestParser {
    public static BounceNotification parse(HttpServletRequest request) throws IOException, MessagingException {
        MimeMultipart multipart = BounceNotificationParser.parseMultipartRequest(request);
        BounceNotification.DetailsBuilder originalDetailsBuilder = null;
        BounceNotification.DetailsBuilder notificationDetailsBuilder = null;
        BounceNotification.BounceNotificationBuilder bounceNotificationBuilder = new BounceNotification.BounceNotificationBuilder();
        int parts = multipart.getCount();
        for (int i = 0; i < parts; ++i) {
            BodyPart part = multipart.getBodyPart(i);
            String fieldName = BounceNotificationParser.getFieldName(part);
            if ("raw-message".equals(fieldName)) {
                Session session = Session.getDefaultInstance((Properties)new Properties());
                MimeMessage message = new MimeMessage(session, part.getInputStream());
                bounceNotificationBuilder.withRawMessage(message);
                continue;
            }
            String[] subFields = fieldName.split("-");
            BounceNotification.DetailsBuilder detailsBuilder = null;
            if ("original".equals(subFields[0])) {
                if (originalDetailsBuilder == null) {
                    originalDetailsBuilder = new BounceNotification.DetailsBuilder();
                }
                detailsBuilder = originalDetailsBuilder;
            } else if ("notification".equals(subFields[0])) {
                if (notificationDetailsBuilder == null) {
                    notificationDetailsBuilder = new BounceNotification.DetailsBuilder();
                }
                detailsBuilder = notificationDetailsBuilder;
            }
            if (detailsBuilder == null) continue;
            String field = subFields[1];
            String value = BounceNotificationParser.getTextContent(part);
            if ("to".equals(field)) {
                detailsBuilder.withTo(value);
                continue;
            }
            if ("from".equals(field)) {
                detailsBuilder.withFrom(value);
                continue;
            }
            if ("subject".equals(field)) {
                detailsBuilder.withSubject(value);
                continue;
            }
            if ("text".equals(field)) {
                detailsBuilder.withText(value);
                continue;
            }
            if ("cc".equals(field)) {
                detailsBuilder.withCc(value);
                continue;
            }
            if (!"bcc".equals(field)) continue;
            detailsBuilder.withBcc(value);
        }
        if (originalDetailsBuilder != null) {
            bounceNotificationBuilder.withOriginal(originalDetailsBuilder.build());
        }
        if (notificationDetailsBuilder != null) {
            bounceNotificationBuilder.withNotification(notificationDetailsBuilder.build());
        }
        return bounceNotificationBuilder.build();
    }
}

