/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.Index;
import com.google.appengine.api.datastore.Query;
import com.google.apphosting.api.AppEngineInternal;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.ArrayList;
import java.util.Collections;

@AppEngineInternal
public class IndexTranslator {
    public static OnestoreEntity.Index convertToPb(Index index) {
        OnestoreEntity.Index value = new OnestoreEntity.Index();
        value.setEntityType(index.getKind());
        value.setAncestor(index.isAncestor());
        for (Index.Property property : index.getProperties()) {
            value.mutablePropertys().add(IndexTranslator.convertToPb(property));
        }
        return value;
    }

    public static OnestoreEntity.Index.Property convertToPb(Index.Property property) {
        OnestoreEntity.Index.Property value = new OnestoreEntity.Index.Property();
        value.setName(property.getName());
        Query.SortDirection dir = property.getDirection();
        if (dir != null) {
            value.setDirection(OnestoreEntity.Index.Property.Direction.valueOf((String)dir.name()));
        }
        return value;
    }

    public static Index convertFromPb(OnestoreEntity.CompositeIndex ci) {
        OnestoreEntity.Index index = ci.getDefinition();
        ArrayList<Index.Property> properties = new ArrayList<Index.Property>();
        for (OnestoreEntity.Index.Property protoProperty : index.propertys()) {
            properties.add(IndexTranslator.convertFromPb(protoProperty));
        }
        return new Index(ci.getId(), index.getEntityType(), index.isAncestor(), Collections.unmodifiableList(properties));
    }

    public static Index.Property convertFromPb(OnestoreEntity.Index.Property property) {
        Query.SortDirection dir = property.hasDirection() ? Query.SortDirection.valueOf(property.getDirectionEnum().name()) : null;
        return new Index.Property(property.getName(), dir);
    }

    public static Index convertFromPb(OnestoreEntity.Index index) {
        return IndexTranslator.convertFromPb(new OnestoreEntity.CompositeIndex().setId(0L).setDefinition(index));
    }
}

