/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.taskqueue;

import com.google.appengine.api.taskqueue.DeferredTask;
import com.google.appengine.api.taskqueue.DeferredTaskCreationException;
import com.google.appengine.api.taskqueue.RetryOptions;
import com.google.appengine.api.taskqueue.TaskHandle;
import com.google.appengine.api.taskqueue.TaskQueuePb;
import com.google.appengine.api.taskqueue.UnsupportedTranslationException;
import com.google.common.base.Preconditions;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class TaskOptions
implements Serializable {
    private static final long serialVersionUID = -2702019046191004750L;
    private static final Duration MAX_DISPATCH_DEADLINE = Duration.ofHours(24L);
    private static final Duration MIN_DISPATCH_DEADLINE = Duration.ofSeconds(15L);
    private String taskName;
    private byte[] payload;
    private HashMap<String, List<String>> headers;
    private Method method;
    private List<Param> params;
    private String url;
    private Long countdownMillis;
    private Long etaMillis;
    private RetryOptions retryOptions;
    private byte[] tag;
    private @Nullable Duration dispatchDeadline;

    private TaskOptions() {
        this.method = Method.POST;
        this.headers = new LinkedHashMap<String, List<String>>();
        this.params = new ArrayList<Param>();
    }

    public TaskOptions(TaskOptions options) {
        this.taskName = options.taskName;
        this.method = options.method;
        this.url = options.url;
        this.countdownMillis = options.countdownMillis;
        this.etaMillis = options.etaMillis;
        this.tag(options.tag);
        this.dispatchDeadline = options.dispatchDeadline;
        this.retryOptions = options.retryOptions != null ? new RetryOptions(options.retryOptions) : null;
        if (options.getPayload() != null) {
            this.payload(options.getPayload());
        } else {
            this.payload = null;
        }
        this.headers = TaskOptions.copyOfHeaders(options.getHeaders());
        this.params = new ArrayList<Param>(options.getParams());
    }

    private static LinkedHashMap<String, List<String>> copyOfHeaders(Map<String, List<String>> headers) {
        LinkedHashMap<String, List<String>> copy = new LinkedHashMap<String, List<String>>();
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            copy.put(entry.getKey(), new ArrayList(entry.getValue()));
        }
        return copy;
    }

    public TaskOptions taskName(String taskName) {
        if (taskName != null && taskName.length() != 0) {
            TaskHandle.validateTaskName(taskName);
        }
        this.taskName = taskName;
        return this;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public TaskOptions payload(byte[] payload) {
        this.payload = (byte[])payload.clone();
        return this;
    }

    public TaskOptions payload(DeferredTask deferredTask) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream(1024);
        ObjectOutputStream objectStream = null;
        try {
            objectStream = new ObjectOutputStream(stream);
            objectStream.writeObject(deferredTask);
        }
        catch (IOException e) {
            throw new DeferredTaskCreationException(e);
        }
        this.payload = stream.toByteArray();
        if (this.getMethod() != Method.PULL) {
            this.header("content-type", "application/x-binary-app-engine-java-runnable-task");
            this.method(Method.POST);
            if (this.getUrl() == null) {
                this.url("/_ah/queue/__deferred__");
            }
        }
        return this;
    }

    public TaskOptions payload(String payload, String charset) {
        try {
            return this.payload(payload.getBytes(charset), "text/plain; charset=" + charset);
        }
        catch (UnsupportedEncodingException exception) {
            throw new UnsupportedTranslationException("Unsupported charset '" + charset + "' requested.", exception);
        }
    }

    public TaskOptions payload(byte[] payload, String contentType) {
        return this.payload(payload).header("content-type", contentType);
    }

    public TaskOptions payload(String payload) {
        if (this.getMethod() == Method.PULL) {
            return this.payload(payload.getBytes(Charset.defaultCharset()));
        }
        return this.payload(payload, "UTF-8");
    }

    public Map<String, List<String>> getHeaders() {
        return TaskOptions.copyOfHeaders(this.headers);
    }

    public TaskOptions headers(Map<String, String> headers) {
        this.headers = new LinkedHashMap<String, List<String>>();
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            ArrayList<String> values = new ArrayList<String>(1);
            values.add(entry.getValue());
            this.headers.put(entry.getKey(), values);
        }
        return this;
    }

    public TaskOptions header(String headerName, String value) {
        if (headerName == null || headerName.length() == 0) {
            throw new IllegalArgumentException("headerName must not be null or empty.");
        }
        if (value == null) {
            throw new IllegalArgumentException("header(name, <null>) is not allowed.");
        }
        this.headers.computeIfAbsent(headerName, unused -> new ArrayList()).add(value);
        return this;
    }

    public TaskOptions removeHeader(String headerName) {
        if (headerName == null || headerName.length() == 0) {
            throw new IllegalArgumentException("headerName must not be null or empty.");
        }
        this.headers.remove(headerName);
        return this;
    }

    public Method getMethod() {
        return this.method;
    }

    public TaskOptions method(Method method) {
        this.method = method;
        return this;
    }

    public Map<String, List<String>> getStringParams() {
        LinkedHashMap<String, List<String>> stringParams = new LinkedHashMap<String, List<String>>();
        for (Param param : this.params) {
            if (!(param instanceof StringValueParam)) continue;
            if (!stringParams.containsKey(param.name)) {
                stringParams.put(param.name, new ArrayList());
            }
            stringParams.get(param.name).add(((StringValueParam)param).value);
        }
        return stringParams;
    }

    public Map<String, List<byte[]>> getByteArrayParams() {
        LinkedHashMap<String, List<byte[]>> byteArrayParams = new LinkedHashMap<String, List<byte[]>>();
        for (Param param : this.params) {
            if (!(param instanceof ByteArrayValueParam)) continue;
            if (!byteArrayParams.containsKey(param.name)) {
                byteArrayParams.put(param.name, new ArrayList());
            }
            byte[] value = ((ByteArrayValueParam)param).value;
            byteArrayParams.get(param.name).add(Arrays.copyOf(value, value.length));
        }
        return byteArrayParams;
    }

    List<Param> getParams() {
        return this.params;
    }

    TaskOptions param(Param param) {
        this.params.add(param);
        return this;
    }

    public TaskOptions clearParams() {
        this.params.clear();
        return this;
    }

    public TaskOptions param(String name, String value) {
        return this.param(new StringValueParam(name, value));
    }

    public TaskOptions param(String name, byte[] value) {
        return this.param(new ByteArrayValueParam(name, value));
    }

    public TaskOptions removeParam(String paramName) {
        if (paramName == null || paramName.length() == 0) {
            throw new IllegalArgumentException("paramName must not be null or empty.");
        }
        Iterator<Param> paramsIter = this.params.iterator();
        while (paramsIter.hasNext()) {
            if (!paramName.equals(paramsIter.next().name)) continue;
            paramsIter.remove();
        }
        return this;
    }

    public String getUrl() {
        return this.url;
    }

    public TaskOptions url(String url) {
        if (url == null) {
            throw new IllegalArgumentException("null url is not allowed.");
        }
        this.url = url;
        return this;
    }

    public Long getCountdownMillis() {
        return this.countdownMillis;
    }

    public TaskOptions countdownMillis(long countdownMillis) {
        this.countdownMillis = countdownMillis;
        return this;
    }

    public Long getEtaMillis() {
        return this.etaMillis;
    }

    public TaskOptions etaMillis(long etaMillis) {
        this.etaMillis = etaMillis;
        return this;
    }

    public RetryOptions getRetryOptions() {
        return this.retryOptions == null ? null : new RetryOptions(this.retryOptions);
    }

    public TaskOptions retryOptions(RetryOptions retryOptions) {
        this.retryOptions = retryOptions;
        return this;
    }

    public byte[] getTagAsBytes() {
        return this.tag;
    }

    public String getTag() throws UnsupportedEncodingException {
        if (this.tag != null) {
            return new String(this.tag, StandardCharsets.UTF_8);
        }
        return null;
    }

    public @Nullable Duration getDispatchDeadline() {
        return this.dispatchDeadline;
    }

    public TaskOptions tag(byte[] tag) {
        this.tag = (byte[])(tag != null && tag.length > 0 ? (byte[])tag.clone() : null);
        return this;
    }

    public TaskOptions tag(String tag) {
        if (tag != null) {
            return this.tag(tag.getBytes(StandardCharsets.UTF_8));
        }
        return this;
    }

    public TaskOptions dispatchDeadline(Duration dispatchDeadline) {
        Preconditions.checkNotNull((Object)dispatchDeadline);
        Preconditions.checkArgument((dispatchDeadline.compareTo(MIN_DISPATCH_DEADLINE) >= 0 ? 1 : 0) != 0, (String)"Dispatch deadline %s must be at least %s.", (Object)dispatchDeadline, (Object)MIN_DISPATCH_DEADLINE);
        Preconditions.checkArgument((dispatchDeadline.compareTo(MAX_DISPATCH_DEADLINE) <= 0 ? 1 : 0) != 0, (String)"Dispatch deadline %s must be at most %s.", (Object)dispatchDeadline, (Object)MAX_DISPATCH_DEADLINE);
        this.dispatchDeadline = dispatchDeadline;
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.countdownMillis == null ? 0 : this.countdownMillis.hashCode());
        result = 31 * result + (this.etaMillis == null ? 0 : this.etaMillis.hashCode());
        result = 31 * result + (this.headers == null ? 0 : this.headers.hashCode());
        result = 31 * result + (this.method == null ? 0 : this.method.hashCode());
        result = 31 * result + (this.params == null ? 0 : this.params.hashCode());
        result = 31 * result + Arrays.hashCode(this.payload);
        result = 31 * result + (this.taskName == null ? 0 : this.taskName.hashCode());
        result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
        result = 31 * result + (this.retryOptions == null ? 0 : this.retryOptions.hashCode());
        result = 31 * result + Arrays.hashCode(this.tag);
        result = 31 * result + (this.dispatchDeadline == null ? 0 : this.dispatchDeadline.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TaskOptions other = (TaskOptions)obj;
        if (this.countdownMillis == null ? other.countdownMillis != null : !this.countdownMillis.equals(other.countdownMillis)) {
            return false;
        }
        if (this.etaMillis == null ? other.etaMillis != null : !this.etaMillis.equals(other.etaMillis)) {
            return false;
        }
        if (this.headers == null ? other.headers != null : !this.headers.equals(other.headers)) {
            return false;
        }
        if (this.method == null ? other.method != null : !this.method.equals((Object)other.method)) {
            return false;
        }
        if (this.params == null ? other.params != null : !this.params.equals(other.params)) {
            return false;
        }
        if (!Arrays.equals(this.payload, other.payload)) {
            return false;
        }
        if (this.taskName == null ? other.taskName != null : !this.taskName.equals(other.taskName)) {
            return false;
        }
        if (this.url == null ? other.url != null : !this.url.equals(other.url)) {
            return false;
        }
        if (this.retryOptions == null ? other.retryOptions != null : !this.retryOptions.equals(other.retryOptions)) {
            return false;
        }
        if (!Arrays.equals(this.tag, other.tag)) {
            return false;
        }
        return Objects.equals(this.dispatchDeadline, other.dispatchDeadline);
    }

    public String toString() {
        String tagString = null;
        try {
            tagString = this.getTag();
        }
        catch (UnsupportedEncodingException e) {
            tagString = "not a utf-8 String";
        }
        return "TaskOptions[taskName=" + this.taskName + ", headers=" + this.headers + ", method=" + (Object)((Object)this.method) + ", params=" + this.params + ", url=" + this.url + ", countdownMillis=" + this.countdownMillis + ", etaMillis=" + this.etaMillis + ", retryOptions=" + this.retryOptions + ", tag=" + tagString + ", dispatchDeadline=" + this.dispatchDeadline + "]";
    }

    public static final class Builder {
        public static TaskOptions withTaskName(String taskName) {
            return Builder.withDefaults().taskName(taskName);
        }

        static TaskOptions withPayload(byte[] payload) {
            return Builder.withDefaults().payload(payload);
        }

        public static TaskOptions withPayload(String payload, String charset) {
            return Builder.withDefaults().payload(payload, charset);
        }

        public static TaskOptions withPayload(DeferredTask deferredTask) {
            return Builder.withDefaults().payload(deferredTask);
        }

        public static TaskOptions withPayload(byte[] payload, String contentType) {
            return Builder.withDefaults().payload(payload, contentType);
        }

        public static TaskOptions withPayload(String payload) {
            return Builder.withDefaults().payload(payload);
        }

        public static TaskOptions withHeaders(Map<String, String> headers) {
            return Builder.withDefaults().headers(headers);
        }

        public static TaskOptions withHeader(String headerName, String value) {
            return Builder.withDefaults().header(headerName, value);
        }

        public static TaskOptions withMethod(Method method) {
            return Builder.withDefaults().method(method);
        }

        public static TaskOptions withParam(String paramName, String value) {
            return Builder.withDefaults().param(paramName, value);
        }

        public static TaskOptions withParam(String paramName, byte[] value) {
            return Builder.withDefaults().param(paramName, value);
        }

        public static TaskOptions withUrl(String url) {
            return Builder.withDefaults().url(url);
        }

        public static TaskOptions withCountdownMillis(long countdownMillis) {
            return Builder.withDefaults().countdownMillis(countdownMillis);
        }

        public static TaskOptions withEtaMillis(long etaMillis) {
            return Builder.withDefaults().etaMillis(etaMillis);
        }

        public static TaskOptions withRetryOptions(RetryOptions retryOptions) {
            return Builder.withDefaults().retryOptions(retryOptions);
        }

        public static TaskOptions withTag(byte[] tag) {
            return Builder.withDefaults().tag(tag);
        }

        public static TaskOptions withTag(String tag) {
            return Builder.withDefaults().tag(tag);
        }

        public static TaskOptions withDefaults() {
            return new TaskOptions();
        }

        private Builder() {
        }
    }

    static class ByteArrayValueParam
    extends Param {
        private static final long serialVersionUID = 1420600427192025644L;
        protected final byte[] value;

        ByteArrayValueParam(String name, byte[] value) {
            super(name);
            if (value == null) {
                throw new IllegalArgumentException("value must not be null");
            }
            this.value = value;
        }

        public String toString() {
            return "ByteArrayParam(" + this.name + ": " + this.value.length + " bytes)";
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ByteArrayValueParam)) {
                return false;
            }
            ByteArrayValueParam that = (ByteArrayValueParam)o;
            return Arrays.equals(this.value, that.value) && this.name.equals(that.name);
        }

        @Override
        public String getURLEncodedValue() throws UnsupportedEncodingException {
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < this.value.length; ++i) {
                result.append("%");
                char character = Character.toUpperCase(Character.forDigit(this.value[i] >> 4 & 0xF, 16));
                result.append(character);
                character = Character.toUpperCase(Character.forDigit(this.value[i] & 0xF, 16));
                result.append(character);
            }
            return result.toString();
        }
    }

    static class StringValueParam
    extends Param {
        private static final long serialVersionUID = -2306561754387422446L;
        final String value;

        StringValueParam(String name, String value) {
            super(name);
            if (value == null) {
                throw new IllegalArgumentException("value must not be null");
            }
            this.value = value;
        }

        public String toString() {
            return "StringParam(" + this.name + "=" + this.value + ")";
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof StringValueParam)) {
                return false;
            }
            StringValueParam that = (StringValueParam)o;
            return this.value.equals(that.value) && this.name.equals(that.name);
        }

        @Override
        public String getURLEncodedValue() throws UnsupportedEncodingException {
            return StringValueParam.encodeURLAsUtf8(this.value);
        }
    }

    static abstract class Param
    implements Serializable {
        private static final long serialVersionUID = -4677920038530554173L;
        final String name;

        Param(String name) {
            if (name == null || name.length() == 0) {
                throw new IllegalArgumentException("name must not be null or empty");
            }
            this.name = name;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        static String encodeURLAsUtf8(String url) throws UnsupportedEncodingException {
            return URLEncoder.encode(url, "UTF-8");
        }

        public abstract boolean equals(Object var1);

        String getURLEncodedName() throws UnsupportedEncodingException {
            return Param.encodeURLAsUtf8(this.name);
        }

        abstract String getURLEncodedValue() throws UnsupportedEncodingException;
    }

    public static enum Method {
        DELETE(TaskQueuePb.TaskQueueAddRequest.RequestMethod.DELETE, false),
        GET(TaskQueuePb.TaskQueueAddRequest.RequestMethod.GET, false),
        HEAD(TaskQueuePb.TaskQueueAddRequest.RequestMethod.HEAD, false),
        POST(TaskQueuePb.TaskQueueAddRequest.RequestMethod.POST, true),
        PUT(TaskQueuePb.TaskQueueAddRequest.RequestMethod.PUT, true),
        PULL(null, true);

        private final TaskQueuePb.TaskQueueAddRequest.RequestMethod pbMethod;
        private final boolean isBodyMethod;

        private Method(TaskQueuePb.TaskQueueAddRequest.RequestMethod pbMethod, boolean isBodyMethod) {
            this.pbMethod = pbMethod;
            this.isBodyMethod = isBodyMethod;
        }

        TaskQueuePb.TaskQueueAddRequest.RequestMethod getPbMethod() {
            return this.pbMethod;
        }

        boolean supportsBody() {
            return this.isBodyMethod;
        }
    }
}

