/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.taskqueue;

import com.google.appengine.api.taskqueue.FutureAdapter;
import com.google.appengine.api.taskqueue.Queue;
import com.google.appengine.api.taskqueue.QueueApiHelper;
import com.google.appengine.api.taskqueue.QueueFailureException;
import com.google.appengine.api.taskqueue.TaskQueuePb;
import com.google.appengine.api.taskqueue.TransientFailureException;
import com.google.apphosting.api.ApiProxy;
import com.google.protobuf.ByteString;
import com.google.protobuf.MessageLite;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;

public final class QueueStatistics {
    private final String queueName;
    private final int numTasks;
    private final Long oldestEtaUsec;
    private final long executedLastMinute;
    private final long executedLastHour;
    private final int requestsInFlight;
    private final double enforcedRate;

    QueueStatistics(String queueName, TaskQueuePb.TaskQueueFetchQueueStatsResponse.QueueStats stats) {
        TaskQueuePb.TaskQueueScannerQueueInfo scannerInfo;
        this.queueName = queueName;
        this.numTasks = stats.getNumTasks();
        this.oldestEtaUsec = stats.getOldestEtaUsec() != -1L ? Long.valueOf(stats.getOldestEtaUsec()) : null;
        if (stats.hasScannerInfo()) {
            scannerInfo = stats.getScannerInfo();
            this.executedLastMinute = scannerInfo.getExecutedLastMinute();
            this.executedLastHour = scannerInfo.getExecutedLastHour();
            if (!scannerInfo.hasRequestsInFlight()) {
                throw new IllegalArgumentException("Queue statistics not supplied");
            }
            this.requestsInFlight = scannerInfo.getRequestsInFlight();
            if (!scannerInfo.hasEnforcedRate()) {
                throw new IllegalArgumentException("Queue statistics not supplied");
            }
        } else {
            throw new IllegalArgumentException("Queue statistics not supplied");
        }
        this.enforcedRate = scannerInfo.getEnforcedRate();
    }

    public String getQueueName() {
        return this.queueName;
    }

    public int getNumTasks() {
        return this.numTasks;
    }

    public Long getOldestEtaUsec() {
        return this.oldestEtaUsec;
    }

    public long getExecutedLastMinute() {
        return this.executedLastMinute;
    }

    long getExecutedLastHour() {
        return this.executedLastHour;
    }

    public int getRequestsInFlight() {
        return this.requestsInFlight;
    }

    public double getEnforcedRate() {
        return this.enforcedRate;
    }

    static Future<List<QueueStatistics>> fetchForQueuesAsync(final List<Queue> queues, QueueApiHelper helper, double deadlineInSeconds) {
        TaskQueuePb.TaskQueueFetchQueueStatsRequest.Builder statsRequest = TaskQueuePb.TaskQueueFetchQueueStatsRequest.newBuilder();
        for (Queue queue : queues) {
            statsRequest.addQueueName(ByteString.copyFromUtf8((String)queue.getQueueName()));
        }
        statsRequest.setMaxNumTasks(0);
        ApiProxy.ApiConfig apiConfig = new ApiProxy.ApiConfig();
        apiConfig.setDeadlineInSeconds(Double.valueOf(deadlineInSeconds));
        Future<TaskQueuePb.TaskQueueFetchQueueStatsResponse> responseFuture = helper.makeAsyncCall("FetchQueueStats", (MessageLite)statsRequest.build(), TaskQueuePb.TaskQueueFetchQueueStatsResponse.getDefaultInstance(), apiConfig);
        return new FutureAdapter<TaskQueuePb.TaskQueueFetchQueueStatsResponse, List<QueueStatistics>>(responseFuture){

            @Override
            protected List<QueueStatistics> wrap(TaskQueuePb.TaskQueueFetchQueueStatsResponse statsResponse) {
                if (statsResponse.getQueueStatsCount() != queues.size()) {
                    throw new QueueFailureException("Unable to obtain queue statistics");
                }
                ArrayList<QueueStatistics> resultList = new ArrayList<QueueStatistics>();
                for (int i = 0; i < statsResponse.getQueueStatsCount(); ++i) {
                    TaskQueuePb.TaskQueueFetchQueueStatsResponse.QueueStats stats = statsResponse.getQueueStats(i);
                    if (!stats.hasScannerInfo()) {
                        throw new TransientFailureException("Queue statistics temporarily unavailable");
                    }
                    TaskQueuePb.TaskQueueScannerQueueInfo scannerInfo = stats.getScannerInfo();
                    if (!scannerInfo.hasRequestsInFlight()) {
                        throw new TransientFailureException("Queue statistics temporarily unavailable");
                    }
                    if (!scannerInfo.hasEnforcedRate()) {
                        throw new TransientFailureException("Queue statistics temporarily unavailable");
                    }
                    resultList.add(new QueueStatistics(((Queue)queues.get(i)).getQueueName(), stats));
                }
                return resultList;
            }
        };
    }
}

