/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search.checkers;

import com.google.appengine.api.search.checkers.FacetChecker;
import com.google.appengine.api.search.proto.SearchServicePb;
import com.google.apphosting.api.AppEngineInternal;
import com.google.common.base.Preconditions;

@AppEngineInternal
public final class FacetQueryChecker {
    private static void checkMaximum(int number, int max, String context) {
        Preconditions.checkArgument((number > 0 ? 1 : 0) != 0, (String)"%s should be positive", (Object)context);
        Preconditions.checkArgument((number <= max ? 1 : 0) != 0, (String)"%s must be less than or equal to %s", (Object)context, (int)max);
    }

    public static int checkDiscoveryLimit(int value) {
        FacetQueryChecker.checkMaximum(value, 100, "Facet discovery limit");
        return value;
    }

    public static String checkFacetValue(String value) {
        return FacetChecker.checkAtom(value);
    }

    public static Integer checkDepth(Integer value) {
        if (value != null) {
            FacetQueryChecker.checkMaximum(value, 10000, "Facet depth option");
        }
        return value;
    }

    public static Integer checkDiscoveryValueLimit(Integer value) {
        if (value != null) {
            FacetQueryChecker.checkMaximum(value, 100, "Facet discovery value limit");
        }
        return value;
    }

    public static Integer checkValueLimit(Integer value) {
        if (value != null) {
            FacetQueryChecker.checkMaximum(value, 100, "Facet value limit");
        }
        return value;
    }

    private static void checkRange(SearchServicePb.FacetRange range) {
        Preconditions.checkArgument((boolean)range.getName().isEmpty(), (String)"Facet range name (%s) must be empty.", (Object)range.getName());
        Preconditions.checkArgument((range.hasStart() || range.hasEnd() ? 1 : 0) != 0, (Object)"Facet range is unbounded.");
        Preconditions.checkArgument((!range.hasStart() || FacetQueryChecker.isFinite(range.getStart()) ? 1 : 0) != 0, (String)"Facet range start (%s) must be finite.", (Object)range.getStart());
        Preconditions.checkArgument((!range.hasEnd() || FacetQueryChecker.isFinite(range.getEnd()) ? 1 : 0) != 0, (String)"Facet range end (%s) must be finite.", (Object)range.getEnd());
    }

    private static void checkRefinementRange(SearchServicePb.FacetRefinement.Range range) {
        Preconditions.checkArgument((range.hasStart() || range.hasEnd() ? 1 : 0) != 0, (Object)"Facet refinement range is unbounded.");
        Preconditions.checkArgument((!range.hasStart() || FacetQueryChecker.isFinite(range.getStart()) ? 1 : 0) != 0, (String)"Facet refinement range start (%s) must be finite.", (Object)range.getStart());
        Preconditions.checkArgument((!range.hasEnd() || FacetQueryChecker.isFinite(range.getEnd()) ? 1 : 0) != 0, (String)"Facet refinement range end (%s) must be finite.", (Object)range.getEnd());
    }

    private static boolean isFinite(String numberString) {
        try {
            Double number = Double.parseDouble(numberString);
            return !number.isNaN() && !number.isInfinite();
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static SearchServicePb.SearchParams checkValid(SearchServicePb.SearchParams params) {
        if (params.getAutoDiscoverFacetCount() != 0) {
            FacetQueryChecker.checkDiscoveryLimit(params.getAutoDiscoverFacetCount());
        }
        FacetQueryChecker.checkDepth(params.getFacetDepth());
        FacetQueryChecker.checkDiscoveryValueLimit(params.getFacetAutoDetectParam().getValueLimit());
        for (SearchServicePb.FacetRequest facetRequest : params.getIncludeFacetList()) {
            SearchServicePb.FacetRequestParam reqParams = facetRequest.getParams();
            FacetChecker.checkFacetName(facetRequest.getName());
            if (reqParams.hasValueLimit()) {
                FacetQueryChecker.checkValueLimit(reqParams.getValueLimit());
            }
            Preconditions.checkArgument((reqParams.getValueConstraintCount() <= 50 ? 1 : 0) != 0, (String)"More than %s constraints.", (int)50);
            Preconditions.checkArgument((reqParams.getRangeCount() <= 50 ? 1 : 0) != 0, (String)"More than %s ranges.", (int)50);
            Preconditions.checkArgument((reqParams.getValueConstraintCount() == 0 || reqParams.getRangeCount() == 0 ? 1 : 0) != 0, (Object)"Constraints and ranges set at the same request.");
            for (String constraint : reqParams.getValueConstraintList()) {
                FacetQueryChecker.checkFacetValue(constraint);
            }
            for (SearchServicePb.FacetRange range : reqParams.getRangeList()) {
                FacetQueryChecker.checkRange(range);
            }
        }
        for (SearchServicePb.FacetRefinement ref : params.getFacetRefinementList()) {
            FacetChecker.checkFacetName(ref.getName());
            Preconditions.checkArgument((ref.hasValue() || ref.hasRange() ? 1 : 0) != 0, (String)"Neither value nor range is set for FacetRefinement %s", (Object)ref.getName());
            Preconditions.checkArgument((!ref.hasValue() || !ref.hasRange() ? 1 : 0) != 0, (String)"Both value and range are set for FacetRefinement %s", (Object)ref.getName());
            if (ref.hasValue()) {
                FacetQueryChecker.checkFacetValue(ref.getValue());
            }
            if (!ref.hasRange()) continue;
            FacetQueryChecker.checkRefinementRange(ref.getRange());
        }
        return params;
    }

    private FacetQueryChecker() {
    }
}

