/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.log;

import com.google.appengine.api.log.LogQuery;
import com.google.appengine.api.log.LogServiceImpl;
import com.google.appengine.api.log.RequestLogs;
import com.google.apphosting.api.logservice.LogServicePb;
import com.google.common.base.CharMatcher;
import com.google.common.collect.AbstractIterator;
import com.google.common.io.BaseEncoding;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class LogQueryResult
implements Iterable<RequestLogs> {
    private final List<RequestLogs> logs = new ArrayList<RequestLogs>();
    private final @Nullable String cursor;
    private final LogQuery query;

    protected LogQueryResult(LogServicePb.LogReadResponse response, LogQuery originalQuery) {
        for (LogServicePb.RequestLog log : response.getLogList()) {
            String offset = BaseEncoding.base64().encode(log.getOffset().toByteArray());
            this.logs.add(new RequestLogs(log, offset));
        }
        this.cursor = response.hasOffset() ? BaseEncoding.base64().encode(response.getOffset().toByteArray()) : null;
        this.query = originalQuery.clone();
    }

    protected static LogServicePb.LogOffset parseOffset(String offset) {
        LogServicePb.LogOffset.Builder logOffset = LogServicePb.LogOffset.newBuilder();
        try {
            logOffset.mergeFrom(BaseEncoding.base64().decode((CharSequence)CharMatcher.whitespace().removeFrom((CharSequence)offset)), (ExtensionRegistryLite)ExtensionRegistry.getEmptyRegistry());
            if (!logOffset.isInitialized()) {
                throw new IllegalArgumentException();
            }
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalArgumentException(e);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Can not parse provided offset.");
        }
        return logOffset.build();
    }

    private List<RequestLogs> getLogs() {
        return Collections.unmodifiableList(this.logs);
    }

    private @Nullable String getCursor() {
        return this.cursor;
    }

    @Override
    public Iterator<RequestLogs> iterator() {
        return new AbstractIterator<RequestLogs>(){
            List<RequestLogs> iterLogs;
            @Nullable String iterCursor;
            int index;
            int lengthLogs;
            {
                this.iterLogs = LogQueryResult.this.logs;
                this.iterCursor = LogQueryResult.this.cursor;
                this.index = 0;
                this.lengthLogs = this.iterLogs.size();
            }

            protected RequestLogs computeNext() {
                while (this.index >= this.lengthLogs) {
                    if (this.iterCursor == null) {
                        return (RequestLogs)this.endOfData();
                    }
                    LogQueryResult.this.query.offset(this.iterCursor);
                    LogQueryResult nextResults = new LogServiceImpl().fetch(LogQueryResult.this.query);
                    this.iterLogs = nextResults.getLogs();
                    this.iterCursor = nextResults.getCursor();
                    this.lengthLogs = this.iterLogs.size();
                    this.index = 0;
                }
                return this.iterLogs.get(this.index++);
            }
        };
    }
}

