/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.AbstractIterator;
import com.google.appengine.api.datastore.AutoValue_PreparedMultiQuery_KeyAndProperties;
import com.google.appengine.api.datastore.BasePreparedQuery;
import com.google.appengine.api.datastore.Cursor;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.EntityComparator;
import com.google.appengine.api.datastore.FetchOptions;
import com.google.appengine.api.datastore.Index;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.MultiQueryBuilder;
import com.google.appengine.api.datastore.PreparedQuery;
import com.google.appengine.api.datastore.PreparedQueryImpl;
import com.google.appengine.api.datastore.Projection;
import com.google.appengine.api.datastore.PropertyProjection;
import com.google.appengine.api.datastore.Query;
import com.google.appengine.api.datastore.QueryResult;
import com.google.appengine.api.datastore.QueryResultIterator;
import com.google.appengine.api.datastore.QueryResultIteratorDelegator;
import com.google.appengine.api.datastore.QueryResultList;
import com.google.appengine.api.datastore.QueryResultListDelegator;
import com.google.appengine.api.datastore.QueryRunner;
import com.google.appengine.api.datastore.QueryTranslator;
import com.google.appengine.api.datastore.SlicingIterator;
import com.google.appengine.api.datastore.Transaction;
import com.google.apphosting.datastore.DatastoreV3Pb;
import com.google.auto.value.AutoValue;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import javax.annotation.Nullable;

class PreparedMultiQuery
extends BasePreparedQuery {
    static final int MAX_BUFFERED_QUERIES = 10;
    private final Query baseQuery;
    private final List<MultiQueryBuilder> queryBuilders;
    private final EntityComparator entityComparator;
    private final Transaction txn;
    private final QueryRunner queryRunner;
    private final Set<String> projected;
    private final int[] maxBufferedIteratorsPerBuilder;

    /*
     * WARNING - void declaration
     */
    PreparedMultiQuery(Query baseQuery, List<MultiQueryBuilder> queryBuilders, Transaction txn, QueryRunner queryRunner) {
        boolean bl;
        void var6_15;
        Preconditions.checkArgument((!queryBuilders.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkArgument((baseQuery.getFilter() == null ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)baseQuery.getFilterPredicates().isEmpty());
        this.txn = txn;
        this.baseQuery = baseQuery;
        this.queryBuilders = queryBuilders;
        this.queryRunner = queryRunner;
        if (baseQuery.getProjections().isEmpty()) {
            this.projected = Collections.emptySet();
        } else {
            this.projected = Sets.newHashSet();
            for (Projection projection : baseQuery.getProjections()) {
                this.projected.add(projection.getPropertyName());
            }
            if (!baseQuery.getSortPredicates().isEmpty()) {
                HashSet localProjected = Sets.newHashSet(this.projected);
                for (Query.SortPredicate sortPredicate : baseQuery.getSortPredicates()) {
                    if (!localProjected.add(sortPredicate.getPropertyName())) continue;
                    baseQuery.addProjection(new PropertyProjection(sortPredicate.getPropertyName(), null));
                }
            }
        }
        if (queryBuilders.size() > 1 || queryBuilders.get(0).getParallelQuerySize() > 1) {
            if (baseQuery.isKeysOnly()) {
                for (Query.SortPredicate sortPredicate : baseQuery.getSortPredicates()) {
                    if (sortPredicate.getPropertyName().equals("__key__")) continue;
                    throw new IllegalArgumentException("The provided keys-only multi-query needs to perform some sorting in memory.  As a result, this query can only be sorted by the key property as this is the only property that is available in memory.");
                }
            }
            List<Query.SortPredicate> sortPredicates = baseQuery.getSortPredicates();
            ArrayList<DatastoreV3Pb.Query.Order> arrayList = new ArrayList<DatastoreV3Pb.Query.Order>(sortPredicates.size());
            for (Query.SortPredicate sp : sortPredicates) {
                arrayList.add(QueryTranslator.convertSortPredicateToPb(sp));
            }
            this.entityComparator = new EntityComparator(arrayList);
        } else {
            this.entityComparator = null;
        }
        this.maxBufferedIteratorsPerBuilder = new int[queryBuilders.size()];
        int allocatableQueries = 10;
        boolean bl2 = false;
        while (var6_15 < queryBuilders.size()) {
            void v0 = var6_15;
            this.maxBufferedIteratorsPerBuilder[v0] = this.maxBufferedIteratorsPerBuilder[v0] + 1;
            allocatableQueries -= queryBuilders.get((int)var6_15).getParallelQuerySize();
            ++var6_15;
        }
        boolean bl3 = false;
        while (allocatableQueries > 0 && !bl) {
            void var7_22;
            bl = true;
            boolean bl4 = false;
            while (var7_22 < queryBuilders.size()) {
                if (queryBuilders.get((int)var7_22).getParallelQuerySize() <= allocatableQueries) {
                    void v1 = var7_22;
                    this.maxBufferedIteratorsPerBuilder[v1] = this.maxBufferedIteratorsPerBuilder[v1] + 1;
                    allocatableQueries -= queryBuilders.get((int)var7_22).getParallelQuerySize();
                    bl = false;
                }
                ++var7_22;
            }
        }
    }

    protected PreparedQuery prepareQuery(List<Query.FilterPredicate> filters, boolean isCountQuery) {
        Query query = new Query(this.baseQuery);
        if (isCountQuery && query.getProjections().isEmpty()) {
            query.setKeysOnly();
        }
        query.getFilterPredicates().addAll(filters);
        return new PreparedQueryImpl(query, this.txn, this.queryRunner);
    }

    protected Object getDedupeValue(Entity entity) {
        if (this.projected.isEmpty()) {
            return KeyAndProperties.create(entity.getKey(), null);
        }
        return KeyAndProperties.create(entity.getKey(), entity.getProperties());
    }

    protected List<PreparedQuery> prepareQueries(List<List<Query.FilterPredicate>> filtersList) {
        ArrayList<PreparedQuery> preparedQueries = new ArrayList<PreparedQuery>(filtersList.size());
        for (List<Query.FilterPredicate> filters : filtersList) {
            preparedQueries.add(this.prepareQuery(filters, false));
        }
        return preparedQueries;
    }

    Iterator<Entity> makeHeapIterator(Iterable<Iterator<Entity>> iterators) {
        PriorityQueue<EntitySource> heap = new PriorityQueue<EntitySource>();
        for (Iterator<Entity> iter : iterators) {
            if (!iter.hasNext()) continue;
            heap.add(new EntitySource(this.entityComparator, iter));
        }
        return new HeapIterator(heap);
    }

    static Entity nextResult(PriorityQueue<EntitySource> availableEntitySources) {
        EntitySource current = availableEntitySources.poll();
        if (current == null) {
            return null;
        }
        Entity result = current.currentEntity;
        current.advance();
        if (current.currentEntity != null) {
            availableEntitySources.add(current);
        }
        return result;
    }

    @Override
    public Entity asSingleEntity() throws PreparedQuery.TooManyResultsException {
        List<Entity> result = this.asList(FetchOptions.Builder.withLimit(2));
        if (result.size() == 1) {
            return result.get(0);
        }
        if (result.size() > 1) {
            throw new PreparedQuery.TooManyResultsException();
        }
        return null;
    }

    @Override
    public int countEntities(FetchOptions fetchOptions) {
        FetchOptions overrideOptions = new FetchOptions(fetchOptions);
        overrideOptions.chunkSize(Integer.MAX_VALUE);
        if (fetchOptions.getOffset() != null) {
            overrideOptions.clearOffset();
            if (fetchOptions.getLimit() != null) {
                int adjustedLimit = fetchOptions.getOffset() + fetchOptions.getLimit();
                if (adjustedLimit < 0) {
                    overrideOptions.clearLimit();
                } else {
                    overrideOptions.limit(adjustedLimit);
                }
            }
        }
        HashSet seen = Sets.newHashSet();
        block0: for (MultiQueryBuilder queryBuilder : this.queryBuilders) {
            for (List<List<Query.FilterPredicate>> filtersList : queryBuilder) {
                for (List<Query.FilterPredicate> filters : filtersList) {
                    PreparedQuery preparedQuery = this.prepareQuery(filters, true);
                    Query query = new Query(this.baseQuery);
                    if (query.getProjections().isEmpty()) {
                        query.setKeysOnly();
                    }
                    for (Entity entity : preparedQuery.asIterable(overrideOptions)) {
                        if (!seen.add(this.getDedupeValue(entity)) || overrideOptions.getLimit() == null || seen.size() < overrideOptions.getLimit()) continue;
                        break block0;
                    }
                }
            }
        }
        return fetchOptions.getOffset() == null ? seen.size() : Math.max(0, seen.size() - fetchOptions.getOffset());
    }

    @Override
    public Iterator<Entity> asIterator(FetchOptions fetchOptions) {
        if (fetchOptions.getOffset() != null && fetchOptions.getOffset() > 0 || fetchOptions.getLimit() != null) {
            FetchOptions override = new FetchOptions(fetchOptions);
            if (fetchOptions.getOffset() != null) {
                override.clearOffset();
                if (fetchOptions.getLimit() != null) {
                    int adjustedLimit = fetchOptions.getOffset() + fetchOptions.getLimit();
                    if (adjustedLimit < 0) {
                        override.clearLimit();
                    } else {
                        override.limit(adjustedLimit);
                    }
                }
            }
            return new SlicingIterator<Entity>(this.newFilteredMultiQueryIterator(override), fetchOptions.getOffset(), fetchOptions.getLimit());
        }
        return this.newFilteredMultiQueryIterator(fetchOptions);
    }

    private Iterator<Entity> newFilteredMultiQueryIterator(FetchOptions fetchOptions) {
        HashSet dedupeSet = Sets.newHashSet();
        if (this.queryBuilders.size() == 1) {
            return new FilteredMultiQueryIterator(this.queryBuilders.get(0), fetchOptions, dedupeSet, this.maxBufferedIteratorsPerBuilder[0]);
        }
        ArrayList iterators = Lists.newArrayListWithCapacity((int)this.queryBuilders.size());
        for (int i = 0; i < this.queryBuilders.size(); ++i) {
            iterators.add(new FilteredMultiQueryIterator(this.queryBuilders.get(i), fetchOptions, dedupeSet, this.maxBufferedIteratorsPerBuilder[i]));
        }
        return this.makeHeapIterator(iterators);
    }

    @Override
    public List<Entity> asList(FetchOptions fetchOptions) {
        FetchOptions override = new FetchOptions(fetchOptions);
        if (override.getChunkSize() == null) {
            override.chunkSize(Integer.MAX_VALUE);
        }
        ArrayList<Entity> results = new ArrayList<Entity>();
        Iterables.addAll(results, this.asIterable(override));
        return results;
    }

    @Override
    public QueryResultIterator<Entity> asQueryResultIterator(FetchOptions fetchOptions) {
        return new QueryResultIteratorDelegator<Entity>(new NullQueryResult(), this.asIterator(fetchOptions));
    }

    @Override
    public QueryResultList<Entity> asQueryResultList(FetchOptions fetchOptions) {
        return new QueryResultListDelegator<Entity>(NullQueryResult.INSTANCE, this.asList(fetchOptions));
    }

    private static class NullQueryResult
    implements QueryResult {
        public static final NullQueryResult INSTANCE = new NullQueryResult();

        private NullQueryResult() {
        }

        @Override
        public List<Index> getIndexList() {
            return null;
        }

        @Override
        public Cursor getCursor() {
            return null;
        }
    }

    static final class EntitySource
    implements Comparable<EntitySource> {
        private final EntityComparator entityComparator;
        private final Iterator<Entity> source;
        private Entity currentEntity;

        EntitySource(EntityComparator entityComparator, Iterator<Entity> source) {
            this.entityComparator = entityComparator;
            this.source = source;
            if (!source.hasNext()) {
                throw new IllegalArgumentException("Source iterator has no data.");
            }
            this.currentEntity = source.next();
        }

        private void advance() {
            this.currentEntity = this.source.hasNext() ? this.source.next() : null;
        }

        @Override
        public int compareTo(EntitySource entitySource) {
            return this.entityComparator.compare(this.currentEntity, entitySource.currentEntity);
        }
    }

    static final class HeapIterator
    extends AbstractIterator<Entity> {
        private final PriorityQueue<EntitySource> heap;

        HeapIterator(PriorityQueue<EntitySource> heap) {
            this.heap = heap;
        }

        @Override
        protected Entity computeNext() {
            Entity result = PreparedMultiQuery.nextResult(this.heap);
            if (result == null) {
                this.endOfData();
            }
            return result;
        }
    }

    private class FilteredMultiQueryIterator
    extends AbstractIterator<Entity> {
        private final Iterator<List<List<Query.FilterPredicate>>> multiQueryIterator;
        private final FetchOptions fetchOptions;
        private final Set<Object> seenUniqueValues;
        private Iterator<Entity> currentIterator = Collections.emptyIterator();
        private Queue<Iterator<Entity>> queryIterBuffer;

        public FilteredMultiQueryIterator(MultiQueryBuilder queryBuilder, FetchOptions fetchOptions, Set<Object> seenUniqueValues, int numIteratorsToBuffer) {
            this.multiQueryIterator = queryBuilder.iterator();
            this.queryIterBuffer = new ArrayDeque<Iterator<Entity>>(numIteratorsToBuffer);
            this.fetchOptions = fetchOptions;
            this.seenUniqueValues = seenUniqueValues;
            while (this.queryIterBuffer.size() < numIteratorsToBuffer && this.multiQueryIterator.hasNext()) {
                this.queryIterBuffer.add(this.makeQueryIterator());
            }
        }

        protected Iterator<Entity> getNextIterator() {
            while (!this.queryIterBuffer.isEmpty()) {
                Iterator<Entity> result = this.queryIterBuffer.remove();
                if (this.multiQueryIterator.hasNext()) {
                    this.queryIterBuffer.add(this.makeQueryIterator());
                }
                if (!result.hasNext()) continue;
                return result;
            }
            return null;
        }

        private Iterator<Entity> makeQueryIterator() {
            List<PreparedQuery> queries = PreparedMultiQuery.this.prepareQueries(this.multiQueryIterator.next());
            if (queries.size() == 1) {
                return queries.get(0).asIterator(this.fetchOptions);
            }
            return PreparedMultiQuery.this.makeHeapIterator(Iterables.transform(queries, (Function)new Function<PreparedQuery, Iterator<Entity>>(){

                public Iterator<Entity> apply(PreparedQuery input) {
                    return input.asIterator(FilteredMultiQueryIterator.this.fetchOptions);
                }
            }));
        }

        @Override
        protected Entity computeNext() {
            Entity result = null;
            do {
                if (this.currentIterator.hasNext()) continue;
                this.currentIterator = this.getNextIterator();
                if (this.currentIterator != null) continue;
                return (Entity)this.endOfData();
            } while (!this.seenUniqueValues.add(PreparedMultiQuery.this.getDedupeValue(result = this.currentIterator.next())));
            if (!PreparedMultiQuery.this.projected.isEmpty()) {
                for (String prop : result.getProperties().keySet()) {
                    if (PreparedMultiQuery.this.projected.contains(prop)) continue;
                    result.removeProperty(prop);
                }
            }
            return result;
        }
    }

    @AutoValue
    static abstract class KeyAndProperties {
        KeyAndProperties() {
        }

        static KeyAndProperties create(Key key, @Nullable Map<String, Object> properties) {
            return new AutoValue_PreparedMultiQuery_KeyAndProperties(key, properties);
        }

        abstract Key key();

        @Nullable
        abstract Map<String, Object> properties();
    }
}

