/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.DatastoreApiHelper;
import com.google.appengine.api.datastore.FutureHelper;
import com.google.appengine.api.datastore.Transaction;
import com.google.appengine.api.datastore.TransactionImpl;
import com.google.appengine.api.utils.FutureWrapper;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.datastore.DatastoreV3Pb;
import com.google.apphosting.datastore.proto2api.DatastoreV3Pb;
import com.google.io.protocol.ProtocolMessage;
import com.google.protobuf.MessageLite;
import java.util.concurrent.Future;
import org.checkerframework.checker.nullness.qual.Nullable;

class InternalTransactionV3
implements TransactionImpl.InternalTransaction {
    private final ApiProxy.ApiConfig apiConfig;
    private final String app;
    private final Future<DatastoreV3Pb.Transaction> beginTxnFuture;

    InternalTransactionV3(ApiProxy.ApiConfig apiConfig, String app, Future<DatastoreV3Pb.Transaction> beginTxnFuture) {
        this.apiConfig = apiConfig;
        this.app = app;
        this.beginTxnFuture = beginTxnFuture;
    }

    private long getHandle() {
        return FutureHelper.quietGet(this.beginTxnFuture).getHandle();
    }

    <T extends ProtocolMessage<T>> Future<Void> makeAsyncCall(DatastoreV3Pb.DatastoreService_3.Method method, MessageLite request, T response) {
        Future<T> resultProto = DatastoreApiHelper.makeAsyncCall(this.apiConfig, method, request, response);
        return new FutureWrapper<T, Void>(resultProto){

            @Override
            protected Void wrap(T ignore) throws Exception {
                return null;
            }

            @Override
            protected Throwable convertException(Throwable cause) {
                return cause;
            }
        };
    }

    private <T extends ProtocolMessage<T>> Future<Void> makeAsyncTxnCall(DatastoreV3Pb.DatastoreService_3.Method method, T response) {
        DatastoreV3Pb.Transaction txn = new DatastoreV3Pb.Transaction();
        txn.setApp(this.app);
        txn.setHandle(this.getHandle());
        return this.makeAsyncCall(method, (MessageLite)txn, response);
    }

    @Override
    public Future<Void> doCommitAsync() {
        return this.makeAsyncTxnCall(DatastoreV3Pb.DatastoreService_3.Method.Commit, new DatastoreV3Pb.CommitResponse());
    }

    @Override
    public Future<Void> doRollbackAsync() {
        return this.makeAsyncTxnCall(DatastoreV3Pb.DatastoreService_3.Method.Rollback, null);
    }

    @Override
    public String getId() {
        return Long.toString(this.getHandle());
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InternalTransactionV3 that = (InternalTransactionV3)o;
        return this.getHandle() == that.getHandle();
    }

    @Override
    public int hashCode() {
        return (int)(this.getHandle() ^ this.getHandle() >>> 32);
    }

    static DatastoreV3Pb.Transaction toProto(Transaction txn) {
        DatastoreV3Pb.Transaction txnProto = new DatastoreV3Pb.Transaction();
        txnProto.setApp(txn.getApp());
        txnProto.setHandle(Long.parseLong(txn.getId()));
        return txnProto;
    }

    static DatastoreV3Pb.Transaction toProto2(Transaction txn) {
        return DatastoreV3Pb.Transaction.newBuilder().setApp(txn.getApp()).setHandle(Long.parseLong(txn.getId())).build();
    }
}

