/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.blobstore;

import com.google.common.base.Objects;
import java.util.Date;
import org.checkerframework.checker.nullness.qual.Nullable;

public class FileInfo {
    private final String contentType;
    private final Date creation;
    private final String filename;
    private final long size;
    private final String md5Hash;
    private final @Nullable String gsObjectName;

    public FileInfo(String contentType, Date creation, String filename, long size, String md5Hash, @Nullable String gsObjectName) {
        if (contentType == null) {
            throw new NullPointerException("contentType must not be null");
        }
        if (creation == null) {
            throw new NullPointerException("creation must not be null");
        }
        if (filename == null) {
            throw new NullPointerException("filename must not be null");
        }
        if (md5Hash == null) {
            throw new NullPointerException("md5Hash must not be null");
        }
        this.contentType = contentType;
        this.creation = creation;
        this.filename = filename;
        this.size = size;
        this.md5Hash = md5Hash;
        this.gsObjectName = gsObjectName;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Date getCreation() {
        return this.creation;
    }

    public String getFilename() {
        return this.filename;
    }

    public long getSize() {
        return this.size;
    }

    public String getMd5Hash() {
        return this.md5Hash;
    }

    public @Nullable String getGsObjectName() {
        return this.gsObjectName;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj instanceof FileInfo) {
            FileInfo fi = (FileInfo)obj;
            return this.contentType.equals(fi.contentType) && this.creation.equals(fi.creation) && this.filename.equals(fi.filename) && this.size == fi.size && this.md5Hash.equals(fi.md5Hash) && Objects.equal((Object)this.gsObjectName, (Object)fi.gsObjectName);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.contentType, this.creation, this.filename, this.size, this.md5Hash, this.gsObjectName});
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("<FileInfo:");
        builder.append(" contentType = ");
        builder.append(this.contentType);
        builder.append(", creation = ");
        builder.append(this.creation);
        builder.append(", filename = ");
        builder.append(this.filename);
        builder.append(", size = ");
        builder.append(this.size);
        builder.append(", md5Hash = ");
        builder.append(this.md5Hash);
        if (this.gsObjectName != null) {
            builder.append(", gsObjectName = ");
            builder.append(this.gsObjectName);
        }
        builder.append(">");
        return builder.toString();
    }
}

