/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.blobstore;

import com.google.appengine.api.blobstore.BlobInfo;
import com.google.appengine.api.blobstore.BlobKey;
import com.google.appengine.api.blobstore.BlobstoreFailureException;
import com.google.appengine.api.blobstore.BlobstoreService;
import com.google.appengine.api.blobstore.BlobstoreServicePb;
import com.google.appengine.api.blobstore.ByteRange;
import com.google.appengine.api.blobstore.FileInfo;
import com.google.appengine.api.blobstore.UnsupportedRangeFormatException;
import com.google.appengine.api.blobstore.UploadOptions;
import com.google.apphosting.api.ApiProxy;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.InvalidProtocolBufferException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.checkerframework.checker.nullness.qual.Nullable;

class BlobstoreServiceImpl
implements BlobstoreService {
    static final String PACKAGE = "blobstore";
    static final String SERVE_HEADER = "X-AppEngine-BlobKey";
    static final String UPLOADED_BLOBKEY_ATTR = "com.google.appengine.api.blobstore.upload.blobkeys";
    static final String UPLOADED_BLOBINFO_ATTR = "com.google.appengine.api.blobstore.upload.blobinfos";
    static final String BLOB_RANGE_HEADER = "X-AppEngine-BlobRange";
    static final String CREATION_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";

    BlobstoreServiceImpl() {
    }

    @Override
    public String createUploadUrl(String successPath) {
        return this.createUploadUrl(successPath, UploadOptions.Builder.withDefaults());
    }

    @Override
    public String createUploadUrl(String successPath, UploadOptions uploadOptions) {
        byte[] responseBytes;
        if (successPath == null) {
            throw new NullPointerException("Success path must not be null.");
        }
        BlobstoreServicePb.CreateUploadURLRequest.Builder request = BlobstoreServicePb.CreateUploadURLRequest.newBuilder().setSuccessPath(successPath);
        if (uploadOptions.hasMaxUploadSizeBytesPerBlob()) {
            request.setMaxUploadSizePerBlobBytes(uploadOptions.getMaxUploadSizeBytesPerBlob());
        }
        if (uploadOptions.hasMaxUploadSizeBytes()) {
            request.setMaxUploadSizeBytes(uploadOptions.getMaxUploadSizeBytes());
        }
        if (uploadOptions.hasGoogleStorageBucketName()) {
            request.setGsBucketName(uploadOptions.getGoogleStorageBucketName());
        }
        try {
            responseBytes = ApiProxy.makeSyncCall((String)PACKAGE, (String)"CreateUploadURL", (byte[])request.build().toByteArray());
        }
        catch (ApiProxy.ApplicationException ex) {
            switch (BlobstoreServicePb.BlobstoreServiceError.ErrorCode.forNumber((int)ex.getApplicationError())) {
                case URL_TOO_LONG: {
                    throw new IllegalArgumentException("The resulting URL was too long.");
                }
                case INTERNAL_ERROR: {
                    throw new BlobstoreFailureException("An internal blobstore error occurred.");
                }
            }
            throw new BlobstoreFailureException("An unexpected error occurred.", ex);
        }
        try {
            BlobstoreServicePb.CreateUploadURLResponse response = BlobstoreServicePb.CreateUploadURLResponse.parseFrom((byte[])responseBytes, (ExtensionRegistryLite)ExtensionRegistry.getEmptyRegistry());
            if (!response.isInitialized()) {
                throw new BlobstoreFailureException("Could not parse CreateUploadURLResponse");
            }
            return response.getUrl();
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public void serve(BlobKey blobKey, HttpServletResponse response) {
        this.serve(blobKey, (ByteRange)null, response);
    }

    @Override
    public void serve(BlobKey blobKey, String rangeHeader, HttpServletResponse response) {
        this.serve(blobKey, ByteRange.parse(rangeHeader), response);
    }

    @Override
    public void serve(BlobKey blobKey, @Nullable ByteRange byteRange, HttpServletResponse response) {
        if (response.isCommitted()) {
            throw new IllegalStateException("Response was already committed.");
        }
        response.setContentLength(-1);
        response.setStatus(200);
        response.setHeader(SERVE_HEADER, blobKey.getKeyString());
        if (byteRange != null) {
            response.setHeader(BLOB_RANGE_HEADER, byteRange.toString());
        }
    }

    @Override
    public @Nullable ByteRange getByteRange(HttpServletRequest request) {
        Enumeration rangeHeaders = request.getHeaders("range");
        if (!rangeHeaders.hasMoreElements()) {
            return null;
        }
        String rangeHeader = (String)rangeHeaders.nextElement();
        if (rangeHeaders.hasMoreElements()) {
            throw new UnsupportedRangeFormatException("Cannot accept multiple range headers.");
        }
        return ByteRange.parse(rangeHeader);
    }

    @Override
    public void delete(BlobKey ... blobKeys) {
        BlobstoreServicePb.DeleteBlobRequest.Builder request = BlobstoreServicePb.DeleteBlobRequest.newBuilder();
        for (BlobKey blobKey : blobKeys) {
            request.addBlobKey(blobKey.getKeyString());
        }
        if (request.getBlobKeyCount() == 0) {
            return;
        }
        try {
            ApiProxy.makeSyncCall((String)PACKAGE, (String)"DeleteBlob", (byte[])request.build().toByteArray());
        }
        catch (ApiProxy.ApplicationException ex) {
            switch (BlobstoreServicePb.BlobstoreServiceError.ErrorCode.forNumber((int)ex.getApplicationError())) {
                case INTERNAL_ERROR: {
                    throw new BlobstoreFailureException("An internal blobstore error occurred.");
                }
            }
            throw new BlobstoreFailureException("An unexpected error occurred.", ex);
        }
    }

    @Override
    @Deprecated
    public Map<String, BlobKey> getUploadedBlobs(HttpServletRequest request) {
        Map<String, List<BlobKey>> blobKeys = this.getUploads(request);
        HashMap result = Maps.newHashMapWithExpectedSize((int)blobKeys.size());
        for (Map.Entry<String, List<BlobKey>> entry : blobKeys.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            result.put(entry.getKey(), entry.getValue().get(0));
        }
        return result;
    }

    @Override
    public Map<String, List<BlobKey>> getUploads(HttpServletRequest request) {
        Map attributes = (Map)request.getAttribute(UPLOADED_BLOBKEY_ATTR);
        if (attributes == null) {
            throw new IllegalStateException("Must be called from a blob upload callback request.");
        }
        HashMap blobKeys = Maps.newHashMapWithExpectedSize((int)attributes.size());
        for (Map.Entry attr : attributes.entrySet()) {
            ArrayList<BlobKey> blobs = new ArrayList<BlobKey>(((List)attr.getValue()).size());
            for (String key : (List)attr.getValue()) {
                blobs.add(new BlobKey(key));
            }
            blobKeys.put((String)attr.getKey(), blobs);
        }
        return blobKeys;
    }

    @Override
    public Map<String, List<BlobInfo>> getBlobInfos(HttpServletRequest request) {
        Map attributes = (Map)request.getAttribute(UPLOADED_BLOBINFO_ATTR);
        if (attributes == null) {
            throw new IllegalStateException("Must be called from a blob upload callback request.");
        }
        HashMap blobInfos = Maps.newHashMapWithExpectedSize((int)attributes.size());
        for (Map.Entry attr : attributes.entrySet()) {
            ArrayList<BlobInfo> blobs = new ArrayList<BlobInfo>(((List)attr.getValue()).size());
            for (Map info : (List)attr.getValue()) {
                BlobKey key = new BlobKey(Objects.requireNonNull((String)info.get("key"), "Missing key attribute"));
                String contentType = Objects.requireNonNull((String)info.get("content-type"), "Missing content-type attribute");
                String creationDateAttribute = Objects.requireNonNull((String)info.get("creation-date"), "Missing creation-date attribute");
                Date creationDate = Objects.requireNonNull(BlobstoreServiceImpl.parseCreationDate(creationDateAttribute), () -> "Bad creation-date attribute: " + creationDateAttribute);
                String filename = Objects.requireNonNull((String)info.get("filename"), "Missing filename attribute");
                int size = Integer.parseInt(Objects.requireNonNull((String)info.get("size"), "Missing size attribute"));
                String md5Hash = Objects.requireNonNull((String)info.get("md5-hash"), "Missing md5-hash attribute");
                String gsObjectName = (String)info.get("gs-name");
                blobs.add(new BlobInfo(key, contentType, creationDate, filename, size, md5Hash, gsObjectName));
            }
            blobInfos.put((String)attr.getKey(), blobs);
        }
        return blobInfos;
    }

    @Override
    public Map<String, List<FileInfo>> getFileInfos(HttpServletRequest request) {
        Map attributes = (Map)request.getAttribute(UPLOADED_BLOBINFO_ATTR);
        if (attributes == null) {
            throw new IllegalStateException("Must be called from a blob upload callback request.");
        }
        HashMap fileInfos = Maps.newHashMapWithExpectedSize((int)attributes.size());
        for (Map.Entry attr : attributes.entrySet()) {
            ArrayList<FileInfo> files = new ArrayList<FileInfo>(((List)attr.getValue()).size());
            for (Map info : (List)attr.getValue()) {
                String contentType = Objects.requireNonNull((String)info.get("content-type"), "Missing content-type attribute");
                String creationDateAttribute = Objects.requireNonNull((String)info.get("creation-date"), "Missing creation-date attribute");
                Date creationDate = Objects.requireNonNull(BlobstoreServiceImpl.parseCreationDate(creationDateAttribute), () -> "Invalid creation-date attribute " + creationDateAttribute);
                String filename = Objects.requireNonNull((String)info.get("filename"), "Missing filename attribute");
                long size = Long.parseLong(Objects.requireNonNull((String)info.get("size"), "Missing size attribute"));
                String md5Hash = Objects.requireNonNull((String)info.get("md5-hash"), "Missing md5-hash attribute");
                String gsObjectName = info.getOrDefault("gs-name", null);
                files.add(new FileInfo(contentType, creationDate, filename, size, md5Hash, gsObjectName));
            }
            fileInfos.put((String)attr.getKey(), files);
        }
        return fileInfos;
    }

    @VisibleForTesting
    protected static @Nullable Date parseCreationDate(String date) {
        Date creationDate = null;
        try {
            date = date.trim().substring(0, CREATION_DATE_FORMAT.length());
            SimpleDateFormat dateFormat = new SimpleDateFormat(CREATION_DATE_FORMAT);
            dateFormat.setLenient(false);
            creationDate = dateFormat.parse(date);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return creationDate;
    }

    @Override
    public byte[] fetchData(BlobKey blobKey, long startIndex, long endIndex) {
        byte[] responseBytes;
        if (startIndex < 0L) {
            throw new IllegalArgumentException("Start index must be >= 0.");
        }
        if (endIndex < startIndex) {
            throw new IllegalArgumentException("End index must be >= startIndex.");
        }
        long fetchSize = endIndex - startIndex + 1L;
        if (fetchSize > 1015808L) {
            throw new IllegalArgumentException("Blob fetch size " + fetchSize + " is larger than maximum size " + 1015808 + " bytes.");
        }
        BlobstoreServicePb.FetchDataRequest request = BlobstoreServicePb.FetchDataRequest.newBuilder().setBlobKey(blobKey.getKeyString()).setStartIndex(startIndex).setEndIndex(endIndex).build();
        try {
            responseBytes = ApiProxy.makeSyncCall((String)PACKAGE, (String)"FetchData", (byte[])request.toByteArray());
        }
        catch (ApiProxy.ApplicationException ex) {
            switch (BlobstoreServicePb.BlobstoreServiceError.ErrorCode.forNumber((int)ex.getApplicationError())) {
                case PERMISSION_DENIED: {
                    throw new SecurityException("This application does not have access to that blob.");
                }
                case BLOB_NOT_FOUND: {
                    throw new IllegalArgumentException("Blob not found.");
                }
                case INTERNAL_ERROR: {
                    throw new BlobstoreFailureException("An internal blobstore error occurred.");
                }
            }
            throw new BlobstoreFailureException("An unexpected error occurred.", ex);
        }
        try {
            BlobstoreServicePb.FetchDataResponse response = BlobstoreServicePb.FetchDataResponse.parseFrom((byte[])responseBytes, (ExtensionRegistryLite)ExtensionRegistry.getEmptyRegistry());
            if (!response.isInitialized()) {
                throw new BlobstoreFailureException("Could not parse FetchDataResponse");
            }
            return response.getData().toByteArray();
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public BlobKey createGsBlobKey(String filename) {
        byte[] responseBytes;
        if (!filename.startsWith("/gs/")) {
            throw new IllegalArgumentException("Google storage filenames must be prefixed with /gs/");
        }
        BlobstoreServicePb.CreateEncodedGoogleStorageKeyRequest request = BlobstoreServicePb.CreateEncodedGoogleStorageKeyRequest.newBuilder().setFilename(filename).build();
        try {
            responseBytes = ApiProxy.makeSyncCall((String)PACKAGE, (String)"CreateEncodedGoogleStorageKey", (byte[])request.toByteArray());
        }
        catch (ApiProxy.ApplicationException ex) {
            switch (BlobstoreServicePb.BlobstoreServiceError.ErrorCode.forNumber((int)ex.getApplicationError())) {
                case INTERNAL_ERROR: {
                    throw new BlobstoreFailureException("An internal blobstore error occurred.");
                }
            }
            throw new BlobstoreFailureException("An unexpected error occurred.", ex);
        }
        try {
            BlobstoreServicePb.CreateEncodedGoogleStorageKeyResponse response = BlobstoreServicePb.CreateEncodedGoogleStorageKeyResponse.parseFrom((byte[])responseBytes, (ExtensionRegistryLite)ExtensionRegistry.getEmptyRegistry());
            if (!response.isInitialized()) {
                throw new BlobstoreFailureException("Could not parse CreateEncodedGoogleStorageKeyResponse");
            }
            return new BlobKey(response.getBlobKey());
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

