/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.info;

import com.google.appengine.tools.info.ClassicSdk;
import com.google.appengine.tools.info.LocalVersionFactory;
import com.google.appengine.tools.info.Version;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class AppengineSdk {
    public static final String DEFAULT_SERVER = "appengine.google.com";
    private static AppengineSdk currentSdk;

    public abstract void includeTestingJarOnSharedPath(boolean var1);

    public static AppengineSdk getSdk() {
        currentSdk = (AppengineSdk)MoreObjects.firstNonNull((Object)currentSdk, (Object)new ClassicSdk());
        return currentSdk;
    }

    public static void setSdk(AppengineSdk sdk) {
        currentSdk = (AppengineSdk)Preconditions.checkNotNull((Object)sdk);
    }

    public abstract File getToolsApiJarFile();

    public abstract File getAgentJarFile();

    public abstract List<URL> getSharedLibs();

    public abstract List<URL> getDatanucleusLibs(String var1);

    public List<URL> getUserJspLibs() {
        return Collections.unmodifiableList(this.toURLs(this.getUserJspLibFiles()));
    }

    public abstract List<URL> getImplLibs();

    public abstract List<File> getUserJspLibFiles();

    public abstract List<File> getSharedJspLibFiles();

    public abstract List<File> getSharedLibFiles();

    public abstract List<File> getUserLibFiles();

    public abstract List<URL> getWebApiToolsLibs();

    public abstract String getQuickStartClasspath();

    public abstract String getWebDefaultXml();

    public abstract File getResourcesDirectory();

    public Version getLocalVersion() {
        return new LocalVersionFactory(this.getUserLibFiles()).getVersion();
    }

    public abstract File getLoggingProperties();

    public String getDefaultServer() {
        return DEFAULT_SERVER;
    }

    public void validateDatanucleusVersions(String version) {
        if (!version.equals("v1") && !version.equals("v2")) {
            throw new IllegalArgumentException("Invalid Datanucleus version: " + version);
        }
    }

    List<URL> toURLs(List<File> files) {
        ArrayList<URL> urls = new ArrayList<URL>(files.size());
        for (File file : files) {
            urls.add(this.toURL(file));
        }
        return urls;
    }

    private URL toURL(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Unable get a URL from " + file, e);
        }
    }
}

