/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development;

import com.google.appengine.api.datastore.dev.LocalDatastoreService;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;

public class DevAppServerDatastorePropertyHelper {
    private static final DevAppServerDatastorePropertyHelper HELPER = new DevAppServerDatastorePropertyHelper();
    private final List<DatastoreProperty> defaultDatastoreProperties = new ImmutableList.Builder().add((Object)new DatastoreProperty("datastore.default_high_rep_job_policy_unapplied_job_pct", "10"){

        @Override
        boolean isConfigured(Map<String, String> properties) {
            return properties.get("datastore.default_high_rep_job_policy_unapplied_job_pct") != null || properties.get("datastore.high_replication_job_policy_class") != null;
        }
    }).add((Object)new DatastoreProperty("datastore.auto_id_allocation_policy", LocalDatastoreService.AutoIdAllocationPolicy.SCATTERED.toString())).build();

    private DevAppServerDatastorePropertyHelper() {
    }

    public static void setDefaultProperties(Map<String, String> serviceProperties) {
        Preconditions.checkNotNull(serviceProperties, (Object)"serviceProperties cannot be null");
        for (DatastoreProperty property : DevAppServerDatastorePropertyHelper.HELPER.defaultDatastoreProperties) {
            property.maybeApplyDefault(serviceProperties);
        }
    }

    private class DatastoreProperty {
        private final String property;
        private final String defaultValue;

        DatastoreProperty(String property, String value) {
            this.property = property;
            this.defaultValue = value;
        }

        boolean isConfigured(Map<String, String> properties) {
            return properties.get(this.property) != null;
        }

        void maybeApplyDefault(Map<String, String> properties) {
            if (!this.isConfigured(properties)) {
                properties.put(this.property, this.defaultValue);
            }
        }
    }
}

