/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.taskqueue.dev;

import com.google.appengine.api.taskqueue.TaskQueuePb;
import com.google.appengine.api.taskqueue.dev.DevQueue;
import com.google.appengine.api.taskqueue.dev.LocalTaskQueueCallback;
import com.google.appengine.api.taskqueue.dev.QueueStateInfo;
import com.google.appengine.api.taskqueue.dev.UrlFetchJobDetail;
import com.google.appengine.tools.development.Clock;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.utils.config.QueueXml;
import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import org.quartz.Job;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.spi.TriggerFiredBundle;

class DevPushQueue
extends DevQueue {
    static final int DEFAULT_BUCKET_SIZE = 5;
    private final Scheduler scheduler;
    private final String baseUrl;
    private final Clock clock;
    private final LocalTaskQueueCallback callback;

    @Override
    TaskQueuePb.TaskQueueMode.Mode getMode() {
        return TaskQueuePb.TaskQueueMode.Mode.PUSH;
    }

    DevPushQueue(QueueXml.Entry queueXmlEntry, Scheduler scheduler, String baseUrl, Clock clock, LocalTaskQueueCallback callback) {
        super(queueXmlEntry);
        this.scheduler = scheduler;
        this.baseUrl = baseUrl;
        this.clock = clock;
        this.callback = callback;
        if (queueXmlEntry.getRate() != null) {
            if (queueXmlEntry.getRate() == 0.0) {
                try {
                    scheduler.pauseTriggerGroup(this.getQueueName());
                }
                catch (SchedulerException e) {
                    throw new ApiProxy.ApplicationException(3, e.getMessage());
                }
            }
        } else {
            throw new RuntimeException("Rate must be specified for push queue.");
        }
    }

    private synchronized String scheduleTask(TaskQueuePb.TaskQueueAddRequest.Builder addRequest) {
        String taskName = addRequest.hasTaskName() && !addRequest.getTaskName().isEmpty() ? addRequest.getTaskName().toStringUtf8() : DevPushQueue.genTaskName();
        try {
            if (this.scheduler.getJobDetail(taskName, this.getQueueName()) != null) {
                throw new ApiProxy.ApplicationException(10);
            }
        }
        catch (SchedulerException e) {
            throw new ApiProxy.ApplicationException(3, e.getMessage());
        }
        TaskQueuePb.TaskQueueRetryParameters retryParams = this.getRetryParameters(addRequest);
        long etaMillis = addRequest.getEtaUsec() / 1000L;
        SimpleTrigger trigger = new SimpleTrigger(taskName, this.getQueueName());
        trigger.setStartTime(new Date(etaMillis));
        JobDetail jd = this.newUrlFetchJobDetail(taskName, this.getQueueName(), addRequest, retryParams);
        try {
            this.scheduler.scheduleJob(jd, (Trigger)trigger);
        }
        catch (SchedulerException e) {
            throw new ApiProxy.ApplicationException(3, e.getMessage());
        }
        return taskName;
    }

    JobDetail newUrlFetchJobDetail(String taskName, String queueName, TaskQueuePb.TaskQueueAddRequest.Builder addRequest, TaskQueuePb.TaskQueueRetryParameters retryParams) {
        for (TaskQueuePb.TaskQueueAddRequest.Header header : addRequest.getHeaderList()) {
            String host;
            if (!header.getKey().toStringUtf8().equals("Host") || !(host = header.getValue().toStringUtf8()).startsWith("localhost:")) continue;
            return new UrlFetchJobDetail(taskName, queueName, addRequest, "http://" + host, this.callback, this.queueXmlEntry, retryParams);
        }
        return new UrlFetchJobDetail(taskName, queueName, addRequest, this.baseUrl, this.callback, this.queueXmlEntry, retryParams);
    }

    @Override
    TaskQueuePb.TaskQueueAddResponse add(TaskQueuePb.TaskQueueAddRequest.Builder addRequest) {
        if (addRequest.getMode() != TaskQueuePb.TaskQueueMode.Mode.PUSH) {
            throw new ApiProxy.ApplicationException(21);
        }
        if (!addRequest.getQueueName().toStringUtf8().equals(this.getQueueName())) {
            throw new ApiProxy.ApplicationException(13);
        }
        String taskName = this.scheduleTask(addRequest);
        TaskQueuePb.TaskQueueAddResponse.Builder addResponse = TaskQueuePb.TaskQueueAddResponse.newBuilder();
        if (!addRequest.hasTaskName() || addRequest.getTaskName().isEmpty()) {
            addRequest.setTaskName(ByteString.copyFromUtf8((String)taskName));
            addResponse.setChosenTaskName(ByteString.copyFromUtf8((String)taskName));
        }
        return addResponse.build();
    }

    List<String> getSortedJobNames() throws SchedulerException {
        String[] jobNames = this.scheduler.getJobNames(this.getQueueName());
        List<String> jobNameList = Arrays.asList(jobNames);
        Collections.sort(jobNameList);
        return jobNameList;
    }

    @Override
    QueueStateInfo getStateInfo() {
        ArrayList<QueueStateInfo.TaskStateInfo> taskInfoList = new ArrayList<QueueStateInfo.TaskStateInfo>();
        try {
            for (String jobName : this.getSortedJobNames()) {
                Trigger[] triggers;
                UrlFetchJobDetail jd = (UrlFetchJobDetail)this.scheduler.getJobDetail(jobName, this.getQueueName());
                if (jd == null || (triggers = this.scheduler.getTriggersOfJob(jobName, this.getQueueName())).length == 0) continue;
                if (triggers.length != 1) {
                    throw new IllegalStateException("Multiple triggers for task " + jobName + " in queue " + this.getQueueName());
                }
                long execTime = triggers[0].getStartTime().getTime();
                taskInfoList.add(new QueueStateInfo.TaskStateInfo(jd.getName(), execTime, jd.getAddRequest(), this.clock));
            }
        }
        catch (SchedulerException e) {
            throw new ApiProxy.ApplicationException(3);
        }
        Collections.sort(taskInfoList, new Comparator<QueueStateInfo.TaskStateInfo>(){

            @Override
            public int compare(QueueStateInfo.TaskStateInfo t1, QueueStateInfo.TaskStateInfo t2) {
                return Long.compare(t1.getEtaMillis(), t2.getEtaMillis());
            }
        });
        return new QueueStateInfo(this.queueXmlEntry, taskInfoList);
    }

    @Override
    boolean deleteTask(String taskName) {
        try {
            return this.scheduler.deleteJob(taskName, this.getQueueName());
        }
        catch (SchedulerException e) {
            throw new ApiProxy.ApplicationException(3);
        }
    }

    @Override
    void flush() {
        try {
            for (String name : this.scheduler.getJobNames(this.getQueueName())) {
                this.scheduler.deleteJob(name, this.getQueueName());
            }
        }
        catch (SchedulerException e) {
            throw new ApiProxy.ApplicationException(3);
        }
    }

    private JobExecutionContext getExecutionContext(UrlFetchJobDetail jobDetail) {
        SimpleTrigger trigger = new SimpleTrigger(jobDetail.getTaskName(), jobDetail.getQueueName());
        trigger.setJobDataMap(jobDetail.getJobDataMap());
        TriggerFiredBundle bundle = new TriggerFiredBundle((JobDetail)jobDetail, (Trigger)trigger, null, false, null, null, null, null);
        return new JobExecutionContext(this.scheduler, bundle, null);
    }

    @Override
    boolean runTask(String taskName) {
        Job job;
        JobExecutionContext context;
        try {
            UrlFetchJobDetail jd = (UrlFetchJobDetail)this.scheduler.getJobDetail(taskName, this.getQueueName());
            if (jd == null) {
                return false;
            }
            context = this.getExecutionContext(jd);
            job = (Job)jd.getJobClass().newInstance();
        }
        catch (SchedulerException e) {
            return false;
        }
        catch (IllegalAccessException e) {
            return false;
        }
        catch (InstantiationException e) {
            return false;
        }
        try {
            job.execute(context);
        }
        catch (JobExecutionException e) {
            logger.log(Level.SEVERE, "Exception executing task " + taskName + " on queue " + this.getQueueName(), e);
        }
        catch (RuntimeException rte) {
            logger.log(Level.SEVERE, "Exception executing task " + taskName + " on queue " + this.getQueueName(), rte);
        }
        return true;
    }
}

