/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search.dev;

import com.google.appengine.api.search.dev.GenericScorer;
import com.google.appengine.api.search.dev.MatchScorer;
import com.google.appengine.api.search.dev.SimpleFacet;
import com.google.appengine.api.search.dev.SimpleScorer;
import com.google.appengine.api.search.proto.SearchServicePb;
import com.google.apphosting.api.search.DocumentPb;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;

public abstract class Scorer {
    public abstract SearchResults search(IndexSearcher var1, Query var2, int var3, int var4) throws IOException;

    public static Scorer newInstance(final SearchServicePb.SearchParams searchParams, Map<String, Set<DocumentPb.FieldValue.ContentType>> fieldTypes) {
        final Scorer scorer = Scorer.newInstanceInternal(searchParams, fieldTypes);
        if (!SimpleFacet.isFacetingRequested(searchParams)) {
            return scorer;
        }
        return new Scorer(){

            @Override
            public SearchResults search(IndexSearcher indexSearcher, Query q, int offset, int limit) throws IOException {
                SearchResults normalResult = scorer.search(indexSearcher, q, offset, limit);
                SearchResults extendedResults = scorer.search(indexSearcher, q, 0, searchParams.getFacetDepth());
                return new SearchResults(normalResult.results, normalResult.totalHits, SimpleFacet.getFacetResult(searchParams, extendedResults.results));
            }
        };
    }

    private static Scorer newInstanceInternal(SearchServicePb.SearchParams searchParams, Map<String, Set<DocumentPb.FieldValue.ContentType>> fieldTypes) {
        if (searchParams.getSortSpecCount() != 0) {
            return GenericScorer.newInstance(searchParams, fieldTypes);
        }
        if (!searchParams.hasScorerSpec()) {
            return new SimpleScorer(SimpleScorer.naturalOrder());
        }
        return MatchScorer.newInstance(searchParams, fieldTypes);
    }

    public static class SearchResults {
        public final Result[] results;
        public int totalHits;
        public final SearchServicePb.FacetResult[] facetResults;

        SearchResults(Result[] results, int totalHits) {
            this(results, totalHits, new SearchServicePb.FacetResult[0]);
        }

        SearchResults(Result[] results, int totalHits, SearchServicePb.FacetResult[] facetResults) {
            this.results = results;
            this.totalHits = totalHits;
            this.facetResults = facetResults;
        }
    }

    public static abstract class Result {
        public final Document doc;

        public Result(Document doc) {
            this.doc = doc;
        }

        public abstract void addScores(SearchServicePb.SearchResult.Builder var1);
    }
}

