/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore.dev;

import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.dev.HighRepJobPolicy;
import com.google.apphosting.datastore.DatastoreV3Pb;
import com.google.storage.onestore.v3.OnestoreEntity;
import org.checkerframework.checker.nullness.qual.Nullable;

abstract class LocalDatastoreJob {
    final HighRepJobPolicy jobPolicy;
    final Key entityGroup;
    final long timestamp;
    boolean newJob = true;
    boolean applied = false;

    LocalDatastoreJob(HighRepJobPolicy jobPolicy, Key entityGroup, long timestamp) {
        if (jobPolicy == null) {
            throw new NullPointerException("jobPolicy cannot be null");
        }
        this.jobPolicy = jobPolicy;
        if (entityGroup == null) {
            throw new NullPointerException("entityGroup cannot be null");
        }
        this.entityGroup = entityGroup;
        this.timestamp = timestamp;
    }

    final boolean tryApply() {
        try {
            if (this.newJob) {
                if (this.jobPolicy.shouldApplyNewJob(this.entityGroup)) {
                    this.apply();
                    boolean bl = true;
                    return bl;
                }
            } else if (this.jobPolicy.shouldRollForwardExistingJob(this.entityGroup)) {
                this.apply();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.newJob = false;
        }
    }

    final void apply() {
        if (this.applied) {
            throw new IllegalStateException(String.format("Job on entity group %s was already applied.", this.entityGroup));
        }
        this.applied = true;
        this.applyInternal();
    }

    abstract void applyInternal();

    abstract DatastoreV3Pb.Cost calculateJobCost();

    abstract // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable OnestoreEntity.EntityProto getEntity(OnestoreEntity.Reference var1);

    abstract // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable OnestoreEntity.EntityProto getSnapshotEntity(OnestoreEntity.Reference var1);

    abstract long getMutationTimestamp(OnestoreEntity.Reference var1);
}

