/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.base;

import com.google.appengine.repackaged.com.google.common.flags.Flag;
import com.google.common.annotations.GoogleInternal;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.flags.FlagSpec;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.annotation.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@GoogleInternal
public class RotatingLogStream
extends OutputStream {
    private final String basename_;
    private final String linkname_;
    private final String extension_;
    private final DateFormat dateFormat_;
    private OutputStream output_;
    private long currentSize_;
    private long rotateSize_;
    private final List<Listener> listeners_ = Collections.synchronizedList(new ArrayList());
    private long currentCombinedLogSize_;
    private long maxCombinedLogSize_;
    private ArrayList<File> files_;
    private File currentFile_;
    private FileDescriptor currentFileDescriptor_;
    public static final long kDefaultRotateSize = 0x70800000L;
    public static final SimpleDateFormat kDefaultDateFormat = new SimpleDateFormat("-yyyy_MM_dd_HH_mm_ss");
    @FlagSpec(help="If enabled, then rotating logs will not create symbolic links from the base filename to the current log.  This is provided to avoid the Runtime.exec() call in RotatingLogStream that can cause OutOfMemoryError due to fork() temporarily doubling memory footprint.")
    static final Flag<Boolean> skipLogSymLinkCreation = Flag.value((boolean)false);
    private static volatile SymbolicLinkProvider symlinker = new SymbolicLinkProvider(){

        public void createSymbolicLink(String targetPath, String linkPath) throws IOException {
            Runtime.getRuntime().exec(new String[]{"/bin/ln", "-sf", targetPath, linkPath});
        }
    };

    public static void setSymbolicLinkProvider(SymbolicLinkProvider p) {
        symlinker = p;
    }

    RotatingLogStream(String basename, @Nullable String linkname, @Nullable String extension, @Nullable DateFormat dateFormat, boolean allowSymLinkCreation) throws IOException {
        this.dateFormat_ = dateFormat;
        this.basename_ = basename;
        this.linkname_ = allowSymLinkCreation ? linkname : null;
        this.extension_ = extension;
        this.rotateSize_ = 0x70800000L;
        this.openNewFile();
    }

    public RotatingLogStream(String basename, @Nullable String linkname, @Nullable String extension, @Nullable DateFormat dateFormat) throws IOException {
        this(basename, linkname, extension, dateFormat, (Boolean)skipLogSymLinkCreation.get() == false);
    }

    public RotatingLogStream(String basename, @Nullable String linkname, @Nullable DateFormat dateFormat) throws IOException {
        this(basename, linkname, null, dateFormat);
    }

    public RotatingLogStream(String basename) throws IOException {
        this(basename, basename, kDefaultDateFormat);
    }

    public synchronized void rotate() throws IOException {
        this.flush();
        this.close();
        this.openNewFile();
    }

    public synchronized void setRotateSize(long rotateSize) {
        this.rotateSize_ = rotateSize;
    }

    public synchronized void setMaxCombinedLogSize(long maxCombinedLogSize) {
        if (maxCombinedLogSize < this.rotateSize_) {
            throw new IllegalArgumentException("Max combined log size should be >= single log rotate size");
        }
        this.maxCombinedLogSize_ = maxCombinedLogSize;
        if (this.files_ == null) {
            this.files_ = this.findAllFilesWithBasenameAndExtension(this.basename_, this.extension_);
            long length = 0L;
            for (File file : this.files_) {
                length += file.length();
            }
            this.currentCombinedLogSize_ = length;
        }
    }

    @Override
    public synchronized void close() throws IOException {
        this.output_.close();
        this.output_ = null;
    }

    @Override
    public synchronized void flush() throws IOException {
        this.output_.flush();
    }

    @Override
    public synchronized void write(byte[] b) throws IOException {
        this.checkRotate(b.length);
        this.output_.write(b);
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) throws IOException {
        this.checkRotate(len);
        this.output_.write(b, off, len);
    }

    @Override
    public synchronized void write(int b) throws IOException {
        this.checkRotate(1);
        this.output_.write(b);
    }

    public File getCurrentFile() {
        return this.currentFile_;
    }

    public FileDescriptor getCurrentFileDescriptor() {
        return this.currentFileDescriptor_;
    }

    protected OutputStream wrapFileOutputStream(FileOutputStream fileOutputStream) throws IOException {
        return new BufferedOutputStream(fileOutputStream);
    }

    private void openNewFile() throws IOException {
        File parentFile;
        String fn = this.getNextFilename();
        this.currentFile_ = new File(fn);
        if (this.files_ != null) {
            this.files_.add(this.currentFile_);
        }
        String absFn = this.currentFile_.getAbsolutePath();
        this.currentSize_ = this.currentFile_.length();
        if (this.rotateSize_ != 0L && this.currentSize_ >= this.rotateSize_) {
            System.err.println("Current log files size >= rotate size for " + absFn);
        }
        if ((parentFile = this.currentFile_.getParentFile()) != null) {
            parentFile.mkdirs();
        }
        FileOutputStream fileOutputStream = new FileOutputStream(fn, true);
        this.currentFileDescriptor_ = fileOutputStream.getFD();
        this.output_ = this.wrapFileOutputStream(fileOutputStream);
        if (this.linkname_ != null) {
            String linkSrc = fn;
            int lastSlash = this.linkname_.lastIndexOf(47);
            if (lastSlash != -1 && linkSrc.startsWith(this.linkname_.substring(0, lastSlash + 1))) {
                linkSrc = linkSrc.substring(lastSlash + 1);
            }
            symlinker.createSymbolicLink(linkSrc, this.linkname_);
        }
        for (Listener listener : this.listeners_) {
            listener.logFileCreated(this.output_);
        }
    }

    protected String getNextFilename() {
        if (this.extension_ == null) {
            return this.basename_ + this.dateFormat_.format(new Date());
        }
        return this.basename_ + this.dateFormat_.format(new Date()) + this.extension_;
    }

    protected void checkRotate(int lenToWrite) throws IOException {
        if (this.files_ == null) {
            if (this.currentSize_ + (long)lenToWrite >= this.rotateSize_ && new File(this.getNextFilename()).length() + (long)lenToWrite < this.rotateSize_) {
                this.rotate();
            }
        } else if (this.currentSize_ + (long)lenToWrite >= this.rotateSize_) {
            this.updateCombinedLogSizeForRotate(lenToWrite);
            this.rotate();
        }
        this.currentSize_ += (long)lenToWrite;
    }

    protected void updateCombinedLogSizeForRotate(int lenToWrite) {
        if (this.files_ != null) {
            this.currentCombinedLogSize_ += this.currentSize_;
            long totalExpectedSize = this.currentCombinedLogSize_ + (long)lenToWrite;
            if (totalExpectedSize >= this.maxCombinedLogSize_) {
                this.deleteOldestLogFiles(totalExpectedSize);
            }
        }
    }

    @VisibleForTesting
    long getCurrentCombinedLogSize() {
        return this.currentCombinedLogSize_;
    }

    @VisibleForTesting
    long getCurrentLogSize() {
        return this.currentSize_;
    }

    protected void deleteOldestLogFiles(long totalExpectedLogsSize) {
        while (totalExpectedLogsSize >= this.maxCombinedLogSize_) {
            if (this.files_.isEmpty()) {
                return;
            }
            int oldestFileIdx = 0;
            long oldestFileTimestamp = this.files_.get(oldestFileIdx).lastModified();
            for (int i = 0; i < this.files_.size(); ++i) {
                long timestamp = this.files_.get(i).lastModified();
                if (timestamp >= oldestFileTimestamp) continue;
                oldestFileTimestamp = timestamp;
                oldestFileIdx = i;
            }
            File f = this.files_.remove(oldestFileIdx);
            long fLength = f.length();
            this.currentCombinedLogSize_ -= fLength;
            totalExpectedLogsSize -= fLength;
            f.delete();
        }
    }

    public void addListener(Listener listener) {
        this.listeners_.add(listener);
    }

    private ArrayList<File> findAllFilesWithBasenameAndExtension(String basename, final @Nullable String extension) {
        String dir = ".";
        int dirSeparatorIdx = basename.lastIndexOf(File.separatorChar);
        if (dirSeparatorIdx != -1) {
            dir = basename.substring(0, dirSeparatorIdx);
            basename = basename.substring(dirSeparatorIdx + 1);
        }
        final String relativeBaseName = basename;
        File[] files = new File(dir).listFiles(new FilenameFilter(){

            public boolean accept(File directory, String name) {
                if (name.equals(RotatingLogStream.this.linkname_)) {
                    return false;
                }
                if (name.startsWith(relativeBaseName)) {
                    if (extension != null) {
                        return name.endsWith(extension);
                    }
                    return true;
                }
                return false;
            }
        });
        ArrayList<File> result = new ArrayList<File>();
        for (File file : files) {
            result.add(file);
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        String s;
        RotatingLogStream log = new RotatingLogStream("/tmp/testrlog-", null, null);
        log.setRotateSize(200L);
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        while ((s = in.readLine()) != null) {
            s = s + '\n';
            log.write(s.getBytes());
        }
        log.close();
    }

    public static interface SymbolicLinkProvider {
        public void createSymbolicLink(String var1, String var2) throws IOException;
    }

    public static interface Listener {
        public void logFileCreated(OutputStream var1);
    }
}

