/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development.ee10;

import com.google.appengine.api.log.dev.LocalLogService;
import com.google.appengine.repackaged.com.google.common.base.Optional;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.html.HtmlEscapers;
import com.google.appengine.tools.development.ApiProxyLocal;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.WriteListener;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.TimeZone;
import java.util.Vector;

public class ResponseRewriterFilter
implements Filter {
    private final long emulatedResponseTime;
    private LocalLogService logService;
    private static final String BLOB_KEY_HEADER = "X-AppEngine-BlobKey";
    private static final String DEVELOPMENT_SERVER = "Development/1.0";
    private static final int[] NO_BODY_RESPONSE_STATUSES = new int[]{100, 101, 204, 304};
    private static final String[] IGNORE_REQUEST_HEADERS = new String[]{"Accept-Encoding", "Connection", "Keep-Alive", "Proxy-Authorization", "TE", "Trailer", "Transfer-Encoding"};
    private static final String[] IGNORE_RESPONSE_HEADERS = new String[]{"Connection", "Content-Encoding", "Date", "Keep-Alive", "Proxy-Authenticate", "Server", "Trailer", "Transfer-Encoding", "Upgrade"};

    public ResponseRewriterFilter() {
        this.emulatedResponseTime = Long.MIN_VALUE;
    }

    public ResponseRewriterFilter(long mockTimestamp) {
        this.emulatedResponseTime = mockTimestamp;
    }

    protected ResponseWrapper getResponseWrapper(HttpServletResponse response) {
        return new ResponseWrapper(response);
    }

    public void init(FilterConfig filterConfig) {
        Object apiProxyDelegate = filterConfig.getServletContext().getAttribute("com.google.appengine.devappserver.ApiProxyLocal");
        if (apiProxyDelegate instanceof ApiProxyLocal) {
            ApiProxyLocal apiProxyLocal = (ApiProxyLocal)apiProxyDelegate;
            this.logService = (LocalLogService)apiProxyLocal.getService("logservice");
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletResponse httpresponse;
        HttpServletRequest httprequest;
        try {
            httprequest = (HttpServletRequest)request;
            httpresponse = (HttpServletResponse)response;
        }
        catch (ClassCastException e) {
            throw new ServletException((Throwable)e);
        }
        RequestWrapper wrappedRequest = new RequestWrapper(httprequest);
        ResponseWrapper wrappedResponse = this.getResponseWrapper(httpresponse);
        chain.doFilter((ServletRequest)wrappedRequest, (ServletResponse)wrappedResponse);
        Preconditions.checkState((!response.isCommitted() ? 1 : 0) != 0, (Object)"Response has already been committed");
        long responseTime = this.emulatedResponseTime == Long.MIN_VALUE ? System.currentTimeMillis() : this.emulatedResponseTime;
        this.ignoreHeadersRewriter(wrappedResponse);
        this.serverDateRewriter(wrappedResponse, responseTime);
        this.cacheRewriter(wrappedResponse, responseTime);
        this.blobServeRewriter(wrappedResponse);
        this.contentLengthRewriter((HttpServletRequest)wrappedRequest, wrappedResponse);
        wrappedResponse.reallyCommit();
    }

    private void ignoreHeadersRewriter(ResponseWrapper response) {
        for (String h : IGNORE_RESPONSE_HEADERS) {
            if (!response.containsHeader(h)) continue;
            response.reallySetHeader(h, null);
        }
    }

    private void serverDateRewriter(ResponseWrapper response, long responseTime) {
        response.reallySetHeader("Server", DEVELOPMENT_SERVER);
        response.reallySetDateHeader("Date", responseTime);
    }

    private static boolean responseMayHaveBody(int status) {
        for (int s : NO_BODY_RESPONSE_STATUSES) {
            if (status != s) continue;
            return false;
        }
        return true;
    }

    private void cacheRewriter(ResponseWrapper response, long responseTime) {
        if (!ResponseRewriterFilter.responseMayHaveBody(response.getStatus())) {
            return;
        }
        if (!response.containsHeader("Cache-Control")) {
            response.reallySetHeader("Cache-Control", "no-cache");
            if (!response.containsHeader("Expires")) {
                response.reallySetHeader("Expires", "Mon, 01 Jan 1990 00:00:00 GMT");
            }
        }
        if (response.containsHeader("Set-Cookie")) {
            long expires = response.getExpires();
            if (expires == Long.MIN_VALUE || expires >= responseTime) {
                response.reallySetDateHeader("Expires", responseTime);
            }
            Vector<String> cacheDirectives = new Vector<String>(response.getCacheControl());
            while (cacheDirectives.remove("public")) {
            }
            if (!(cacheDirectives.contains("private") || cacheDirectives.contains("no-cache") || cacheDirectives.contains("no-store"))) {
                cacheDirectives.add("private");
            }
            StringBuilder newCacheControl = new StringBuilder();
            for (String directive : cacheDirectives) {
                if (newCacheControl.length() > 0) {
                    newCacheControl.append(", ");
                }
                newCacheControl.append(directive);
            }
            response.reallySetHeader("Cache-Control", newCacheControl.toString());
        }
    }

    private void blobServeRewriter(ResponseWrapper response) {
        if (response.containsHeader(BLOB_KEY_HEADER)) {
            response.reallyResetBuffer();
        }
    }

    private void contentLengthRewriter(HttpServletRequest request, ResponseWrapper response) {
        Optional responseSize;
        response.flushPrintWriter();
        if (request.getMethod().equals("HEAD")) {
            response.reallyResetBuffer();
            responseSize = Optional.absent();
        } else if (!ResponseRewriterFilter.responseMayHaveBody(response.getStatus())) {
            response.reallySetHeader("Content-Length", null);
            response.reallyResetBuffer();
            responseSize = Optional.absent();
        } else {
            response.reallySetHeader("Content-Length", Long.toString(response.getBodyLength()));
            responseSize = Optional.of((Object)response.getBodyLength());
        }
        if (this.logService != null) {
            if (responseSize.isPresent()) {
                this.logService.registerResponseSize(((Integer)responseSize.get()).intValue());
            } else {
                this.logService.clearResponseSize();
            }
        }
    }

    public void destroy() {
    }

    public static class ResponseWrapper
    extends HttpServletResponseWrapper {
        private int status = 200;
        private long expires = Long.MIN_VALUE;
        private final Vector<String> cacheControl = new Vector();
        protected final ByteArrayOutputStream body = new ByteArrayOutputStream();
        protected ServletOutputStream bodyServletStream = null;
        protected PrintWriter bodyPrintWriter = null;
        private boolean committed = false;
        private static final String DATE_FORMAT_STRING = "E, dd MMM yyyy HH:mm:ss 'GMT'";

        public ResponseWrapper(HttpServletResponse response) {
            super(response);
        }

        public ServletOutputStream getOutputStream() {
            if (this.bodyServletStream != null) {
                return this.bodyServletStream;
            }
            Preconditions.checkState((this.bodyPrintWriter == null ? 1 : 0) != 0, (Object)"getWriter has already been called");
            this.bodyServletStream = new ServletOutputStreamWrapper(this.body);
            return this.bodyServletStream;
        }

        public PrintWriter getWriter() throws UnsupportedEncodingException {
            if (this.bodyPrintWriter != null) {
                return this.bodyPrintWriter;
            }
            Preconditions.checkState((this.bodyServletStream == null ? 1 : 0) != 0, (Object)"getOutputStream has already been called");
            this.bodyPrintWriter = new PrintWriter(new OutputStreamWriter((OutputStream)this.body, this.getCharacterEncoding()));
            return this.bodyPrintWriter;
        }

        public void setCharacterEncoding(String charset) {
            if (this.bodyPrintWriter != null || this.isCommitted()) {
                return;
            }
            super.setCharacterEncoding(charset);
        }

        public void setContentLength(int len) {
            if (this.isCommitted()) {
                return;
            }
            super.setContentLength(len);
        }

        public void setContentType(String type) {
            if (this.isCommitted()) {
                return;
            }
            if (type != null && ResponseWrapper.nonAscii(type)) {
                return;
            }
            if (this.bodyPrintWriter != null) {
                type = ResponseWrapper.stripCharsetFromMediaType(type);
            }
            super.setContentType(type);
        }

        public void setLocale(Locale loc) {
            if (this.isCommitted()) {
                return;
            }
            String oldCharacterEncoding = this.getCharacterEncoding();
            String oldContentType = this.getContentType();
            super.setLocale(loc);
            if (oldContentType != null || this.bodyPrintWriter != null) {
                super.setCharacterEncoding(oldCharacterEncoding);
            }
            if (oldContentType != null) {
                super.setContentType(oldContentType);
            }
        }

        public void setBufferSize(int size) {
            this.checkNotCommitted();
            super.setBufferSize(size);
        }

        public int getBufferSize() {
            return 0;
        }

        public void flushBuffer() {
            this.committed = true;
        }

        public void reset() {
            this.checkNotCommitted();
            super.reset();
        }

        public void resetBuffer() {
            this.checkNotCommitted();
            this.reallyResetBuffer();
        }

        public boolean isCommitted() {
            return this.committed || this.body.size() > 0;
        }

        void checkNotCommitted() {
            Preconditions.checkState((!this.isCommitted() ? 1 : 0) != 0, (Object)"Response has already been committed");
        }

        public void addCookie(Cookie cookie) {
            if (this.isCommitted()) {
                return;
            }
            super.addCookie(cookie);
        }

        public void addDateHeader(String name, long date) {
            if (this.isCommitted()) {
                return;
            }
            if (ResponseWrapper.nonAscii(name)) {
                return;
            }
            super.addDateHeader(name, date);
            if (name.equalsIgnoreCase("Expires")) {
                this.expires = date;
            }
        }

        public void addHeader(String name, String value) {
            if (this.isCommitted()) {
                return;
            }
            if (value == null) {
                return;
            }
            if (ResponseWrapper.nonAscii(name) || ResponseWrapper.nonAscii(value)) {
                return;
            }
            if (name.equalsIgnoreCase("Expires")) {
                try {
                    this.parseExpires(value);
                }
                catch (ParseException parseException) {}
            } else if (name.equalsIgnoreCase("Cache-Control")) {
                this.parseCacheControl(value);
            } else if (name.equalsIgnoreCase("Content-Type") && this.bodyPrintWriter != null) {
                value = ResponseWrapper.stripCharsetFromMediaType(value);
            }
            super.addHeader(name, value);
        }

        public void addIntHeader(String name, int value) {
            if (this.isCommitted()) {
                return;
            }
            if (ResponseWrapper.nonAscii(name)) {
                return;
            }
            super.addIntHeader(name, value);
        }

        public void sendError(int sc) throws IOException {
            this.checkNotCommitted();
            this.setStatus(sc);
            this.setErrorBody(Integer.toString(sc));
        }

        public void sendError(int sc, String msg) throws IOException {
            this.checkNotCommitted();
            this.setStatus(sc);
            this.setErrorBody(sc + " " + (msg == null ? "" : HtmlEscapers.htmlEscaper().escape(msg)));
        }

        private void setErrorBody(String errorText) throws IOException {
            this.setHeader("Content-Type", "text/html; charset=iso-8859-1");
            String bodyText = "<html><head><title>Error " + errorText + "</title></head>\n<body><h2>Error " + errorText + "</h2></body>\n</html>";
            this.body.write(bodyText.getBytes("iso-8859-1"));
        }

        public void sendRedirect(String location) {
            this.checkNotCommitted();
            this.setStatus(302);
            this.resetBuffer();
            this.setHeader("Location", this.encodeRedirectURL(location));
            this.status = 302;
        }

        public void setDateHeader(String name, long date) {
            if (this.isCommitted()) {
                return;
            }
            if (ResponseWrapper.nonAscii(name)) {
                return;
            }
            this.reallySetDateHeader(name, date);
        }

        public void setHeader(String name, String value) {
            if (this.isCommitted()) {
                return;
            }
            if (ResponseWrapper.nonAscii(name) || value != null && ResponseWrapper.nonAscii(value)) {
                return;
            }
            if (name.equalsIgnoreCase("Content-Type") && this.bodyPrintWriter != null) {
                value = ResponseWrapper.stripCharsetFromMediaType(value);
            }
            this.reallySetHeader(name, value);
        }

        public void setIntHeader(String name, int value) {
            if (this.isCommitted()) {
                return;
            }
            if (ResponseWrapper.nonAscii(name)) {
                return;
            }
            if (name.equalsIgnoreCase("Expires")) {
                this.expires = Long.MIN_VALUE;
            }
            super.setIntHeader(name, value);
        }

        public void setStatus(int sc) {
            if (this.isCommitted()) {
                return;
            }
            super.setStatus(sc);
            this.status = sc;
        }

        public int getStatus() {
            return this.status;
        }

        public long getExpires() {
            return this.expires;
        }

        public Vector<String> getCacheControl() {
            return this.cacheControl;
        }

        int getBodyLength() {
            return this.body.size();
        }

        void reallyCommit() throws IOException {
            this.flushPrintWriter();
            if (!this.isCommitted()) {
                return;
            }
            ServletOutputStream stream = super.getOutputStream();
            stream.write(this.body.toByteArray());
            this.body.reset();
        }

        void reallyResetBuffer() {
            this.body.reset();
            this.bodyServletStream = null;
            this.bodyPrintWriter = null;
        }

        void reallySetHeader(String name, String value) {
            super.setHeader(name, value);
            if (name.equalsIgnoreCase("Expires")) {
                if (value == null) {
                    this.expires = Long.MIN_VALUE;
                } else {
                    try {
                        this.parseExpires(value);
                    }
                    catch (ParseException e) {
                        this.expires = Long.MIN_VALUE;
                    }
                }
            } else if (name.equalsIgnoreCase("Cache-Control")) {
                this.cacheControl.clear();
                if (value != null) {
                    this.parseCacheControl(value);
                }
            }
        }

        void reallySetDateHeader(String name, long date) {
            super.setDateHeader(name, date);
            if (name.equalsIgnoreCase("Expires")) {
                this.expires = date;
            }
        }

        void flushPrintWriter() {
            if (this.bodyPrintWriter != null) {
                this.bodyPrintWriter.flush();
            }
        }

        private void parseExpires(String date) throws ParseException {
            SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT_STRING);
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            Date parsedDate = dateFormat.parse(date);
            this.expires = parsedDate.getTime();
        }

        private void parseCacheControl(String directives) {
            String[] elements;
            for (String element : elements = directives.split(",")) {
                this.cacheControl.add(element.trim());
            }
        }

        private static String stripCharsetFromMediaType(String mediaType) {
            String newMediaType = null;
            for (String part : mediaType.split(";")) {
                if ((part = part.trim()).length() >= 8 && part.substring(0, 8).equalsIgnoreCase("charset=")) continue;
                newMediaType = newMediaType == null ? "" : newMediaType + "; ";
                newMediaType = newMediaType + part;
            }
            return newMediaType;
        }

        private static boolean nonAscii(String string) {
            for (char c : string.toCharArray()) {
                if (c < '\u0080') continue;
                return true;
            }
            return false;
        }

        public static class ServletOutputStreamWrapper
        extends ServletOutputStream {
            private final OutputStream stream;

            protected ServletOutputStreamWrapper(OutputStream stream) {
                this.stream = stream;
            }

            public void close() throws IOException {
                this.stream.close();
            }

            public void flush() throws IOException {
                this.stream.flush();
            }

            public void write(byte[] b) throws IOException {
                this.stream.write(b);
            }

            public void write(byte[] b, int off, int len) throws IOException {
                this.stream.write(b, off, len);
            }

            public void write(int b) throws IOException {
                this.stream.write(b);
            }

            public boolean isReady() {
                return true;
            }

            public void setWriteListener(WriteListener writeListener) {
                throw new UnsupportedOperationException();
            }
        }
    }

    private static class RequestWrapper
    extends HttpServletRequestWrapper {
        public RequestWrapper(HttpServletRequest request) {
            super(request);
        }

        private static boolean validHeader(String name) {
            for (String h : IGNORE_REQUEST_HEADERS) {
                if (!h.equalsIgnoreCase(name)) continue;
                return false;
            }
            return true;
        }

        public long getDateHeader(String name) {
            return RequestWrapper.validHeader(name) ? super.getDateHeader(name) : -1L;
        }

        public String getHeader(String name) {
            return RequestWrapper.validHeader(name) ? super.getHeader(name) : null;
        }

        public Enumeration<String> getHeaders(String name) {
            if (RequestWrapper.validHeader(name)) {
                Enumeration headers = super.getHeaders(name);
                return headers;
            }
            return new Enumeration<String>(){

                @Override
                public boolean hasMoreElements() {
                    return false;
                }

                @Override
                public String nextElement() {
                    throw new NoSuchElementException();
                }
            };
        }

        public Enumeration<String> getHeaderNames() {
            Enumeration headerNames = super.getHeaderNames();
            return new HeaderFilterEnumeration(headerNames);
        }

        public int getIntHeader(String name) {
            return RequestWrapper.validHeader(name) ? super.getIntHeader(name) : -1;
        }

        private static class HeaderFilterEnumeration
        implements Enumeration<String> {
            private final Enumeration<?> allNames;
            private String nextName;

            HeaderFilterEnumeration(Enumeration<String> allNames) {
                this.allNames = allNames;
                this.getNextValidName();
            }

            private void getNextValidName() {
                while (this.allNames.hasMoreElements()) {
                    String name = (String)this.allNames.nextElement();
                    if (!RequestWrapper.validHeader(name)) continue;
                    this.nextName = name;
                    return;
                }
                this.nextName = null;
            }

            @Override
            public boolean hasMoreElements() {
                return this.nextName != null;
            }

            @Override
            public String nextElement() {
                if (this.nextName == null) {
                    throw new NoSuchElementException();
                }
                String result = this.nextName;
                this.getNextValidName();
                return result;
            }
        }
    }
}

