/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep.converter;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.base.Strings;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableMap;
import com.google.appengine.repackaged.com.google.common.collect.Iterables;
import com.google.appengine.repackaged.com.google.common.collect.Maps;
import com.google.appengine.repackaged.com.google.protobuf.NullValue;
import com.google.cloud.datastore.core.rep.Value;
import com.google.cloud.datastore.core.rep.converter.EntityConverter;
import com.google.cloud.datastore.core.rep.converter.EntityRefConverter;
import com.google.cloud.datastore.core.rep.proto.Value;
import java.util.Map;

public class ValueConverter {
    private ValueConverter() {
    }

    public static com.google.cloud.datastore.core.rep.proto.Value toProto(Value rep) {
        Value.Builder builder = com.google.cloud.datastore.core.rep.proto.Value.newBuilder();
        switch (rep.type()) {
            case NULL: {
                builder.setNullValue(NullValue.NULL_VALUE);
                break;
            }
            case BOOLEAN: {
                builder.setBooleanValue(rep.asBoolean());
                break;
            }
            case LONG: {
                builder.setLongValue(rep.asLong());
                break;
            }
            case DOUBLE: {
                builder.setDoubleValue(rep.asDouble());
                break;
            }
            case TIMESTAMP: {
                builder.setTimestampValue(rep.asTimestamp());
                break;
            }
            case STRING: {
                builder.setStringValue(rep.asString());
                break;
            }
            case BYTES: {
                builder.setBytesValue(rep.asBytes());
                break;
            }
            case ENTITY_REF: {
                builder.setEntityRefValue(EntityRefConverter.toProto(rep.asEntityRef()));
                break;
            }
            case GEO_POINT: {
                builder.setGeoPointValue(rep.asGeoPoint());
                break;
            }
            case ARRAY: {
                builder.getArrayValueBuilder().addAllValues(Iterables.transform(rep.asArray(), ValueConverter::toProto));
                break;
            }
            case MAP: {
                builder.getMapValueBuilder().putAllEntries(Maps.transformValues(rep.asMap(), ValueConverter::toProto));
                break;
            }
            case ENTITY: {
                builder.setEntityValue(EntityConverter.toProto(rep.asEntity()));
                break;
            }
            case LEGACY_USER: {
                builder.setUserValue(ValueConverter.toProto(rep.asLegacyUser()));
                break;
            }
            case LEGACY_TIMESTAMP_MICROSECONDS: {
                builder.setLegacyTimestampMicrosValue(rep.asLegacyTimestampMicroseconds());
                break;
            }
            case GEO_REGION: 
            case RESOURCE_REF: {
                String string = String.valueOf((Object)rep.type());
                throw new IllegalArgumentException(new StringBuilder(22 + String.valueOf(string).length()).append("Unexpected value type ").append(string).toString());
            }
        }
        return builder.setMeaning(rep.meaning().ordinal()).setDatastoreIndexing(ValueConverter.toProto(rep.datastoreIndexing())).build();
    }

    private static Value.LegacyUser toProto(Value.LegacyUser rep) {
        Value.LegacyUser.Builder builder = Value.LegacyUser.newBuilder().setEmail(rep.email()).setAuthDomain(rep.authDomain()).setObfuscatedGaiaId(rep.obfuscatedGaiaId());
        Preconditions.checkArgument((rep.federatedIdentity() == null || !rep.federatedIdentity().isEmpty() ? 1 : 0) != 0);
        builder.setFederatedIdentity(Strings.nullToEmpty((String)rep.federatedIdentity()));
        Preconditions.checkArgument((rep.federatedProvider() == null || !rep.federatedProvider().isEmpty() ? 1 : 0) != 0);
        return builder.setFederatedProvider(Strings.nullToEmpty((String)rep.federatedProvider())).build();
    }

    private static Value.DatastoreIndexing toProto(Value.DatastoreIndexing indexing) {
        switch (indexing) {
            case INCLUDE: {
                return Value.DatastoreIndexing.INCLUDE;
            }
            case EXCLUDE: {
                return Value.DatastoreIndexing.EXCLUDE;
            }
        }
        throw new AssertionError((Object)"unreachable");
    }

    public static Value toRep(com.google.cloud.datastore.core.rep.proto.Value proto) {
        Value rep = null;
        switch (proto.getValueTypeCase()) {
            case NULL_VALUE: {
                rep = Value.NULL;
                break;
            }
            case BOOLEAN_VALUE: {
                rep = Value.createBoolean(proto.getBooleanValue());
                break;
            }
            case LONG_VALUE: {
                rep = Value.createLong(proto.getLongValue());
                break;
            }
            case DOUBLE_VALUE: {
                rep = Value.createDouble(proto.getDoubleValue());
                break;
            }
            case TIMESTAMP_VALUE: {
                rep = Value.createTimestamp(proto.getTimestampValue());
                break;
            }
            case STRING_VALUE: {
                rep = Value.createString(proto.getStringValue());
                break;
            }
            case BYTES_VALUE: {
                rep = Value.createBytes(proto.getBytesValue());
                break;
            }
            case ENTITY_REF_VALUE: {
                rep = Value.createEntityRef(EntityRefConverter.toRep(proto.getEntityRefValue()));
                break;
            }
            case GEO_POINT_VALUE: {
                rep = Value.createGeoPoint(proto.getGeoPointValue());
                break;
            }
            case ARRAY_VALUE: {
                rep = Value.createArray((ImmutableList<Value>)ImmutableList.copyOf((Iterable)Iterables.transform(proto.getArrayValue().getValuesList(), ValueConverter::toRep)));
                break;
            }
            case MAP_VALUE: {
                rep = Value.createMap((ImmutableMap<String, Value>)ImmutableMap.copyOf((Map)Maps.transformValues(proto.getMapValue().getEntriesMap(), ValueConverter::toRep)));
                break;
            }
            case ENTITY_VALUE: {
                rep = Value.createEntity(EntityConverter.toRep(proto.getEntityValue()));
                break;
            }
            case USER_VALUE: {
                rep = Value.createLegacyUser(ValueConverter.toRep(proto.getUserValue()));
                break;
            }
            case LEGACY_TIMESTAMP_MICROS_VALUE: {
                rep = Value.createLegacyTimestampMicroseconds(proto.getLegacyTimestampMicrosValue());
                break;
            }
            case VALUETYPE_NOT_SET: {
                throw new IllegalArgumentException("Unknown value type.");
            }
        }
        Value.Meaning meaning = Value.Meaning.createFromOrdinal(proto.getMeaning());
        Preconditions.checkArgument((meaning != null ? 1 : 0) != 0, (String)"Invalid meaning: %s", (int)proto.getMeaning());
        return rep.withMeaning(meaning).withDatastoreIndexing(ValueConverter.toRep(proto.getDatastoreIndexing()));
    }

    private static Value.LegacyUser toRep(Value.LegacyUser proto) {
        return Value.LegacyUser.create(proto.getEmail(), proto.getAuthDomain(), proto.getObfuscatedGaiaId(), Strings.emptyToNull((String)proto.getFederatedIdentity()), Strings.emptyToNull((String)proto.getFederatedProvider()));
    }

    private static Value.DatastoreIndexing toRep(Value.DatastoreIndexing datastoreIndexing) {
        switch (datastoreIndexing) {
            case UNSPECIFIED: 
            case UNRECOGNIZED: {
                throw new IllegalArgumentException("Unknown datastore indexing");
            }
            case INCLUDE: {
                return Value.DatastoreIndexing.INCLUDE;
            }
            case EXCLUDE: {
                return Value.DatastoreIndexing.EXCLUDE;
            }
        }
        throw new AssertionError((Object)"unreachable");
    }
}

