/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep.converter;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.protobuf.Empty;
import com.google.cloud.datastore.core.rep.DatabaseRef;
import com.google.cloud.datastore.core.rep.EntityRef;
import com.google.cloud.datastore.core.rep.PartitionRef;
import com.google.cloud.datastore.core.rep.proto.DatabaseRef;
import com.google.cloud.datastore.core.rep.proto.EntityRef;
import java.util.List;

public class EntityRefConverter {
    private EntityRefConverter() {
    }

    public static com.google.cloud.datastore.core.rep.proto.DatabaseRef toProto(DatabaseRef rep) {
        DatabaseRef.Builder builder = com.google.cloud.datastore.core.rep.proto.DatabaseRef.newBuilder().setClusterId(rep.partitionId()).setProjectId(rep.rawProjectId()).setDatabaseId(rep.databaseId());
        if (rep.isMetadata()) {
            Preconditions.checkArgument((rep.directory().replicaId() != null ? 1 : 0) != 0, (Object)"replica ID must be specified for metadata directories");
            builder.setMetadataReplica(rep.directory().replicaId());
        } else {
            builder.setUser(Empty.getDefaultInstance());
        }
        return builder.build();
    }

    public static com.google.cloud.datastore.core.rep.proto.PartitionRef toProto(PartitionRef rep) {
        return com.google.cloud.datastore.core.rep.proto.PartitionRef.newBuilder().setDatabaseRef(EntityRefConverter.toProto(rep.databaseRef())).setNamespace(rep.namespace()).build();
    }

    public static com.google.cloud.datastore.core.rep.proto.EntityRef toProto(EntityRef rep) {
        return com.google.cloud.datastore.core.rep.proto.EntityRef.newBuilder().setPartitionRef(EntityRefConverter.toProto(rep.partitionRef())).setPath(EntityRefConverter.toProto(rep.path())).build();
    }

    public static EntityRef.Path toProto(EntityRef.Path rep) {
        EntityRef.Path.Builder builder = EntityRef.Path.newBuilder();
        for (EntityRef.PathElement element : rep.elements()) {
            builder.addElements(EntityRefConverter.toProto(element));
        }
        return builder.build();
    }

    private static EntityRef.Path.Element toProto(EntityRef.PathElement rep) {
        EntityRef.Path.Element.Builder builder = EntityRef.Path.Element.newBuilder().setCollectionId(rep.collectionId());
        if (rep.resourceId() != null) {
            switch (rep.resourceId().typeOf()) {
                case STRING: {
                    builder.setName(rep.resourceId().string());
                    break;
                }
                case NUMBER: {
                    builder.setId(rep.resourceId().number());
                }
            }
        }
        return builder.build();
    }

    public static DatabaseRef toRep(com.google.cloud.datastore.core.rep.proto.DatabaseRef proto) {
        DatabaseRef databaseRef = DatabaseRef.createForProject(proto.getClusterId(), proto.getProjectId(), proto.getDatabaseId());
        switch (proto.getDirectoryCase()) {
            case USER: {
                return databaseRef.withUserDirectory();
            }
            case METADATA_REPLICA: {
                return databaseRef.withDirectory(DatabaseRef.Directory.replicated(proto.getMetadataReplica()));
            }
            case DIRECTORY_NOT_SET: {
                throw new IllegalArgumentException("directory_id must be set");
            }
        }
        throw new AssertionError((Object)proto.getDirectoryCase());
    }

    public static PartitionRef toRep(com.google.cloud.datastore.core.rep.proto.PartitionRef proto) {
        return PartitionRef.createFromDatabaseRefAndNamespace(EntityRefConverter.toRep(proto.getDatabaseRef()), proto.getNamespace());
    }

    public static EntityRef toRep(com.google.cloud.datastore.core.rep.proto.EntityRef proto) {
        return EntityRef.create(EntityRefConverter.toRep(proto.getPartitionRef()), EntityRefConverter.toRep(proto.getPath()));
    }

    private static EntityRef.Path toRep(EntityRef.Path proto) {
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)proto.getElementsCount());
        for (EntityRef.Path.Element element : proto.getElementsList()) {
            builder.add((Object)EntityRefConverter.toRep(element));
        }
        return EntityRef.Path.create((List<EntityRef.PathElement>)builder.build());
    }

    private static EntityRef.PathElement toRep(EntityRef.Path.Element proto) {
        switch (proto.getResourceIdCase()) {
            case ID: {
                return EntityRef.PathElement.create(proto.getCollectionId(), EntityRef.ResourceId.ofNumber(proto.getId()));
            }
            case NAME: {
                return EntityRef.PathElement.create(proto.getCollectionId(), EntityRef.ResourceId.ofString(proto.getName()));
            }
            case RESOURCEID_NOT_SET: {
                return EntityRef.PathElement.create(proto.getCollectionId(), null);
            }
        }
        throw new AssertionError((Object)"Unreachable code.");
    }
}

