/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep.converter;

import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.protobuf.Int32Value;
import com.google.cloud.datastore.core.exception.InvalidConversionException;
import com.google.cloud.datastore.core.rep.Cursor;
import com.google.cloud.datastore.core.rep.DatabaseRef;
import com.google.cloud.datastore.core.rep.EntityRef;
import com.google.cloud.datastore.core.rep.IndexValue;
import com.google.cloud.datastore.core.rep.converter.IndexValueFromRepConverter;
import com.google.cloud.datastore.core.rep.converter.IndexValueToRepConverter;
import com.google.cloud.datastore.core.rep.proto.QueryResumeToken;
import java.util.List;
import java.util.function.Function;

public class CursorConverter {
    public static final CursorConverter INSTANCE = new CursorConverter();

    private CursorConverter() {
    }

    public static QueryResumeToken toQueryResumeToken(Cursor cursor, Function<EntityRef, IndexValue.EntityRef> entityRefToIndexValue, long queryFingerprint, int offsetRemaining, int limitRemaining) {
        QueryResumeToken.V1.Builder apiQrtV1Builder = QueryResumeToken.V1.newBuilder().setFingerprint(queryFingerprint);
        for (IndexValue indexValue : cursor.indexValues()) {
            com.google.cloud.datastore.core.rep.proto.IndexValue apiIndexValue = IndexValueFromRepConverter.INSTANCE.convertIndexValue(indexValue);
            apiQrtV1Builder.addIndexValues(apiIndexValue);
        }
        IndexValue.EntityRef keyIndexValue = entityRefToIndexValue.apply(cursor.key());
        com.google.cloud.datastore.core.rep.proto.IndexValue apiKeyEntityRefIndexValue = IndexValueFromRepConverter.INSTANCE.convertEntityRefRelDatabase(keyIndexValue);
        apiQrtV1Builder.addIndexValues(apiKeyEntityRefIndexValue).setOffsetRemaining(offsetRemaining);
        if (limitRemaining >= 0 && offsetRemaining == 0) {
            Int32Value limitRemainingInt32Value = Int32Value.of((int)limitRemaining);
            apiQrtV1Builder.setLimitRemaining(limitRemainingInt32Value);
        }
        return QueryResumeToken.newBuilder().setV1(apiQrtV1Builder.build()).build();
    }

    public static Cursor toCursor(QueryResumeToken queryResumeToken, DatabaseRef databaseRef, Function<IndexValue.EntityRef, EntityRef> indexValueToEntityRef) throws InvalidConversionException {
        QueryResumeToken.V1 apiQrtV1 = queryResumeToken.getV1();
        List<com.google.cloud.datastore.core.rep.proto.IndexValue> apiIndexValues = apiQrtV1.getIndexValuesList();
        int keyIndex = apiIndexValues.size() - 1;
        com.google.cloud.datastore.core.rep.proto.IndexValue apiIndexValueEntityRef = apiIndexValues.get(keyIndex);
        IndexValue.EntityRef keyIndexValue = IndexValueToRepConverter.INSTANCE.convertEntityRefRelDatabase(databaseRef, apiIndexValueEntityRef);
        EntityRef keyEntityRef = indexValueToEntityRef.apply(keyIndexValue);
        ImmutableList.Builder indexValuesBuilder = ImmutableList.builder();
        for (int index = 0; index < keyIndex; ++index) {
            com.google.cloud.datastore.core.rep.proto.IndexValue apiIndexValue = apiIndexValues.get(index);
            IndexValue indexValue = IndexValueToRepConverter.INSTANCE.convertIndexValue(databaseRef, apiIndexValue);
            indexValuesBuilder.add((Object)indexValue);
        }
        return Cursor.after(keyEntityRef, null, (ImmutableList<IndexValue>)indexValuesBuilder.build());
    }
}

